/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.event.VolumeChangeEvent;
import org.jitsi.service.neomedia.event.VolumeChangeListener;
import org.jitsi.util.Logger;

public class AbstractVolumeControl
implements VolumeControl,
GainControl {
    private static final Logger logger = Logger.getLogger(AbstractVolumeControl.class);
    protected static final float MIN_VOLUME_LEVEL = 0.0f;
    public static final int MIN_VOLUME_PERCENT = 0;
    protected static final float MAX_VOLUME_LEVEL = 1.0f;
    public static final int MAX_VOLUME_PERCENT = 200;
    private final List<WeakReference<VolumeChangeListener>> volumeChangeListeners = new ArrayList<WeakReference<VolumeChangeListener>>();
    private List<GainChangeListener> gainChangeListeners;
    protected float volumeLevel = AbstractVolumeControl.getDefaultVolumeLevel();
    private float gainReferenceLevel = AbstractVolumeControl.getGainReferenceLevel();
    private boolean mute = false;
    private float db;
    private final String volumeLevelConfigurationPropertyName;

    public AbstractVolumeControl(String volumeLevelConfigurationPropertyName) {
        this.volumeLevelConfigurationPropertyName = volumeLevelConfigurationPropertyName;
        this.loadVolume();
    }

    public static void applyGain(GainControl gainControl, byte[] buffer, int offset, int length) {
        if (gainControl.getMute()) {
            Arrays.fill(buffer, offset, offset + length, (byte)0);
        } else {
            float level = gainControl.getLevel() * 2.0f;
            if (level != 1.0f) {
                int toIndex = offset + length;
                for (int i = offset; i < toIndex; i += 2) {
                    int s;
                    int i1 = i + 1;
                    int si = s = (int)(buffer[i] & 0xFF | buffer[i1] << 8);
                    s = (si = (int)((float)si * level)) > Short.MAX_VALUE ? Short.MAX_VALUE : (si < Short.MIN_VALUE ? Short.MIN_VALUE : (int)((short)si));
                    buffer[i] = (byte)s;
                    buffer[i1] = (byte)(s >> 8);
                }
            }
        }
    }

    public float getVolume() {
        return this.volumeLevel;
    }

    public float getLevel() {
        return this.volumeLevel;
    }

    public float getMinValue() {
        return 0.0f;
    }

    public float getMaxValue() {
        return 1.0f;
    }

    public float setVolume(float value) {
        return this.setVolumeLevel(value);
    }

    public float setLevel(float level) {
        return this.setVolumeLevel(level);
    }

    private float setVolumeLevel(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        if (this.volumeLevel == value) {
            return value;
        }
        this.volumeLevel = value;
        this.updateHardwareVolume();
        this.fireVolumeChange();
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(this.volumeLevelConfigurationPropertyName, String.valueOf(this.volumeLevel));
        }
        this.db = AbstractVolumeControl.getDbFromPowerRatio(value, this.gainReferenceLevel);
        this.fireGainEvents();
        return this.volumeLevel;
    }

    public void setMute(boolean mute) {
        if (this.mute != mute) {
            this.mute = mute;
            this.fireVolumeChange();
            this.fireGainEvents();
        }
    }

    public boolean getMute() {
        return this.mute;
    }

    public float setDB(float gain) {
        if (this.db != gain) {
            this.db = gain;
            float volumeLevel = AbstractVolumeControl.getPowerRatioFromDb(gain, this.gainReferenceLevel);
            this.setVolumeLevel(volumeLevel);
        }
        return this.db;
    }

    public float getDB() {
        return this.db;
    }

    public void addGainChangeListener(GainChangeListener listener) {
        if (listener != null) {
            if (this.gainChangeListeners == null) {
                this.gainChangeListeners = new ArrayList<GainChangeListener>();
            }
            this.gainChangeListeners.add(listener);
        }
    }

    public void removeGainChangeListener(GainChangeListener listener) {
        if (listener != null && this.gainChangeListeners != null) {
            this.gainChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVolumeChangeListener(VolumeChangeListener listener) {
        List<WeakReference<VolumeChangeListener>> list = this.volumeChangeListeners;
        synchronized (list) {
            Iterator<WeakReference<VolumeChangeListener>> i = this.volumeChangeListeners.iterator();
            boolean contains = false;
            while (i.hasNext()) {
                VolumeChangeListener l = (VolumeChangeListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                contains = true;
            }
            if (!contains) {
                this.volumeChangeListeners.add(new WeakReference<VolumeChangeListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVolumeChangeListener(VolumeChangeListener listener) {
        List<WeakReference<VolumeChangeListener>> list = this.volumeChangeListeners;
        synchronized (list) {
            Iterator<WeakReference<VolumeChangeListener>> i = this.volumeChangeListeners.iterator();
            while (i.hasNext()) {
                VolumeChangeListener l = (VolumeChangeListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVolumeChange() {
        ArrayList<VolumeChangeListener> ls;
        List<WeakReference<VolumeChangeListener>> list = this.volumeChangeListeners;
        synchronized (list) {
            Iterator<WeakReference<VolumeChangeListener>> i = this.volumeChangeListeners.iterator();
            ls = new ArrayList<VolumeChangeListener>(this.volumeChangeListeners.size());
            while (i.hasNext()) {
                VolumeChangeListener l = (VolumeChangeListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                ls.add(l);
            }
        }
        VolumeChangeEvent changeEvent = new VolumeChangeEvent(this, this.volumeLevel, this.mute);
        for (VolumeChangeListener l : ls) {
            l.volumeChange(changeEvent);
        }
    }

    private void fireGainEvents() {
        if (this.gainChangeListeners != null) {
            GainChangeEvent gainchangeevent = new GainChangeEvent((GainControl)this, this.mute, this.db, this.volumeLevel);
            for (GainChangeListener gainchangelistener : this.gainChangeListeners) {
                gainchangelistener.gainChange(gainchangeevent);
            }
        }
    }

    public Component getControlComponent() {
        return null;
    }

    private static float getDbFromPowerRatio(float powerLevelRequired, float referencePowerLevel) {
        float powerRatio = powerLevelRequired / referencePowerLevel;
        float minPowerRatio = 1.0E-4f;
        float flooredPowerRatio = Math.max(powerRatio, minPowerRatio);
        return (float)(20.0 * Math.log10(flooredPowerRatio));
    }

    private static float getPowerRatioFromDb(float gainInDb, float referencePowerLevel) {
        return (float)Math.pow(10.0, gainInDb / 20.0f) * referencePowerLevel;
    }

    protected static float getDefaultVolumeLevel() {
        return 0.5f;
    }

    protected static float getGainReferenceLevel() {
        return AbstractVolumeControl.getDefaultVolumeLevel();
    }

    protected void updateHardwareVolume() {
    }

    protected void loadVolume() {
        try {
            String volumeLevelString;
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            if (cfg != null && (volumeLevelString = cfg.getString(this.volumeLevelConfigurationPropertyName)) != null) {
                this.volumeLevel = Float.parseFloat(volumeLevelString);
                if (logger.isDebugEnabled()) {
                    logger.debug("Restored volume: " + volumeLevelString);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Error restoring volume", t);
        }
    }
}

