/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileManager {
    private static final String TEMP_DIR_PREFIX = "tmp-mgr-";
    private static File sTmpDir = null;

    public static File createTempFile(String prefix, String suffix) throws IOException {
        if (sTmpDir == null) {
            String tmpDirName = System.getProperty("java.io.tmpdir");
            File tmpDir = File.createTempFile(TEMP_DIR_PREFIX, ".tmp", new File(tmpDirName));
            tmpDir.delete();
            File lockFile = new File(tmpDirName, tmpDir.getName() + ".lck");
            lockFile.createNewFile();
            lockFile.deleteOnExit();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory:" + tmpDir.getAbsolutePath());
            }
            sTmpDir = tmpDir;
        }
        return File.createTempFile(prefix, suffix, sTmpDir);
    }

    private static void recursiveDelete(File rootDir) throws IOException {
        File[] files = rootDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                TempFileManager.recursiveDelete(files[i]);
                continue;
            }
            if (files[i].delete()) continue;
            throw new IOException("Could not delete: " + files[i].getAbsolutePath());
        }
        if (!rootDir.delete()) {
            throw new IOException("Could not delete: " + rootDir.getAbsolutePath());
        }
    }

    static {
        FileFilter tmpDirFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(TempFileManager.TEMP_DIR_PREFIX);
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] tmpFiles = tmpDir.listFiles(tmpDirFilter);
        for (int i = 0; i < tmpFiles.length; ++i) {
            File tmpFile = tmpFiles[i];
            File lockFile = new File(tmpFile.getParent(), tmpFile.getName() + ".lck");
            if (lockFile.exists()) continue;
            Logger.getLogger("default").log(Level.FINE, "TempFileManager::deleting old temp directory " + tmpFile);
            try {
                TempFileManager.recursiveDelete(tmpFile);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger("default").log(Level.INFO, "TempFileManager::unable to delete " + tmpFile.getAbsolutePath());
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                ex.printStackTrace(new PrintStream(ostream));
                Logger.getLogger("default").log(Level.FINE, ostream.toString());
            }
        }
    }
}

