/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico;

import com.ctreber.aclib.codec.AbstractDecoder;
import com.ctreber.aclib.codec.StreamDecoder;
import com.ctreber.aclib.image.ico.AbstractBitmap;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.BitmapHeader;
import com.ctreber.aclib.image.ico.BitmapIndexed1BPP;
import com.ctreber.aclib.image.ico.BitmapIndexed4BPP;
import com.ctreber.aclib.image.ico.BitmapIndexed8BPP;
import com.ctreber.aclib.image.ico.BitmapRGB24BPP;
import com.ctreber.aclib.image.ico.BitmapRGB32BPP;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ICOFile
implements Comparable {
    private static final Logger LOG;
    private String _fileName;
    private int _reserved;
    private int _type;
    private int _imageCount;
    private final List _descriptors = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ctreber.aclib.image.ico.ICOFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
    }

    public ICOFile(String string) throws IOException {
        this(string, new StreamDecoder(new FileInputStream(string)));
    }

    public ICOFile(InputStream inputStream) throws IOException {
        this("[from stream]", new StreamDecoder(inputStream));
    }

    public ICOFile(URL uRL) throws IOException {
        this(uRL.toString(), new StreamDecoder(uRL.openStream()));
    }

    public ICOFile(byte[] byArray) throws IOException {
        this("[from buffer]", new StreamDecoder(new ByteArrayInputStream(byArray)));
    }

    public ICOFile(String string, AbstractDecoder abstractDecoder) throws IOException {
        this._fileName = string;
        this.read(abstractDecoder);
    }

    public int compareTo(Object object) {
        if (!(object instanceof ICOFile)) {
            throw new IllegalArgumentException("Can't compare to " + object.getClass());
        }
        return ((ICOFile)object).getFileName().compareTo(this.getFileName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(String.valueOf(this._fileName) + ", type: " + this._type + ", image count: " + this._imageCount);
        return stringBuffer.toString();
    }

    private void read(AbstractDecoder abstractDecoder) throws IOException {
        LOG.info("Reading " + this._fileName);
        abstractDecoder.setEndianess(1);
        this.readHeader(abstractDecoder);
        BitmapDescriptor[] bitmapDescriptorArray = this.readDescriptors(abstractDecoder);
        this.fillDescriptors(abstractDecoder, bitmapDescriptorArray);
        abstractDecoder.close();
        LOG.info("Done reading icon file");
    }

    private void readHeader(AbstractDecoder abstractDecoder) throws IOException {
        this._reserved = abstractDecoder.readUInt2();
        this._type = abstractDecoder.readUInt2();
        this._imageCount = abstractDecoder.readUInt2();
        LOG.info("Image count in header: " + this._imageCount);
        if (this._type != 1) {
            LOG.error("Unknown ICO type " + this._type);
            throw new IllegalArgumentException("Unknown ICO type " + this._type);
        }
        if (this._imageCount == 0) {
            this._imageCount = 1;
            LOG.warn("Corrected image count from 0 to 1");
        }
    }

    private void fillDescriptors(AbstractDecoder abstractDecoder, BitmapDescriptor[] bitmapDescriptorArray) throws IOException {
        int n = 0;
        while (n < bitmapDescriptorArray.length) {
            BitmapDescriptor bitmapDescriptor = bitmapDescriptorArray[n];
            this.fillDescriptor(abstractDecoder, bitmapDescriptor);
            this._descriptors.add(bitmapDescriptor);
            ++n;
        }
    }

    private void fillDescriptor(AbstractDecoder abstractDecoder, BitmapDescriptor bitmapDescriptor) throws IOException {
        if (abstractDecoder.getPos() != bitmapDescriptor.getOffset()) {
            LOG.info("FYI: Skipping some fluff, " + (bitmapDescriptor.getOffset() - abstractDecoder.getPos()));
            abstractDecoder.seek(bitmapDescriptor.getOffset());
        }
        bitmapDescriptor.setHeader(new BitmapHeader(abstractDecoder));
        bitmapDescriptor.setBitmap(this.readBitmap(abstractDecoder, bitmapDescriptor));
        this.doSomeChecks(bitmapDescriptor);
    }

    private BitmapDescriptor[] readDescriptors(AbstractDecoder abstractDecoder) throws IOException {
        BitmapDescriptor[] bitmapDescriptorArray = new BitmapDescriptor[this._imageCount];
        int n = 0;
        while (n < this._imageCount) {
            bitmapDescriptorArray[n] = this.readDescriptor(abstractDecoder);
            ++n;
        }
        return bitmapDescriptorArray;
    }

    private BitmapDescriptor readDescriptor(AbstractDecoder abstractDecoder) throws IOException {
        return new BitmapDescriptor(abstractDecoder);
    }

    private void doSomeChecks(BitmapDescriptor bitmapDescriptor) {
        if (bitmapDescriptor.getHeader().getWidth() * 2L != bitmapDescriptor.getHeader().getHeight()) {
            System.out.println(this + ": In header, height is not twice the width");
        }
    }

    private AbstractBitmap readBitmap(AbstractDecoder abstractDecoder, BitmapDescriptor bitmapDescriptor) throws IOException {
        int n = bitmapDescriptor.getHeader().getBPP();
        AbstractBitmap abstractBitmap = null;
        switch (n) {
            case 1: {
                abstractBitmap = new BitmapIndexed1BPP(bitmapDescriptor);
                break;
            }
            case 4: {
                abstractBitmap = new BitmapIndexed4BPP(bitmapDescriptor);
                break;
            }
            case 8: {
                abstractBitmap = new BitmapIndexed8BPP(bitmapDescriptor);
                break;
            }
            case 16: {
                LOG.error("16 BPP icons not supported - write to ct@ctreber.com if you need this");
                return null;
            }
            case 24: {
                abstractBitmap = new BitmapRGB24BPP(bitmapDescriptor);
                break;
            }
            case 32: {
                abstractBitmap = new BitmapRGB32BPP(bitmapDescriptor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit count " + n);
            }
        }
        abstractBitmap.read(abstractDecoder);
        return abstractBitmap;
    }

    public List getImages() {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        Iterator iterator = this.getDescriptors().iterator();
        while (iterator.hasNext()) {
            BitmapDescriptor bitmapDescriptor = (BitmapDescriptor)iterator.next();
            arrayList.add(bitmapDescriptor.getBitmap().createImageRGB());
        }
        return arrayList;
    }

    public List getDescriptors() {
        return this._descriptors;
    }

    public BitmapDescriptor getDescriptor(int n) {
        return (BitmapDescriptor)this._descriptors.get(n);
    }

    public int getType() {
        return this._type;
    }

    public int getImageCount() {
        return this._imageCount;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getReserved() {
        return this._reserved;
    }
}

