/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico;

import com.ctreber.aclib.codec.AbstractDecoder;
import com.ctreber.aclib.image.ico.TypeCompression;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BitmapHeader {
    private static final Logger LOG;
    private final long _headerSize;
    private final long _width;
    private final long _height;
    private final int _planes;
    private final int _bpp;
    private final TypeCompression _compression;
    private final long _imageSize;
    private final long _xPixelsPerM;
    private final long _yPixelsPerM;
    private final long _colorsUsed;
    private final long _colorsImportant;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ctreber.aclib.image.ico.BitmapHeader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
    }

    public BitmapHeader(AbstractDecoder abstractDecoder) throws IOException {
        LOG.debug("Reading header at " + abstractDecoder.getPos());
        this._headerSize = abstractDecoder.readUInt4();
        this._width = abstractDecoder.readUInt4();
        this._height = abstractDecoder.readUInt4();
        this._planes = abstractDecoder.readUInt2();
        this._bpp = abstractDecoder.readUInt2();
        this._compression = TypeCompression.getType(abstractDecoder.readUInt4());
        this._imageSize = abstractDecoder.readUInt4();
        this._xPixelsPerM = abstractDecoder.readUInt4();
        this._yPixelsPerM = abstractDecoder.readUInt4();
        this._colorsUsed = abstractDecoder.readUInt4();
        this._colorsImportant = abstractDecoder.readUInt4();
        LOG.debug(this);
    }

    public String toString() {
        return "size: " + this._headerSize + ", width: " + this._width + ", height: " + this._height + ", planes: " + this._planes + ", BPP: " + this._bpp + ", compression: " + this._compression + ", imageSize: " + this._imageSize + ", XPixelsPerM: " + this._xPixelsPerM + ", YPixelsPerM: " + this._yPixelsPerM + ", colorsUsed: " + this._colorsUsed + ", colorsImportant: " + this._colorsImportant + (this._colorsImportant == 0L ? " (all)" : "");
    }

    public int getBPP() {
        return this._bpp;
    }

    public long getColorsImportant() {
        return this._colorsImportant;
    }

    public long getColorsUsed() {
        return this._colorsUsed;
    }

    public TypeCompression getCompression() {
        return this._compression;
    }

    public long getHeight() {
        return this._height;
    }

    public long getBitmapSize() {
        return this._imageSize;
    }

    public int getPlanes() {
        return this._planes;
    }

    public long getHeaderSize() {
        return this._headerSize;
    }

    public long getWidth() {
        return this._width;
    }

    public long getXPixelsPerM() {
        return this._xPixelsPerM;
    }

    public long getYPixelsPerM() {
        return this._yPixelsPerM;
    }

    public int getColorCount() {
        return 1 << this._bpp;
    }
}

