/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.codec;

import java.io.IOException;

public abstract class AbstractDecoder {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private int _endianness = 0;
    protected long _pos;
    private final byte[] _readBuf = new byte[4];

    public short readUInt1() throws IOException {
        return (short)this.readValue(1);
    }

    public int readUInt2() throws IOException {
        return (int)this.readValue(2);
    }

    public long readUInt4() throws IOException {
        return this.readValue(4);
    }

    public void setEndianess(int n) {
        this._endianness = n;
    }

    public long getPos() {
        return this._pos;
    }

    public abstract void seek(long var1) throws IOException;

    public abstract byte[] readBytes(long var1, byte[] var3) throws IOException;

    protected long readValue(int n) throws IOException {
        this.readBytes(n, this._readBuf);
        if (n == 1) {
            return this._readBuf[0] & 0xFF;
        }
        long l = 0L;
        if (this._endianness == 0) {
            int n2 = 0;
            while (n2 < n) {
                l <<= 8;
                l += (long)(this._readBuf[n2] & 0xFF);
                ++n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                l <<= 8;
                l += (long)(this._readBuf[n3] & 0xFF);
                --n3;
            }
        }
        return l;
    }

    public abstract void close() throws IOException;
}

