/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.Message;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.Connector;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.MessageProcessor;
import org.ice4j.stack.MessageQueue;
import org.ice4j.stack.StunStack;

class NetAccessManager
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(NetAccessManager.class.getName());
    private Map<TransportAddress, Connector> netUDPAccessPoints = new Hashtable<TransportAddress, Connector>();
    private Map<TransportAddress, Connector> netTCPAccessPoints = new Hashtable<TransportAddress, Connector>();
    private final MessageQueue messageQueue = new MessageQueue();
    private Vector<MessageProcessor> messageProcessors = new Vector();
    private final MessageEventHandler messageEventHandler;
    private int initialThreadPoolSize = 3;
    private final StunStack stunStack;

    NetAccessManager(StunStack stunStack) {
        this.stunStack = stunStack;
        this.messageEventHandler = stunStack;
        this.initThreadPool();
    }

    MessageEventHandler getMessageEventHandler() {
        return this.messageEventHandler;
    }

    MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    StunStack getStunStack() {
        return this.stunStack;
    }

    public void handleError(String message, Throwable error) {
        logger.log(Level.FINE, "The following error occurred with an incoming message:", error);
    }

    public void handleFatalError(Runnable callingThread, String message, Throwable error) {
        if (callingThread instanceof Connector) {
            Connector ap = (Connector)callingThread;
            this.removeSocket(ap.getListenAddress());
            logger.log(Level.WARNING, "Removing connector:" + ap, error);
        } else if (callingThread instanceof MessageProcessor) {
            MessageProcessor mp = (MessageProcessor)callingThread;
            logger.log(Level.WARNING, "A message processor has unexpectedly stopped. AP:" + mp, error);
            mp.stop();
            this.messageProcessors.remove(mp);
            mp = new MessageProcessor(this);
            mp.start();
            logger.fine("A message processor has been relaunched because of an error.");
        }
    }

    protected void addSocket(IceSocketWrapper socket) {
        Connector ap;
        TransportAddress localAddr = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), socket.getUDPSocket() != null ? Transport.UDP : Transport.TCP);
        if (socket.getUDPSocket() != null && !this.netUDPAccessPoints.containsKey(localAddr)) {
            ap = new Connector(socket, this.messageQueue, this);
            this.netUDPAccessPoints.put(localAddr, ap);
            ap.start();
        }
        if (socket.getTCPSocket() != null && !this.netTCPAccessPoints.containsKey(localAddr)) {
            ap = new Connector(socket, this.messageQueue, this);
            this.netTCPAccessPoints.put(localAddr, ap);
            ap.start();
        }
    }

    protected void removeSocket(TransportAddress address) {
        Connector ap;
        switch (address.getTransport()) {
            case TCP: {
                ap = this.netTCPAccessPoints.remove(address);
                break;
            }
            case UDP: {
                ap = this.netUDPAccessPoints.remove(address);
                break;
            }
            default: {
                ap = null;
            }
        }
        if (ap != null) {
            ap.stop();
        }
    }

    public void stop() {
        for (MessageProcessor mp : this.messageProcessors) {
            mp.stop();
        }
    }

    void setThreadPoolSize(int threadPoolSize) throws IllegalArgumentException {
        if (threadPoolSize < 1) {
            throw new IllegalArgumentException(threadPoolSize + " is not a legal thread pool size value.");
        }
        if (this.messageProcessors.size() < threadPoolSize) {
            this.fillUpThreadPool(threadPoolSize);
        } else {
            this.shrinkThreadPool(threadPoolSize);
        }
    }

    private void initThreadPool() {
        this.fillUpThreadPool(this.initialThreadPoolSize);
    }

    private void fillUpThreadPool(int newSize) {
        this.messageProcessors.ensureCapacity(newSize);
        for (int i = this.messageProcessors.size(); i < newSize; ++i) {
            MessageProcessor mp = new MessageProcessor(this);
            this.messageProcessors.add(mp);
            mp.start();
        }
    }

    private void shrinkThreadPool(int newSize) {
        while (this.messageProcessors.size() > newSize) {
            MessageProcessor mp = this.messageProcessors.remove(0);
            mp.stop();
        }
    }

    void sendMessage(Message stunMessage, TransportAddress srcAddr, TransportAddress remoteAddr) throws IOException, IllegalArgumentException {
        byte[] bytes = stunMessage.encode(this.stunStack);
        Connector ap = null;
        if (srcAddr.getTransport() == Transport.UDP) {
            ap = this.netUDPAccessPoints.get(srcAddr);
        } else if (srcAddr.getTransport() == Transport.TCP) {
            ap = this.netTCPAccessPoints.get(srcAddr);
        }
        if (ap == null) {
            throw new IllegalArgumentException("No socket has been added for source address: " + srcAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }
}

