/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTcpSocketImpl;
import org.ice4j.pseudotcp.PseudoTcpState;

public class PseudoTcpSocket
extends Socket {
    private final PseudoTcpSocketImpl socketImpl;

    PseudoTcpSocket(PseudoTcpSocketImpl socketImpl) throws SocketException {
        super(socketImpl);
        this.socketImpl = socketImpl;
    }

    public long getConversationID() {
        return this.socketImpl.getConversationID();
    }

    public void setConversationID(long convID) throws IllegalStateException {
        this.socketImpl.setConversationID(convID);
    }

    public void setMTU(int mtu) {
        this.socketImpl.setMTU(mtu);
    }

    public int getMTU() {
        return this.socketImpl.getMTU();
    }

    public long getOption(Option option) {
        return this.socketImpl.getPTCPOption(option);
    }

    public void setOption(Option option, long optValue) {
        this.socketImpl.setPTCPOption(option, optValue);
    }

    public void accept(int timeout) throws IOException {
        this.socketImpl.accept(timeout);
    }

    public void setDebugName(String debugName) {
        this.socketImpl.setDebugName(debugName);
    }

    public PseudoTcpState getState() {
        return this.socketImpl.getState();
    }

    public boolean isConnected() {
        return this.getState() == PseudoTcpState.TCP_ESTABLISHED;
    }

    public boolean isConnecting() {
        PseudoTcpState currentState = this.getState();
        return currentState == PseudoTcpState.TCP_ESTABLISHED || currentState == PseudoTcpState.TCP_SYN_RECEIVED || currentState == PseudoTcpState.TCP_SYN_SENT;
    }

    public boolean isClosed() {
        return this.getState() == PseudoTcpState.TCP_CLOSED;
    }
}

