/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.XorOnlyAttribute;

public class XorOnlyTest
extends TestCase {
    private XorOnlyAttribute xorOnly = null;
    private MsgFixture msgFixture = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.xorOnly = new XorOnlyAttribute();
        this.msgFixture = new MsgFixture();
    }

    protected void tearDown() throws Exception {
        this.xorOnly = null;
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        byte[] attributeValue = new byte[]{};
        char offset = '\u0000';
        char length = '\u0000';
        this.xorOnly.decodeAttributeBody(attributeValue, offset, length);
    }

    public void testEncode() {
        byte[] expectedReturn = new byte[]{0, 33, 0, 0};
        byte[] actualReturn = this.xorOnly.encode();
        XorOnlyTest.assertTrue((String)"XorOnly failed to encode", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testEquals() throws Exception {
        XorOnlyAttribute xor2 = new XorOnlyAttribute();
        XorOnlyTest.assertEquals((String)"equals() failes for XorOnly", (Object)this.xorOnly, (Object)xor2);
        MappedAddressAttribute maatt = new MappedAddressAttribute();
        maatt.decodeAttributeBody(this.msgFixture.mappedAddress, '\u0000', (char)this.msgFixture.mappedAddress.length);
        XorOnlyTest.assertFalse((String)"equals failed to see a difference", (boolean)this.xorOnly.equals(maatt));
        XorOnlyTest.assertFalse((String)"equals failed for null", (boolean)this.xorOnly.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = '\u0000';
        char actualReturn = this.xorOnly.getDataLength();
        XorOnlyTest.assertEquals((String)"data length was not 0", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "XOR-ONLY";
        String actualReturn = this.xorOnly.getName();
        XorOnlyTest.assertEquals((String)"Is name correct", (String)expectedReturn, (String)actualReturn);
    }
}

