/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.UsernameAttribute;

public class UsernameAttributeTest
extends TestCase {
    private UsernameAttribute usernameAttribute = null;
    MsgFixture msgFixture = null;
    String usernameValue = "username";
    byte[] attributeBinValue = new byte[]{0, 6, 0, (byte)this.usernameValue.length(), 117, 115, 101, 114, 110, 97, 109, 101};

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.usernameAttribute = new UsernameAttribute();
        this.usernameAttribute.setUsername(this.usernameValue.getBytes());
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.usernameAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0000';
        UsernameAttribute decoded = new UsernameAttribute();
        char length = (char)this.usernameValue.length();
        decoded.decodeAttributeBody(this.usernameValue.getBytes(), offset, length);
        UsernameAttributeTest.assertEquals((String)"decode failed", (Object)this.usernameAttribute, (Object)decoded);
    }

    public void testEncode() {
        UsernameAttributeTest.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.usernameAttribute.encode(), this.attributeBinValue));
    }

    public void testEquals() {
        UsernameAttribute usernameAttribute2 = new UsernameAttribute();
        usernameAttribute2.setUsername(this.usernameValue.getBytes());
        UsernameAttributeTest.assertEquals((String)"testequals failed", (Object)this.usernameAttribute, (Object)usernameAttribute2);
        usernameAttribute2 = new UsernameAttribute();
        usernameAttribute2.setUsername("some other username".getBytes());
        UsernameAttributeTest.assertFalse((String)"testequals failed", (boolean)this.usernameAttribute.equals(usernameAttribute2));
        UsernameAttributeTest.assertFalse((String)"testequals failed", (boolean)this.usernameAttribute.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.usernameValue.length();
        char actualReturn = this.usernameAttribute.getDataLength();
        UsernameAttributeTest.assertEquals((String)"getDataLength - failed", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "USERNAME";
        String actualReturn = this.usernameAttribute.getName();
        UsernameAttributeTest.assertEquals((String)"getting name failed", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetGetUsername() {
        byte[] expectedReturn = this.usernameValue.getBytes();
        UsernameAttribute att = new UsernameAttribute();
        att.setUsername(expectedReturn);
        byte[] actualReturn = att.getUsername();
        UsernameAttributeTest.assertTrue((String)"username setter or getter failed", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }
}

