/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j;

import java.util.Arrays;
import java.util.Vector;
import junit.framework.TestCase;
import org.ice4j.AbstractResponseCollector;
import org.ice4j.BaseStunMessageEvent;
import org.ice4j.ResponseCollector;
import org.ice4j.StunFailureEvent;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

public class TransactionSupportTests
extends TestCase {
    TransportAddress clientAddress = new TransportAddress("127.0.0.1", 5216, Transport.UDP);
    TransportAddress serverAddress = new TransportAddress("127.0.0.1", 5255, Transport.UDP);
    IceSocketWrapper clientSock = null;
    IceSocketWrapper serverSock = null;
    private StunStack stunStack;
    Request bindingRequest = null;
    Response bindingResponse = null;
    PlainRequestCollector requestCollector = null;
    PlainResponseCollector responseCollector = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.clientSock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.clientAddress));
        this.serverSock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.serverAddress));
        this.stunStack = new StunStack();
        this.stunStack.addSocket(this.clientSock);
        this.stunStack.addSocket(this.serverSock);
        this.bindingRequest = MessageFactory.createBindingRequest();
        this.bindingResponse = MessageFactory.create3489BindingResponse(this.clientAddress, this.clientAddress, this.serverAddress);
        this.requestCollector = new PlainRequestCollector();
        this.responseCollector = new PlainResponseCollector();
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "false");
        System.setProperty("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE", "false");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "");
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "");
        System.setProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER", "");
    }

    protected void tearDown() throws Exception {
        this.stunStack.removeSocket(this.clientAddress);
        this.stunStack.removeSocket(this.serverAddress);
        this.clientSock.close();
        this.serverSock.close();
        this.requestCollector = null;
        this.responseCollector = null;
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "false");
        System.setProperty("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE", "false");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "");
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "");
        System.setProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER", "");
        super.tearDown();
    }

    public void testClientRetransmissions() throws Exception {
        String oldRetransValue = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        String oldMaxWaitValue = System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER");
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "100");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        Thread.sleep(1000L);
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertTrue((String)"No retransmissions of the request have been received", (reqs.size() > 1 ? 1 : 0) != 0);
        TransactionSupportTests.assertTrue((String)"The binding request has been retransmitted more than it should have!", (reqs.size() >= 3 ? 1 : 0) != 0);
        if (oldRetransValue != null) {
            System.getProperty("org.ice4j.MAX_RETRANSMISSIONS", oldRetransValue);
        } else {
            System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        }
        if (oldMaxWaitValue != null) {
            System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", oldRetransValue);
        } else {
            System.clearProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER");
        }
    }

    public void testServerRetransmissionHiding() throws Exception {
        String oldRetransValue = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        Thread.sleep(1000L);
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertTrue((String)"Retransmissions of a binding request were propagated to the server", (reqs.size() <= 1 ? 1 : 0) != 0);
        if (oldRetransValue != null) {
            System.getProperty("org.ice4j.MAX_RETRANSMISSIONS", oldRetransValue);
        } else {
            System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        }
    }

    public void testServerResponseRetransmissions() throws Exception {
        String oldRetransValue = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "100");
        System.setProperty("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE", "true");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        StunMessageEvent evt = reqs.get(0);
        byte[] tid = evt.getMessage().getTransactionID();
        this.stunStack.sendResponse(tid, this.bindingResponse, this.serverAddress, this.clientAddress);
        Thread.sleep(500L);
        TransactionSupportTests.assertTrue((String)("There were too few retransmissions of a binding response: " + this.responseCollector.receivedResponses.size()), (this.responseCollector.receivedResponses.size() < 3 ? 1 : 0) != 0);
        if (oldRetransValue != null) {
            System.getProperty("org.ice4j.MAX_RETRANSMISSIONS", oldRetransValue);
        } else {
            System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        }
        System.clearProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER");
    }

    public void testUniqueIDs() throws Exception {
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        Vector<StunMessageEvent> reqs1 = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        StunMessageEvent evt1 = reqs1.get(0);
        byte[] tid = evt1.getMessage().getTransactionID();
        this.stunStack.sendResponse(tid, this.bindingResponse, this.serverAddress, this.clientAddress);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        Thread.sleep(1000L);
        Vector<StunMessageEvent> reqs2 = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        StunMessageEvent evt2 = reqs2.get(0);
        TransactionSupportTests.assertFalse((String)"Consecutive requests were assigned the same transaction id", (boolean)Arrays.equals(evt1.getMessage().getTransactionID(), evt2.getMessage().getTransactionID()));
    }

    public void testClientTransactionMaxRetransmisssionsConfigurationParameter() throws Exception {
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        Thread.sleep(1600L);
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertTrue((String)"No retransmissions of the request have been received", (reqs.size() > 1 ? 1 : 0) != 0);
        TransactionSupportTests.assertEquals((String)"The MAX_RETRANSMISSIONS param was not taken into account!", (int)reqs.size(), (int)3);
    }

    public void testMinWaitIntervalConfigurationParameter() throws Exception {
        System.setProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER", "50");
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertTrue((String)"A retransmissions of the request was sent too early", (reqs.size() < 2 ? 1 : 0) != 0);
        Thread.sleep(110L);
        reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertEquals((String)"A retransmissions of the request was not sent", (int)2, (int)reqs.size());
    }

    public void testMaxWaitIntervalConfigurationParameter() throws Exception {
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "100");
        System.setProperty("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS", "true");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "11");
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        Thread.sleep(1200L);
        Vector<StunMessageEvent> reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertEquals((String)"Not all retransmissions were made for the expected period of time", (int)12, (int)reqs.size());
        Thread.sleep(1800L);
        reqs = this.requestCollector.getRequestsForTransaction(this.bindingRequest.getTransactionID());
        TransactionSupportTests.assertEquals((String)"A retransmissions of the request was sent, while not supposed to", (int)12, (int)reqs.size());
    }

    private static class PlainResponseCollector
    extends AbstractResponseCollector {
        public final Vector<Object> receivedResponses = new Vector();

        private PlainResponseCollector() {
        }

        protected void processFailure(BaseStunMessageEvent event) {
            String receivedResponse = event instanceof StunFailureEvent ? "unreachable" : (event instanceof StunTimeoutEvent ? "timeout" : "failure");
            this.receivedResponses.add(receivedResponse);
        }

        public void processResponse(StunResponseEvent response) {
            this.receivedResponses.add(response);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlainRequestCollector
    implements RequestListener {
        private Vector<StunMessageEvent> receivedRequestsVector = new Vector();

        private PlainRequestCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRequest(StunMessageEvent evt) {
            PlainRequestCollector plainRequestCollector = this;
            synchronized (plainRequestCollector) {
                this.receivedRequestsVector.add(evt);
                this.notifyAll();
            }
        }

        public Vector<StunMessageEvent> getRequestsForTransaction(byte[] tranid) {
            Vector<StunMessageEvent> newVec = new Vector<StunMessageEvent>();
            for (StunMessageEvent evt : this.receivedRequestsVector) {
                Message msg = evt.getMessage();
                if (!Arrays.equals(tranid, msg.getTransactionID())) continue;
                newVec.add(evt);
            }
            return newVec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRequest() {
            PlainRequestCollector plainRequestCollector = this;
            synchronized (plainRequestCollector) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

