/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j;

import java.util.Vector;
import junit.framework.TestCase;
import org.ice4j.AbstractResponseCollector;
import org.ice4j.BaseStunMessageEvent;
import org.ice4j.ResponseCollector;
import org.ice4j.StunFailureEvent;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

public class MessageEventDispatchingTest
extends TestCase {
    StunStack stunStack = null;
    TransportAddress clientAddress = new TransportAddress("127.0.0.1", 5216, Transport.UDP);
    TransportAddress serverAddress = new TransportAddress("127.0.0.1", 5255, Transport.UDP);
    TransportAddress serverAddress2 = new TransportAddress("127.0.0.1", 5259, Transport.UDP);
    IceSocketWrapper clientSock = null;
    IceSocketWrapper serverSock = null;
    IceSocketWrapper serverSock2 = null;
    Request bindingRequest = null;
    Response bindingResponse = null;
    PlainRequestCollector requestCollector = null;
    PlainResponseCollector responseCollector = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.stunStack = new StunStack();
        this.clientSock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.clientAddress));
        this.serverSock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.serverAddress));
        this.serverSock2 = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.serverAddress2));
        this.stunStack.addSocket(this.clientSock);
        this.stunStack.addSocket(this.serverSock);
        this.stunStack.addSocket(this.serverSock2);
        this.bindingRequest = MessageFactory.createBindingRequest();
        this.bindingResponse = MessageFactory.create3489BindingResponse(this.clientAddress, this.clientAddress, this.serverAddress);
        this.requestCollector = new PlainRequestCollector();
        this.responseCollector = new PlainResponseCollector();
    }

    protected void tearDown() throws Exception {
        this.stunStack.removeSocket(this.clientAddress);
        this.stunStack.removeSocket(this.serverAddress);
        this.stunStack.removeSocket(this.serverAddress2);
        this.clientSock.close();
        this.serverSock.close();
        this.serverSock2.close();
        this.requestCollector = null;
        this.responseCollector = null;
        super.tearDown();
    }

    public void testClientTransactionTimeouts() throws Exception {
        String oldRetransValue = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "1");
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.responseCollector.waitForTimeout();
        MessageEventDispatchingTest.assertEquals((String)"No timeout was produced upon expiration of a client transaction", (int)this.responseCollector.receivedResponses.size(), (int)1);
        MessageEventDispatchingTest.assertEquals((String)"No timeout was produced upon expiration of a client transaction", (Object)this.responseCollector.receivedResponses.get(0), (Object)"timeout");
        if (oldRetransValue != null) {
            System.getProperty("org.ice4j.MAX_RETRANSMISSIONS", oldRetransValue);
        } else {
            System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        }
    }

    public void testEventDispatchingUponIncomingRequests() throws Exception {
        this.stunStack.addRequestListener(this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        MessageEventDispatchingTest.assertTrue((String)"No MessageEvents have been dispatched", (this.requestCollector.receivedRequests.size() == 1 ? 1 : 0) != 0);
    }

    public void testSelectiveEventDispatchingUponIncomingRequests() throws Exception {
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        PlainRequestCollector requestCollector2 = new PlainRequestCollector();
        this.stunStack.addRequestListener(this.serverAddress2, requestCollector2);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress2, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        requestCollector2.waitForRequest();
        MessageEventDispatchingTest.assertTrue((String)"A MessageEvent was received by a non-interested selective listener", (this.requestCollector.receivedRequests.size() == 0 ? 1 : 0) != 0);
        MessageEventDispatchingTest.assertTrue((String)"No MessageEvents have been dispatched for a selective listener", (requestCollector2.receivedRequests.size() == 1 ? 1 : 0) != 0);
    }

    public void testServerResponseRetransmissions() throws Exception {
        this.stunStack.addRequestListener(this.serverAddress, this.requestCollector);
        this.stunStack.sendRequest(this.bindingRequest, this.serverAddress, this.clientAddress, (ResponseCollector)this.responseCollector);
        this.requestCollector.waitForRequest();
        StunMessageEvent evt = this.requestCollector.receivedRequests.get(0);
        byte[] tid = evt.getMessage().getTransactionID();
        this.stunStack.sendResponse(tid, this.bindingResponse, this.serverAddress, this.clientAddress);
        this.responseCollector.waitForResponse();
        MessageEventDispatchingTest.assertTrue((String)"There were no retransmissions of a binding response", (this.responseCollector.receivedResponses.size() == 1 ? 1 : 0) != 0);
    }

    private static class PlainResponseCollector
    extends AbstractResponseCollector {
        public final Vector<Object> receivedResponses = new Vector();

        private PlainResponseCollector() {
        }

        protected synchronized void processFailure(BaseStunMessageEvent event) {
            String receivedResponse = event instanceof StunFailureEvent ? "unreachable" : (event instanceof StunTimeoutEvent ? "timeout" : "failure");
            this.receivedResponses.add(receivedResponse);
            this.notifyAll();
        }

        public synchronized void processResponse(StunResponseEvent response) {
            this.receivedResponses.add(response);
            this.notifyAll();
        }

        public synchronized void waitForResponse() {
            try {
                if (this.receivedResponses.size() == 0) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void waitForTimeout() {
            try {
                if (this.receivedResponses.size() == 0) {
                    this.wait(12000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PlainRequestCollector
    implements RequestListener {
        public Vector<StunMessageEvent> receivedRequests = new Vector();

        private PlainRequestCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processRequest(StunMessageEvent evt) {
            PlainRequestCollector plainRequestCollector = this;
            synchronized (plainRequestCollector) {
                this.receivedRequests.add(evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRequest() {
            PlainRequestCollector plainRequestCollector = this;
            synchronized (plainRequestCollector) {
                if (this.receivedRequests.size() > 0) {
                    return;
                }
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

