/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.NotConnectedException;
import cx.ath.matthew.unix.UnixSocket;
import java.io.IOException;
import java.io.OutputStream;

public class USOutputStream
extends OutputStream {
    private int sock;
    boolean closed = false;
    private byte[] onebuf = new byte[1];
    private UnixSocket us;

    private native int native_send(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native int native_send(int var1, byte[][] var2) throws IOException;

    public USOutputStream(int n, UnixSocket unixSocket) {
        this.sock = n;
        this.us = unixSocket;
    }

    public void close() throws IOException {
        this.closed = true;
        this.us.close();
    }

    public void flush() {
    }

    public void write(byte[][] byArray) throws IOException {
        if (this.closed) {
            throw new NotConnectedException();
        }
        this.native_send(this.sock, byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new NotConnectedException();
        }
        this.native_send(this.sock, byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.onebuf[0] = (byte)(n % 127);
        if (1 == n % 128) {
            this.onebuf[0] = -this.onebuf[0];
        }
        this.write(this.onebuf);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UnixSocket getSocket() {
        return this.us;
    }
}

