/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils.synchronization;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.MessageDrivenThreadListener;
import com.lti.utils.synchronization.ProducerConsumerQueue;

public class MessageDrivenThread
extends CloseableThread {
    private MessageDrivenThreadListener listener;
    private ProducerConsumerQueue q = new ProducerConsumerQueue();

    public MessageDrivenThread(ThreadGroup group, String threadName) {
        super(group, threadName);
    }

    public MessageDrivenThread(ThreadGroup group, String threadName, MessageDrivenThreadListener listener) {
        super(group, threadName);
        this.listener = listener;
    }

    protected void doMessageReceived(Object o) {
        if (this.listener != null) {
            this.listener.onMessage(this, o);
        }
    }

    public void post(Object msg) throws InterruptedException {
        this.q.put(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.isClosing()) {
                Object o = this.q.get();
                this.doMessageReceived(o);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.setClosed();
        }
    }

    public void setListener(MessageDrivenThreadListener listener) {
        this.listener = listener;
    }
}

