/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightTextPane;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.util.Hashtable;
import java.util.List;
import javax.swing.CellRendererPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphics2DCanvas
extends mxBasicCanvas {
    protected Hashtable<String, Image> imageCache = new Hashtable();
    protected CellRendererPane rendererPane;
    protected Graphics2D g;

    public mxGraphics2DCanvas() {
        this(null);
    }

    public mxGraphics2DCanvas(Graphics2D graphics2D) {
        this.g = graphics2D;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    protected Image loadImage(String string) {
        Image image = this.imageCache.get(string);
        if (image == null && (image = mxUtils.loadImage(string)) != null) {
            this.imageCache.put(string, image);
        }
        return image;
    }

    @Override
    public Object drawVertex(int n, int n2, int n3, int n4, Hashtable<String, Object> hashtable) {
        if (this.g != null) {
            n += this.translate.x;
            n2 += this.translate.y;
            AffineTransform affineTransform = null;
            double d = mxUtils.getDouble(hashtable, mxConstants.STYLE_ROTATION, 0.0);
            if (d != 0.0) {
                affineTransform = this.g.getTransform();
                this.g.rotate(Math.toRadians(d), n + n3 / 2, n2 + n4 / 2);
            }
            Composite composite = null;
            float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_OPACITY, 100.0f);
            if (f != 100.0f) {
                composite = this.g.getComposite();
                this.g.setComposite(AlphaComposite.getInstance(3, f / 100.0f));
            }
            Stroke stroke = this.g.getStroke();
            if (!mxUtils.getString(hashtable, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                this.drawShape(n, n2, n3, n4, hashtable);
            } else {
                int n5 = (int)Math.round((double)mxUtils.getInt(hashtable, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(hashtable);
                hashtable2.remove(mxConstants.STYLE_FILLCOLOR);
                hashtable2.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(hashtable, mxConstants.STYLE_HORIZONTAL, true)) {
                    this.drawShape(n, n2, n3, Math.min(n4, n5), hashtable);
                    this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable2);
                } else {
                    this.drawShape(n, n2, Math.min(n3, n5), n4, hashtable);
                    this.drawShape(n + n5, n2, n3 - n5, n4, hashtable2);
                }
            }
            this.g.setStroke(stroke);
            if (composite != null) {
                this.g.setComposite(composite);
            }
            if (affineTransform != null) {
                this.g.setTransform(affineTransform);
            }
        }
        return null;
    }

    @Override
    public Object drawEdge(List<mxPoint> list, Hashtable<String, Object> hashtable) {
        if (this.g != null) {
            list = mxUtils.translatePoints(list, this.translate.x, this.translate.y);
            float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_OPACITY, 100.0f);
            Composite composite = null;
            if (f != 100.0f) {
                composite = this.g.getComposite();
                this.g.setComposite(AlphaComposite.getInstance(3, f / 100.0f));
            }
            Stroke stroke = this.g.getStroke();
            this.drawLine(list, hashtable);
            this.g.setStroke(stroke);
            if (composite != null) {
                this.g.setComposite(composite);
            }
        }
        return null;
    }

    @Override
    public Object drawLabel(String string, int n, int n2, int n3, int n4, Hashtable<String, Object> hashtable, boolean bl) {
        if (this.g != null && this.drawLabels) {
            n += this.translate.x;
            n2 += this.translate.y;
            if (string != null && string.length() > 0) {
                Composite composite = null;
                float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
                if (f != 100.0f) {
                    composite = this.g.getComposite();
                    this.g.setComposite(AlphaComposite.getInstance(3, f / 100.0f));
                }
                Color color = mxUtils.getColor(hashtable, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
                Color color2 = mxUtils.getColor(hashtable, mxConstants.STYLE_LABEL_BORDERCOLOR);
                if (color != null) {
                    this.g.setColor(color);
                    this.g.fillRect(n, n2, n3, n4);
                }
                if (color2 != null) {
                    this.g.setColor(color2);
                    this.g.drawRect(n, n2, n3, n4);
                }
                if (bl) {
                    this.drawHtmlText(mxUtils.getBodyMarkup(string, true), n, n2, n3, n4, hashtable);
                } else {
                    Font font = mxUtils.getFont(hashtable, this.scale);
                    if (font.getSize() > 0) {
                        this.g.setFont(font);
                        this.drawPlainText(string, n, n2, n3, n4, hashtable);
                    }
                }
                if (composite != null) {
                    this.g.setComposite(composite);
                }
            }
        }
        return null;
    }

    public void drawShape(int n, int n2, int n3, int n4, Hashtable<String, Object> hashtable) {
        Color color = mxUtils.getColor(hashtable, mxConstants.STYLE_STROKECOLOR);
        float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_STROKEWIDTH, 1.0f);
        int n5 = (int)Math.ceil((double)f * this.scale);
        if (this.g.hitClip(n - n5, n2 - n5, n3 + 2 * n5, n4 + 2 * n5)) {
            String string;
            boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_SHADOW, false);
            Color color2 = mxUtils.getColor(hashtable, mxConstants.STYLE_FILLCOLOR);
            Paint paint = this.getFillPaint(new Rectangle(n, n2, n3, n4), color2, hashtable);
            if (f > 0.0f) {
                if (mxUtils.isTrue(hashtable, mxConstants.STYLE_DASHED, false)) {
                    this.g.setStroke(new BasicStroke((float)((double)f * this.scale), 0, 0, 10.0f, new float[]{(float)(3.0 * this.scale), (float)(3.0 * this.scale)}, 0.0f));
                } else {
                    this.g.setStroke(new BasicStroke((float)((double)f * this.scale)));
                }
            }
            if ((string = mxUtils.getString(hashtable, mxConstants.STYLE_SHAPE, "")).equals("image")) {
                String string2 = this.getImageForStyle(hashtable);
                if (string2 != null) {
                    this.drawImage(n, n2, n3, n4, string2);
                }
            } else if (string.equals("line")) {
                if (color != null) {
                    this.g.setColor(color);
                    String string3 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "east");
                    if (string3.equals("east") || string3.equals("west")) {
                        int n6 = n2 + n4 / 2;
                        this.drawLine(n, n6, n + n3, n6);
                    } else {
                        int n7 = n + n3 / 2;
                        this.drawLine(n7, n2, n7, n2 + n4);
                    }
                }
            } else if (string.equals("ellipse")) {
                this.drawOval(n, n2, n3, n4, color2, paint, color, bl);
            } else if (string.equals("doubleEllipse")) {
                this.drawOval(n, n2, n3, n4, color2, paint, color, bl);
                int n8 = (int)((double)(3.0f + f) * this.scale);
                this.drawOval(n += n8, n2 += n8, n3 -= 2 * n8, n4 -= 2 * n8, null, null, color, false);
            } else if (string.equals("rhombus")) {
                this.drawRhombus(n, n2, n3, n4, color2, paint, color, bl);
            } else if (string.equals("cylinder")) {
                this.drawCylinder(n, n2, n3, n4, color2, paint, color, bl);
            } else if (string.equals("actor")) {
                this.drawActor(n, n2, n3, n4, color2, paint, color, bl);
            } else if (string.equals("cloud")) {
                this.drawCloud(n, n2, n3, n4, color2, paint, color, bl);
            } else if (string.equals("triangle")) {
                String string4 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "");
                this.drawTriangle(n, n2, n3, n4, color2, paint, color, bl, string4);
            } else if (string.equals("hexagon")) {
                String string5 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "");
                this.drawHexagon(n, n2, n3, n4, color2, paint, color, bl, string5);
            } else {
                String string6;
                this.drawRect(n, n2, n3, n4, color2, paint, color, bl, mxUtils.isTrue(hashtable, mxConstants.STYLE_ROUNDED));
                if (string.equals("label") && (string6 = this.getImageForStyle(hashtable)) != null) {
                    String string7 = mxUtils.getString(hashtable, mxConstants.STYLE_IMAGE_ALIGN, "center");
                    String string8 = mxUtils.getString(hashtable, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
                    int n9 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int n10 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int n11 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING, 2) * this.scale);
                    int n12 = n;
                    n12 = string7.equals("right") ? (n12 += n3 - n9 - n11) : (string7.equals("center") ? (n12 += (n3 - n9) / 2) : (n12 += n11));
                    int n13 = n2;
                    n13 = string8.equals("top") ? (n13 += n11) : (string8.equals("bottom") ? (n13 += n4 - n10 - n11) : (n13 += (n4 - n10) / 2));
                    this.drawImage(n12, n13, n9, n10, string6);
                }
            }
        }
    }

    protected void drawPolygon(Polygon polygon, Color color, Paint paint, Color color2, boolean bl) {
        if (color != null || paint != null) {
            if (bl) {
                this.g.setColor(mxConstants.SHADOW_COLOR);
                this.g.translate(mxConstants.SHADOW_OFFSETX, mxConstants.SHADOW_OFFSETY);
                this.g.fillPolygon(polygon);
                this.g.translate(-mxConstants.SHADOW_OFFSETX, -mxConstants.SHADOW_OFFSETY);
            }
            if (paint != null) {
                this.g.setPaint(paint);
            } else {
                this.g.setColor(color);
            }
            this.g.fillPolygon(polygon);
        }
        if (color2 != null) {
            this.g.setColor(color2);
            this.g.drawPolygon(polygon);
        }
    }

    protected void drawPath(GeneralPath generalPath, Color color, Paint paint, Color color2, boolean bl) {
        if (color != null || paint != null) {
            if (bl) {
                this.g.setColor(mxConstants.SHADOW_COLOR);
                this.g.translate(mxConstants.SHADOW_OFFSETX, mxConstants.SHADOW_OFFSETY);
                this.g.fill(generalPath);
                this.g.translate(-mxConstants.SHADOW_OFFSETX, -mxConstants.SHADOW_OFFSETY);
            }
            if (paint != null) {
                this.g.setPaint(paint);
            } else {
                this.g.setColor(color);
            }
            this.g.fill(generalPath);
        }
        if (color2 != null) {
            this.g.setColor(color2);
            this.g.draw(generalPath);
        }
    }

    protected void drawRect(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl, boolean bl2) {
        int n5;
        int n6 = n5 = bl2 ? mxGraphics2DCanvas.getArcSize(n3, n4) : 0;
        if (color != null || paint != null) {
            if (bl) {
                this.g.setColor(mxConstants.SHADOW_COLOR);
                if (bl2) {
                    this.g.fillRoundRect(n + mxConstants.SHADOW_OFFSETX, n2 + mxConstants.SHADOW_OFFSETY, n3, n4, n5, n5);
                } else {
                    this.g.fillRect(n + mxConstants.SHADOW_OFFSETX, n2 + mxConstants.SHADOW_OFFSETY, n3, n4);
                }
            }
            if (paint != null) {
                this.g.setPaint(paint);
            } else {
                this.g.setColor(color);
            }
            if (bl2) {
                this.g.fillRoundRect(n, n2, n3, n4, n5, n5);
            } else if (this.g.getClipBounds() != null) {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                this.g.fill(rectangle.intersection(this.g.getClipBounds()));
            } else {
                this.g.fillRect(n, n2, n3, n4);
            }
        }
        if (color2 != null) {
            this.g.setColor(color2);
            if (bl2) {
                this.g.drawRoundRect(n, n2, n3, n4, n5, n5);
            } else {
                this.g.drawRect(n, n2, n3, n4);
            }
        }
    }

    protected void drawImage(int n, int n2, int n3, int n4, String string) {
        Image image = this.loadImage(string);
        if (image != null) {
            this.g.drawImage(image, n, n2, n3, n4, null);
        }
    }

    protected void drawOval(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl) {
        if (color != null || paint != null) {
            if (bl) {
                this.g.setColor(mxConstants.SHADOW_COLOR);
                this.g.fillOval(n + mxConstants.SHADOW_OFFSETX, n2 + mxConstants.SHADOW_OFFSETY, n3, n4);
            }
            if (paint != null) {
                this.g.setPaint(paint);
            } else {
                this.g.setColor(color);
            }
            this.g.fillOval(n, n2, n3, n4);
        }
        if (color2 != null) {
            this.g.setColor(color2);
            this.g.drawOval(n, n2, n3, n4);
        }
    }

    protected void drawRhombus(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl) {
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        Polygon polygon = new Polygon();
        polygon.addPoint(n + n5, n2);
        polygon.addPoint(n + n3, n2 + n6);
        polygon.addPoint(n + n5, n2 + n4);
        polygon.addPoint(n, n2 + n6);
        this.drawPolygon(polygon, color, paint, color2, bl);
    }

    protected void drawCylinder(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl) {
        int n5 = n4 / 4;
        int n6 = n3 - 1;
        if (color != null || paint != null) {
            Area area = new Area(new Rectangle(n, n2 + n5 / 2, n6, n4 - n5));
            area.add(new Area(new Rectangle(n, n2 + n5 / 2, n6, n4 - n5)));
            area.add(new Area(new Ellipse2D.Double(n, n2, n6, n5)));
            area.add(new Area(new Ellipse2D.Double(n, n2 + n4 - n5, n6, n5)));
            if (bl) {
                this.g.setColor(mxConstants.SHADOW_COLOR);
                this.g.translate(mxConstants.SHADOW_OFFSETX, mxConstants.SHADOW_OFFSETY);
                this.g.fill(area);
                this.g.translate(-mxConstants.SHADOW_OFFSETX, -mxConstants.SHADOW_OFFSETY);
            }
            if (paint != null) {
                this.g.setPaint(paint);
            } else {
                this.g.setColor(color);
            }
            this.g.fill(area);
        }
        if (color2 != null) {
            this.g.setColor(color2);
            int n7 = n5 / 2;
            this.g.drawOval(n, n2, n6, n5);
            this.g.drawLine(n, n2 + n7, n, n2 + n4 - n7);
            this.g.drawLine(n + n3 - 1, n2 + n7, n + n3 - 1, n2 + n4 - n7);
            this.g.drawArc(n, n2 + n4 - n5, n6, n5, 0, -180);
        }
    }

    protected void drawActor(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl) {
        float f = n3 * 2 / 6;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n2 + n4);
        generalPath.curveTo(n, n2 + 3 * n4 / 5, n, n2 + 2 * n4 / 5, n + n3 / 2, n2 + 2 * n4 / 5);
        generalPath.curveTo((float)(n + n3 / 2) - f, n2 + 2 * n4 / 5, (float)(n + n3 / 2) - f, n2, n + n3 / 2, n2);
        generalPath.curveTo((float)(n + n3 / 2) + f, n2, (float)(n + n3 / 2) + f, n2 + 2 * n4 / 5, n + n3 / 2, n2 + 2 * n4 / 5);
        generalPath.curveTo(n + n3, n2 + 2 * n4 / 5, n + n3, n2 + 3 * n4 / 5, n + n3, n2 + n4);
        generalPath.closePath();
        this.drawPath(generalPath, color, paint, color2, bl);
    }

    protected void drawCloud(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((double)n + 0.25 * (double)n3), (float)((double)n2 + 0.25 * (double)n4));
        generalPath.curveTo((float)((double)n + 0.05 * (double)n3), (float)((double)n2 + 0.25 * (double)n4), n, (float)((double)n2 + 0.5 * (double)n4), (float)((double)n + 0.16 * (double)n3), (float)((double)n2 + 0.55 * (double)n4));
        generalPath.curveTo(n, (float)((double)n2 + 0.66 * (double)n4), (float)((double)n + 0.18 * (double)n3), (float)((double)n2 + 0.9 * (double)n4), (float)((double)n + 0.31 * (double)n3), (float)((double)n2 + 0.8 * (double)n4));
        generalPath.curveTo((float)((double)n + 0.4 * (double)n3), n2 + n4, (float)((double)n + 0.7 * (double)n3), n2 + n4, (float)((double)n + 0.8 * (double)n3), (float)((double)n2 + 0.8 * (double)n4));
        generalPath.curveTo(n + n3, (float)((double)n2 + 0.8 * (double)n4), n + n3, (float)((double)n2 + 0.6 * (double)n4), (float)((double)n + 0.875 * (double)n3), (float)((double)n2 + 0.5 * (double)n4));
        generalPath.curveTo(n + n3, (float)((double)n2 + 0.3 * (double)n4), (float)((double)n + 0.8 * (double)n3), (float)((double)n2 + 0.1 * (double)n4), (float)((double)n + 0.625 * (double)n3), (float)((double)n2 + 0.2 * (double)n4));
        generalPath.curveTo((float)((double)n + 0.5 * (double)n3), (float)((double)n2 + 0.05 * (double)n4), (float)((double)n + 0.3 * (double)n3), (float)((double)n2 + 0.05 * (double)n4), (float)((double)n + 0.25 * (double)n3), (float)((double)n2 + 0.25 * (double)n4));
        generalPath.closePath();
        this.drawPath(generalPath, color, paint, color2, bl);
    }

    protected void drawTriangle(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl, String string) {
        Polygon polygon = new Polygon();
        if (string.equals("north")) {
            polygon.addPoint(n, n2 + n4);
            polygon.addPoint(n + n3 / 2, n2);
            polygon.addPoint(n + n3, n2 + n4);
        } else if (string.equals("south")) {
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3 / 2, n2 + n4);
            polygon.addPoint(n + n3, n2);
        } else if (string.equals("west")) {
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n, n2 + n4 / 2);
            polygon.addPoint(n + n3, n2 + n4);
        } else {
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2 + n4 / 2);
            polygon.addPoint(n, n2 + n4);
        }
        this.drawPolygon(polygon, color, paint, color2, bl);
    }

    protected void drawHexagon(int n, int n2, int n3, int n4, Color color, Paint paint, Color color2, boolean bl, String string) {
        Polygon polygon = new Polygon();
        if (string.equals("north") || string.equals("south")) {
            polygon.addPoint(n + (int)(0.5 * (double)n3), n2);
            polygon.addPoint(n + n3, n2 + (int)(0.25 * (double)n4));
            polygon.addPoint(n + n3, n2 + (int)(0.75 * (double)n4));
            polygon.addPoint(n + (int)(0.5 * (double)n3), n2 + n4);
            polygon.addPoint(n, n2 + (int)(0.75 * (double)n4));
            polygon.addPoint(n, n2 + (int)(0.25 * (double)n4));
        } else {
            polygon.addPoint(n + (int)(0.25 * (double)n3), n2);
            polygon.addPoint(n + (int)(0.75 * (double)n3), n2);
            polygon.addPoint(n + n3, n2 + (int)(0.5 * (double)n4));
            polygon.addPoint(n + (int)(0.75 * (double)n3), n2 + n4);
            polygon.addPoint(n + (int)(0.25 * (double)n3), n2 + n4);
            polygon.addPoint(n, n2 + (int)(0.5 * (double)n4));
        }
        this.drawPolygon(polygon, color, paint, color2, bl);
    }

    public static int getArcSize(int n, int n2) {
        int n3;
        if (n <= n2) {
            n3 = (int)Math.round((double)n2 * mxConstants.RECTANGLE_ROUNDING_FACTOR);
            if (n3 > n / 2) {
                n3 = n / 2;
            }
        } else {
            n3 = (int)Math.round((double)n * mxConstants.RECTANGLE_ROUNDING_FACTOR);
            if (n3 > n2 / 2) {
                n3 = n2 / 2;
            }
        }
        return n3;
    }

    protected Polygon createArrow(mxPoint mxPoint2, mxPoint mxPoint3) {
        double d = (double)mxConstants.ARROW_SPACING * this.scale;
        double d2 = (double)mxConstants.ARROW_WIDTH * this.scale;
        double d3 = (double)mxConstants.ARROW_SIZE * this.scale;
        double d4 = mxPoint3.getX() - mxPoint2.getX();
        double d5 = mxPoint3.getY() - mxPoint2.getY();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = d6 - 2.0 * d - d3;
        double d8 = d4 / d6;
        double d9 = d5 / d6;
        double d10 = d7 * d8;
        double d11 = d7 * d9;
        double d12 = d2 * d9 / 3.0;
        double d13 = -d2 * d8 / 3.0;
        double d14 = mxPoint2.getX() - d12 / 2.0 + d * d8;
        double d15 = mxPoint2.getY() - d13 / 2.0 + d * d9;
        double d16 = d14 + d12;
        double d17 = d15 + d13;
        double d18 = d16 + d10;
        double d19 = d17 + d11;
        double d20 = d18 + d12;
        double d21 = d19 + d13;
        double d22 = d20 - 3.0 * d12;
        double d23 = d21 - 3.0 * d13;
        Polygon polygon = new Polygon();
        polygon.addPoint((int)Math.round(d14), (int)Math.round(d15));
        polygon.addPoint((int)Math.round(d16), (int)Math.round(d17));
        polygon.addPoint((int)Math.round(d18), (int)Math.round(d19));
        polygon.addPoint((int)Math.round(d20), (int)Math.round(d21));
        polygon.addPoint((int)Math.round(mxPoint3.getX() - d * d8), (int)Math.round(mxPoint3.getY() - d * d9));
        polygon.addPoint((int)Math.round(d22), (int)Math.round(d23));
        polygon.addPoint((int)Math.round(d22 + d12), (int)Math.round(d23 + d13));
        return polygon;
    }

    protected void drawArrow(List<mxPoint> list, Color color, Paint paint, Color color2, boolean bl) {
        mxPoint mxPoint2 = list.get(0);
        mxPoint mxPoint3 = list.get(list.size() - 1);
        Polygon polygon = this.createArrow(mxPoint2, mxPoint3);
        if (this.g.getClipBounds() == null || this.g.getClipBounds().intersects(polygon.getBounds())) {
            this.drawPolygon(polygon, color, paint, color2, bl);
        }
    }

    protected void drawConnector(List<mxPoint> list, float f, Color color, Object object, float f2, Object object2, float f3, boolean bl, boolean bl2) {
        double d;
        double d2;
        double d3;
        double d4;
        this.g.setStroke(new BasicStroke((float)((double)f * this.scale)));
        this.g.setColor(color);
        mxPoint mxPoint2 = list.get(0);
        mxPoint mxPoint3 = list.get(1);
        mxPoint mxPoint4 = null;
        if (object != null) {
            mxPoint4 = this.drawMarker(object, mxPoint3, mxPoint2, f2, f);
        } else {
            double d5 = mxPoint3.getX() - mxPoint2.getX();
            double d6 = mxPoint3.getY() - mxPoint2.getY();
            double d7 = Math.max(1.0, Math.sqrt(d5 * d5 + d6 * d6));
            double d8 = d5 * (double)f * this.scale / d7;
            double d9 = d6 * (double)f * this.scale / d7;
            mxPoint4 = new mxPoint(d8 / 2.0, d9 / 2.0);
        }
        if (mxPoint4 != null) {
            mxPoint2 = (mxPoint)mxPoint2.clone();
            mxPoint2.setX(mxPoint2.getX() + mxPoint4.getX());
            mxPoint2.setY(mxPoint2.getY() + mxPoint4.getY());
            mxPoint4 = null;
        }
        mxPoint mxPoint5 = list.get(list.size() - 1);
        mxPoint3 = list.get(list.size() - 2);
        if (object2 != null) {
            mxPoint4 = this.drawMarker(object2, mxPoint3, mxPoint5, f3, f);
        } else {
            d4 = mxPoint3.getX() - mxPoint2.getX();
            double d10 = mxPoint3.getY() - mxPoint2.getY();
            d3 = Math.max(1.0, Math.sqrt(d4 * d4 + d10 * d10));
            d2 = d4 * (double)f * this.scale / d3;
            d = d10 * (double)f * this.scale / d3;
            mxPoint4 = new mxPoint(d2 / 2.0, d / 2.0);
        }
        if (mxPoint4 != null) {
            mxPoint5 = (mxPoint)mxPoint5.clone();
            mxPoint5.setX(mxPoint5.getX() + mxPoint4.getX());
            mxPoint5.setY(mxPoint5.getY() + mxPoint4.getY());
            mxPoint4 = null;
        }
        if (bl) {
            this.g.setStroke(new BasicStroke(f, 0, 0, 10.0f, new float[]{(float)(3.0 * this.scale), (float)(3.0 * this.scale)}, 0.0f));
        }
        d4 = mxConstants.LINE_ARCSIZE * this.scale;
        mxPoint3 = mxPoint2;
        for (int i = 1; i < list.size() - 1; ++i) {
            mxPoint mxPoint6 = list.get(i);
            d3 = mxPoint3.getX() - mxPoint6.getX();
            d2 = mxPoint3.getY() - mxPoint6.getY();
            if (bl2 && i < list.size() - 1 && (d3 != 0.0 || d2 != 0.0) && this.scale > 0.05) {
                d = Math.sqrt(d3 * d3 + d2 * d2);
                double d11 = d3 * Math.min(d4, d / 2.0) / d;
                double d12 = d2 * Math.min(d4, d / 2.0) / d;
                this.drawLine((int)Math.round(mxPoint3.getX()), (int)Math.round(mxPoint3.getY()), (int)Math.round(mxPoint6.getX() + d11), (int)Math.round(mxPoint6.getY() + d12));
                mxPoint mxPoint7 = list.get(i + 1);
                d3 = mxPoint7.getX() - mxPoint6.getX();
                d2 = mxPoint7.getY() - mxPoint6.getY();
                d = Math.max(1.0, Math.sqrt(d3 * d3 + d2 * d2));
                double d13 = d3 * Math.min(d4, d / 2.0) / d;
                double d14 = d2 * Math.min(d4, d / 2.0) / d;
                QuadCurve2D.Float float_ = new QuadCurve2D.Float((int)Math.round(mxPoint6.getX() + d11), (int)Math.round(mxPoint6.getY() + d12), (int)Math.round(mxPoint6.getX()), (int)Math.round(mxPoint6.getY()), (int)Math.round(mxPoint6.getX() + d13), (int)Math.round(mxPoint6.getY() + d14));
                Rectangle rectangle = float_.getBounds();
                int n = (int)Math.ceil((double)f * this.scale);
                rectangle.grow(n, n);
                if (this.g.getClipBounds() == null || this.g.getClipBounds().intersects(rectangle)) {
                    this.g.draw(float_);
                }
                mxPoint6 = new mxPoint(mxPoint6.getX() + d13, mxPoint6.getY() + d14);
            } else {
                this.drawLine((int)Math.round(mxPoint3.getX()), (int)Math.round(mxPoint3.getY()), (int)Math.round(mxPoint6.getX()), (int)Math.round(mxPoint6.getY()));
            }
            mxPoint3 = mxPoint6;
        }
        this.drawLine((int)Math.round(mxPoint3.getX()), (int)Math.round(mxPoint3.getY()), (int)Math.round(mxPoint5.getX()), (int)Math.round(mxPoint5.getY()));
    }

    protected Paint getFillPaint(Rectangle rectangle, Color color, Hashtable<String, Object> hashtable) {
        Color color2;
        GradientPaint gradientPaint = null;
        if (color != null && (color2 = mxUtils.getColor(hashtable, mxConstants.STYLE_GRADIENTCOLOR)) != null) {
            String string = mxUtils.getString(hashtable, mxConstants.STYLE_GRADIENT_DIRECTION);
            float f = rectangle.x;
            float f2 = rectangle.y;
            float f3 = rectangle.x;
            float f4 = rectangle.y;
            if (string == null || string.equals("south")) {
                f4 = rectangle.y + rectangle.height;
            } else if (string.equals("east")) {
                f3 = rectangle.x + rectangle.width;
            } else if (string.equals("north")) {
                f2 = rectangle.y + rectangle.height;
            } else if (string.equals("west")) {
                f = rectangle.x + rectangle.width;
            }
            gradientPaint = new GradientPaint(f, f2, color, f3, f4, color2, true);
        }
        return gradientPaint;
    }

    public void drawLine(List<mxPoint> list, Hashtable<String, Object> hashtable) {
        Color color = mxUtils.getColor(hashtable, mxConstants.STYLE_STROKECOLOR, Color.black);
        float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_STROKEWIDTH, 1.0f);
        if (color != null && f > 0.0f) {
            String string = mxUtils.getString(hashtable, mxConstants.STYLE_SHAPE, "");
            if (string.equals("arrow")) {
                if (mxUtils.isTrue(hashtable, mxConstants.STYLE_DASHED, false)) {
                    this.g.setStroke(new BasicStroke((float)((double)f * this.scale), 0, 0, 10.0f, new float[]{(float)(3.0 * this.scale), (float)(3.0 * this.scale)}, 0.0f));
                } else {
                    this.g.setStroke(new BasicStroke((float)((double)f * this.scale)));
                }
                mxPoint mxPoint2 = list.get(0);
                mxPoint mxPoint3 = list.get(list.size() - 1);
                Rectangle rectangle = new Rectangle(mxPoint2.getPoint());
                rectangle.add(mxPoint3.getPoint());
                Color color2 = mxUtils.getColor(hashtable, mxConstants.STYLE_FILLCOLOR);
                Paint paint = this.getFillPaint(rectangle, color2, hashtable);
                boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_SHADOW, false);
                this.drawArrow(list, color2, paint, color, bl);
            } else {
                Object object = hashtable.get(mxConstants.STYLE_STARTARROW);
                Object object2 = hashtable.get(mxConstants.STYLE_ENDARROW);
                float f2 = mxUtils.getFloat(hashtable, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE);
                float f3 = mxUtils.getFloat(hashtable, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
                boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_ROUNDED, false);
                boolean bl2 = mxUtils.isTrue(hashtable, mxConstants.STYLE_DASHED, false);
                this.drawConnector(list, f, color, object, f2, object2, f3, bl2, bl);
            }
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Float float_ = new Line2D.Float(n, n2, n3, n4);
        if (this.g.getClipBounds() == null || float_.intersects(this.g.getClipBounds())) {
            this.g.draw(float_);
        }
    }

    public mxPoint drawMarker(Object object, mxPoint mxPoint2, mxPoint mxPoint3, float f, float f2) {
        mxPoint mxPoint4 = null;
        double d = mxPoint3.getX() - mxPoint2.getX();
        double d2 = mxPoint3.getY() - mxPoint2.getY();
        double d3 = Math.max(1.0, Math.sqrt(d * d + d2 * d2));
        double d4 = (double)f * this.scale;
        double d5 = d * d4 / d3;
        double d6 = d2 * d4 / d3;
        mxPoint3 = (mxPoint)mxPoint3.clone();
        mxPoint3.setX(mxPoint3.getX() - d5 * (double)f2 / (double)(2.0f * f));
        mxPoint3.setY(mxPoint3.getY() - d6 * (double)f2 / (double)(2.0f * f));
        d5 *= 0.5 + (double)(f2 / 2.0f);
        d6 *= 0.5 + (double)(f2 / 2.0f);
        if (object.equals("classic") || object.equals("block")) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)Math.round(mxPoint3.getX()), (int)Math.round(mxPoint3.getY()));
            polygon.addPoint((int)Math.round(mxPoint3.getX() - d5 - d6 / 2.0), (int)Math.round(mxPoint3.getY() - d6 + d5 / 2.0));
            if (object.equals("classic")) {
                polygon.addPoint((int)Math.round(mxPoint3.getX() - d5 * 3.0 / 4.0), (int)Math.round(mxPoint3.getY() - d6 * 3.0 / 4.0));
            }
            polygon.addPoint((int)Math.round(mxPoint3.getX() + d6 / 2.0 - d5), (int)Math.round(mxPoint3.getY() - d6 - d5 / 2.0));
            if (this.g.getClipBounds() == null || this.g.getClipBounds().intersects(polygon.getBounds())) {
                this.g.fillPolygon(polygon);
                this.g.drawPolygon(polygon);
            }
            mxPoint4 = new mxPoint(-d5 * 3.0 / 4.0, -d6 * 3.0 / 4.0);
        } else if (object.equals("open")) {
            this.drawLine((int)Math.round(mxPoint3.getX() - (d5 *= 1.2) - (d6 *= 1.2) / 2.0), (int)Math.round(mxPoint3.getY() - d6 + d5 / 2.0), (int)Math.round(mxPoint3.getX() - d5 / 6.0), (int)Math.round(mxPoint3.getY() - d6 / 6.0));
            this.drawLine((int)Math.round(mxPoint3.getX() - d5 / 6.0), (int)Math.round(mxPoint3.getY() - d6 / 6.0), (int)Math.round(mxPoint3.getX() + d6 / 2.0 - d5), (int)Math.round(mxPoint3.getY() - d6 - d5 / 2.0));
            mxPoint4 = new mxPoint(-d5 / 4.0, -d6 / 4.0);
        } else if (object.equals("oval")) {
            int n;
            int n2 = (int)Math.round(mxPoint3.getX() - (d5 *= 1.2) / 2.0);
            int n3 = (int)Math.round(mxPoint3.getY() - (d6 *= 1.2) / 2.0);
            int n4 = (int)Math.round((d4 *= 1.2) / 2.0);
            if (this.g.hitClip(n2 - n4, n3 - n4, n = (int)Math.round(d4), n)) {
                this.g.fillOval(n2 - n4, n3 - n4, n, n);
                this.g.drawOval(n2 - n4, n3 - n4, n, n);
            }
            mxPoint4 = new mxPoint(-d5 / 2.0, -d6 / 2.0);
        } else if (object.equals("diamond")) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)Math.round(mxPoint3.getX() + (d5 *= 1.2) / 2.0), (int)Math.round(mxPoint3.getY() + (d6 *= 1.2) / 2.0));
            polygon.addPoint((int)Math.round(mxPoint3.getX() - d6 / 2.0), (int)Math.round(mxPoint3.getY() + d5 / 2.0));
            polygon.addPoint((int)Math.round(mxPoint3.getX() - d5 / 2.0), (int)Math.round(mxPoint3.getY() - d6 / 2.0));
            polygon.addPoint((int)Math.round(mxPoint3.getX() + d6 / 2.0), (int)Math.round(mxPoint3.getY() - d5 / 2.0));
            if (this.g.getClipBounds() == null || this.g.getClipBounds().intersects(polygon.getBounds())) {
                this.g.fillPolygon(polygon);
                this.g.drawPolygon(polygon);
            }
        }
        return mxPoint4;
    }

    protected void drawHtmlText(String string, int n, int n2, int n3, int n4, Hashtable<String, Object> hashtable) {
        mxLightweightTextPane mxLightweightTextPane2 = mxLightweightTextPane.getSharedInstance();
        if (mxLightweightTextPane2 != null && this.rendererPane != null) {
            boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_HORIZONTAL, true);
            if (this.g.hitClip(n, n2, n3, n4)) {
                AffineTransform affineTransform = this.g.getTransform();
                if (!bl) {
                    this.g.rotate(-1.5707963267948966, n + n3 / 2, n2 + n4 / 2);
                    this.g.translate(n3 / 2 - n4 / 2, n4 / 2 - n3 / 2);
                    int n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                mxLightweightTextPane2.setText(mxUtils.createHtmlDocument(hashtable, string));
                this.g.scale(this.scale, this.scale);
                this.rendererPane.paintComponent(this.g, mxLightweightTextPane2, this.rendererPane, (int)((double)n / this.scale) + mxConstants.LABEL_INSET, (int)((double)n2 / this.scale) + mxConstants.LABEL_INSET, (int)((double)n3 / this.scale), (int)((double)n4 / this.scale), true);
                this.g.setTransform(affineTransform);
            }
        }
    }

    protected void drawPlainText(String string, int n, int n2, int n3, int n4, Hashtable<String, Object> hashtable) {
        if (this.g.hitClip(n, n2, n3, n4)) {
            AffineTransform affineTransform = this.g.getTransform();
            boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_HORIZONTAL, true);
            if (!bl) {
                this.g.rotate(-1.5707963267948966, n + n3 / 2, n2 + n4 / 2);
                this.g.translate(n3 / 2 - n4 / 2, n4 / 2 - n3 / 2);
            }
            FontMetrics fontMetrics = this.g.getFontMetrics();
            n2 = (int)((double)n2 + ((double)(2 * fontMetrics.getMaxAscent() - fontMetrics.getHeight()) + (double)mxConstants.LABEL_INSET * this.scale));
            String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_ALIGN, "center");
            if (string2.equals("left")) {
                n += mxConstants.LABEL_INSET;
            } else if (string2.equals("right")) {
                n -= mxConstants.LABEL_INSET;
            }
            Color color = mxUtils.getColor(hashtable, mxConstants.STYLE_FONTCOLOR, Color.black);
            this.g.setColor(color);
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                int n5;
                int n6 = 0;
                if (string2.equals("center")) {
                    n5 = fontMetrics.stringWidth(stringArray[i]);
                    n6 = bl ? (n3 - n5) / 2 : (n4 - n5) / 2;
                } else if (string2.equals("right")) {
                    n5 = fontMetrics.stringWidth(stringArray[i]);
                    n6 = (bl ? n3 : n4) - n5;
                }
                this.g.drawString(stringArray[i], n + n6, n2);
                n2 += fontMetrics.getHeight() + mxConstants.LINESPACING;
            }
            this.g.setTransform(affineTransform);
        }
    }
}

