/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import javax.swing.JComponent;
import javax.swing.JLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

public class AbstractBufferedLayerUI<V extends JComponent>
extends AbstractLayerUI<V>
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JLayer<? extends V> layer;
    private transient SoftReference<BufferedImage> cachedBuffer;
    private static final LayerEffect[] emptyEffectArray = new LayerEffect[0];

    @Override
    public void installUI(JComponent c) {
        if (this.layer != null) {
            throw new IllegalStateException("BufferedLayerUI can't be shared between multiple layers");
        }
        this.layer = (JLayer)c;
        c.addPropertyChangeListener(this);
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removePropertyChangeListener(this);
        this.layer = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() != this.getLayer() || "view".equals(propertyName)) {
            this.setDirty(true);
        }
    }

    @Override
    public void updateUI(JLayer<? extends V> l) {
        this.setDirty(true);
    }

    public JLayer<? extends V> getLayer() {
        return this.layer;
    }

    protected BufferedImage getBuffer() {
        return this.cachedBuffer == null ? null : this.cachedBuffer.get();
    }

    protected void setBuffer(BufferedImage buffer) {
        this.cachedBuffer = new SoftReference<BufferedImage>(buffer);
    }

    protected LayerEffect[] getLayerEffects(JLayer<? extends V> l) {
        return emptyEffectArray;
    }

    protected boolean isIncrementalUpdate(JLayer<? extends V> l) {
        return true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            JLayer l = (JLayer)c;
            this.configureGraphics(g2, l);
            Shape clip = g2.getClip();
            BufferedImage buffer = this.getBuffer();
            boolean isBufferFormatValid = this.isBufferFormatValid(l);
            if (!isBufferFormatValid || !this.isBufferContentValid(l, clip)) {
                if (!isBufferFormatValid) {
                    buffer = this.createBuffer(l.getWidth(), l.getHeight());
                    this.setBuffer(buffer);
                }
                Graphics2D bufg = buffer.createGraphics();
                if (this.isIncrementalUpdate(l)) {
                    bufg.setClip(clip);
                }
                this.paintLayer(bufg, l);
                this.applyLayerEffects(l, bufg.getClip());
                bufg.dispose();
            }
            g2.drawImage((Image)buffer, 0, 0, null);
            g2.dispose();
            this.setDirty(false);
        }
    }

    protected boolean isBufferFormatValid(JLayer<? extends V> l) {
        BufferedImage buffer = this.getBuffer();
        return buffer != null && buffer.getWidth() == l.getWidth() && buffer.getHeight() == l.getHeight();
    }

    protected boolean isBufferContentValid(JLayer<? extends V> l, Shape clip) {
        return !this.isDirty() && !this.isIncrementalUpdate(l);
    }

    protected BufferedImage createBuffer(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    protected void applyLayerEffects(JLayer<? extends V> l, Shape clip) {
        if (this.getBuffer() == null) {
            throw new IllegalStateException("Buffer is null");
        }
        for (LayerEffect e : this.getLayerEffects(l)) {
            if (!e.isEnabled()) continue;
            e.apply(this.getBuffer(), clip);
        }
    }
}

