/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.ExchangeRate;
import jgnash.engine.Transaction;
import jgnash.engine.budget.Budget;
import jgnash.engine.recurring.Reminder;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.net.ConnectionFactory;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageBusRemoteClient {
    private String host = "localhost";
    private int port = 0;
    private static final Logger logger = LoggerFactory.getLogger(MessageBusRemoteClient.class);
    private IoSession session;
    private XStream xstream;

    public MessageBusRemoteClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        this.xstream.alias("Message", Message.class);
        this.xstream.alias("MessageProperty", MessageProperty.class);
    }

    private static int getConnectionTimeout() {
        return ConnectionFactory.getConnectionTimeout();
    }

    public boolean connectToServer() {
        boolean result;
        block2: {
            result = false;
            NioSocketConnector connector = new NioSocketConnector();
            connector.setConnectTimeoutMillis((long)(MessageBusRemoteClient.getConnectionTimeout() * 1000));
            connector.setHandler((IoHandler)new ClientSessionHandler());
            connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("UTF-8"))));
            try {
                ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
                future.awaitUninterruptibly();
                this.session = future.getSession();
                result = true;
                logger.info("Connected to remote message server");
            }
            catch (RuntimeIoException e) {
                logger.error("Failed to connect to remote message bus");
                if (this.session == null) break block2;
                this.session.close(true);
            }
        }
        return result;
    }

    public void disconnectFromServer() {
        this.session.close(true);
    }

    public synchronized void sendRemoteMessage(Message message) {
        logger.info("begin");
        CharArrayWriter writer = new CharArrayWriter();
        this.xstream.marshal((Object)message, (HierarchicalStreamWriter)new CompactWriter((Writer)writer));
        this.session.write((Object)writer.toString());
        logger.info("sent: " + writer.toString());
    }

    private synchronized void processRemoteMessage(Message message) {
        Account account;
        logger.info("processing a remote message");
        Engine engine = EngineFactory.getEngine("default");
        if (message.getChannel() == MessageChannel.ACCOUNT) {
            account = (Account)message.getObject(MessageProperty.ACCOUNT);
            switch (message.getEvent()) {
                case ACCOUNT_ADD: 
                case ACCOUNT_REMOVE: {
                    engine.refreshAccount(account);
                    message.setObject(MessageProperty.ACCOUNT, engine.getStoredObjectByUuid(account.getUuid()));
                    engine.refreshAccount(account.getParent());
                    break;
                }
                case ACCOUNT_MODIFY: 
                case ACCOUNT_SECURITY_ADD: 
                case ACCOUNT_SECURITY_REMOVE: 
                case ACCOUNT_VISIBILITY_CHANGE: {
                    engine.refreshAccount(account);
                    message.setObject(MessageProperty.ACCOUNT, engine.getStoredObjectByUuid(account.getUuid()));
                    break;
                }
            }
        }
        if (message.getChannel() == MessageChannel.BUDGET) {
            Budget budget = (Budget)message.getObject(MessageProperty.BUDGET);
            switch (message.getEvent()) {
                case BUDGET_ADD: 
                case BUDGET_UPDATE: 
                case BUDGET_REMOVE: 
                case BUDGET_GOAL_UPDATE: {
                    engine.refreshBudget(budget);
                    message.setObject(MessageProperty.BUDGET, engine.getStoredObjectByUuid(budget.getUuid()));
                    break;
                }
            }
        }
        if (message.getChannel() == MessageChannel.COMMODITY) {
            switch (message.getEvent()) {
                case CURRENCY_MODIFY: 
                case COMMODITY_HISTORY_ADD: 
                case COMMODITY_HISTORY_REMOVE: {
                    CommodityNode node = (CommodityNode)message.getObject(MessageProperty.COMMODITY);
                    engine.refreshCommodity(node);
                    message.setObject(MessageProperty.COMMODITY, engine.getStoredObjectByUuid(node.getUuid()));
                    break;
                }
                case EXCHANGERATE_ADD: 
                case EXCHANGERATE_REMOVE: {
                    ExchangeRate rate = (ExchangeRate)message.getObject(MessageProperty.EXCHANGERATE);
                    engine.refreshExchangeRate(rate);
                    message.setObject(MessageProperty.EXCHANGERATE, engine.getStoredObjectByUuid(rate.getUuid()));
                    break;
                }
            }
        }
        if (message.getChannel() == MessageChannel.REMINDER) {
            switch (message.getEvent()) {
                case REMINDER_ADD: 
                case REMINDER_REMOVE: {
                    Reminder reminder = (Reminder)message.getObject(MessageProperty.REMINDER);
                    engine.refreshReminder(reminder);
                    message.setObject(MessageProperty.REMINDER, engine.getStoredObjectByUuid(reminder.getUuid()));
                    break;
                }
            }
        }
        if (message.getChannel() == MessageChannel.TRANSACTION) {
            switch (message.getEvent()) {
                case TRANSACTION_ADD: 
                case TRANSACTION_REMOVE: {
                    account = (Account)message.getObject(MessageProperty.ACCOUNT);
                    engine.refreshAccount(account);
                    message.setObject(MessageProperty.ACCOUNT, engine.getStoredObjectByUuid(account.getUuid()));
                    Transaction transaction = (Transaction)message.getObject(MessageProperty.TRANSACTION);
                    engine.refreshTransaction(transaction);
                    message.setObject(MessageProperty.TRANSACTION, engine.getStoredObjectByUuid(transaction.getUuid()));
                    break;
                }
            }
        }
        message.setRemote(true);
        logger.info("fire remote message");
        MessageBus.getInstance().fireEvent(message);
    }

    static {
        IoBuffer.setUseDirectBuffer((boolean)false);
        IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
    }

    private class ClientSessionHandler
    extends IoHandlerAdapter {
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        private static final int FORCED_LATENCY = 2000;

        private ClientSessionHandler() {
        }

        public void sessionOpened(IoSession s) {
        }

        public void messageReceived(IoSession s, Object object) {
            logger.info("messageReceived: " + object.toString());
            if (object instanceof String && ((String)object).startsWith("<Message")) {
                final Message message = (Message)MessageBusRemoteClient.this.xstream.fromXML((String)object);
                if (!EngineFactory.getEngine("default").getUuid().equals(message.getSource())) {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            MessageBusRemoteClient.this.processRemoteMessage(message);
                        }
                    }, 2000L, TimeUnit.MILLISECONDS);
                }
            } else {
                logger.error("Unknown message: " + object.toString());
            }
        }

        public void exceptionCaught(IoSession s, Throwable cause) {
            logger.error("Error", cause);
            s.close(true);
        }

        public void sessionClosed(IoSession s) throws Exception {
            s.close(true);
        }
    }
}

