/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.KXml2Driver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.ExchangeRate;
import jgnash.engine.RootAccount;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.budget.Budget;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.xstream.AbstractXStreamContainer;
import jgnash.engine.xstream.StoredObjectReflectionProvider;
import jgnash.util.FileMagic;
import jgnash.util.FileUtils;

public class XMLContainer
extends AbstractXStreamContainer {
    protected XMLContainer(File file) {
        super(file);
    }

    @Override
    void commit() {
        this.writeXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeXML() {
        this.readWriteLock.readLock().lock();
        try {
            this.releaseFileLock();
            XMLContainer.writeXML(this.objects, this.file);
        }
        finally {
            this.acquireFileLock();
            this.readWriteLock.readLock().unlock();
        }
    }

    public static synchronized void writeXML(Collection<StoredObject> objects, File file) {
        Logger logger = Logger.getLogger(XMLContainer.class.getName());
        if (file.exists()) {
            File backup = new File(file.getAbsolutePath() + ".backup");
            if (backup.exists() && !backup.delete()) {
                logger.log(Level.WARNING, "Was not able to delete the old backup file: {0}", backup.getAbsolutePath());
            }
            FileUtils.copyFile(file, backup);
        }
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        list.addAll(XMLContainer.query(objects, Budget.class));
        list.addAll(XMLContainer.query(objects, Config.class));
        list.addAll(XMLContainer.query(objects, CommodityNode.class));
        list.addAll(XMLContainer.query(objects, ExchangeRate.class));
        list.addAll(XMLContainer.query(objects, RootAccount.class));
        list.addAll(XMLContainer.query(objects, Reminder.class));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StoredObject o = (StoredObject)i.next();
            if (!o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(list, new StoredObjectComparator());
        logger.info("Writing XML file");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<?fileVersion 2.21?>\n");
            XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new KXml2Driver()));
            try (ObjectOutputStream out = xstream.createObjectOutputStream((HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));){
                out.writeObject(list);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        logger.info("Writing XML file complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readXML() {
        String encoding = System.getProperty("file.encoding");
        String version = FileMagic.getjGnashXMLVersion(this.file);
        if (Float.parseFloat(version) >= 2.01f) {
            encoding = "UTF-8";
        }
        ObjectInputStream in = null;
        FileLock readLock = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        this.readWriteLock.writeLock().lock();
        try {
            XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new StoredObjectReflectionProvider(this.objects), (HierarchicalStreamDriver)new KXml2Driver()));
            readLock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (readLock != null) {
                in = xstream.createObjectInputStream((Reader)reader);
                in.readObject();
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    if (readLock != null) {
                        readLock.release();
                    }
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
            }
            this.acquireFileLock();
            this.readWriteLock.writeLock().unlock();
        }
    }
}

