/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import jgnash.engine.dao.AbstractDAO;
import jgnash.engine.xstream.AbstractXStreamContainer;

public abstract class AbstractXStreamDAO
extends AbstractDAO {
    static final int MAX_COMMIT_TIME = 30;
    static final AtomicInteger commitCount = new AtomicInteger(0);
    AbstractXStreamContainer container;
    private static final ReentrantLock commitLock = new ReentrantLock();
    private static final int MAX_COMMIT_COUNT = 250;

    AbstractXStreamDAO(AbstractXStreamContainer container) {
        assert (container != null);
        this.container = container;
    }

    final void commit() {
        if (commitCount.getAndIncrement() >= 250) {
            this.commitAndReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commitAndReset() {
        commitLock.lock();
        try {
            commitCount.set(0);
            this.container.commit();
        }
        finally {
            commitLock.unlock();
        }
    }
}

