/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountProperty;
import jgnash.engine.AccountType;
import jgnash.engine.AmortizeObject;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DefaultCurrencies;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateDAO;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.MathConstants;
import jgnash.engine.ReconciledState;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionType;
import jgnash.engine.TrashObject;
import jgnash.engine.UUIDUtil;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.dao.BudgetDAO;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.dao.ConfigDAO;
import jgnash.engine.dao.EngineDAO;
import jgnash.engine.dao.RecurringDAO;
import jgnash.engine.dao.TransactionDAO;
import jgnash.engine.dao.TrashDAO;
import jgnash.engine.recurring.PendingReminder;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.util.DateUtils;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.Resource;

public class Engine {
    public static final float CURRENT_VERSION = 2.21f;
    private final Resource rb = Resource.get();
    private static final Logger logger = Logger.getLogger(Engine.class.getName());
    private MessageBus messageBus = null;
    private Config config;
    private RootAccount rootAccount;
    private ExchangeRateDAO exchangeRateDAO;
    private final ReentrantReadWriteLock accountLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock budgetLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock commodityLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock configLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock engineLock = new ReentrantReadWriteLock(true);
    private EngineDAO eDAO;
    private String accountSeparator = null;
    private ScheduledExecutorService trashExecutor;
    private static final long MAXIMUM_TRASH_AGE = 300000L;
    private final String name;
    private final String uuid = UUIDUtil.getUID();

    public Engine(EngineDAO eDAO, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The engine name may not be null");
        }
        if (eDAO == null) {
            throw new IllegalArgumentException("The engineDAO may not be null");
        }
        this.eDAO = eDAO;
        this.name = name;
        this.messageBus = MessageBus.getInstance(name);
        this.initialize();
        this.checkAndCorrect();
        this.trashExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultDaemonThreadFactory());
        this.trashExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Engine.this.emptyTrash();
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        commodityWriteLock.lock();
        accountWriteLock.lock();
        try {
            this.getConfig().initialize();
            this.exchangeRateDAO = new ExchangeRateDAO(this.getCommodityDAO());
            for (CurrencyNode node : this.getCurrencies()) {
                node.setExchangeRateDAO(this.exchangeRateDAO);
            }
            RootAccount root = this.getRootAccount();
            if (root == null) {
                CurrencyNode node;
                node = this.getDefaultCurrency();
                if (node == null) {
                    node = DefaultCurrencies.buildNode(Locale.getDefault());
                    node.setExchangeRateDAO(this.exchangeRateDAO);
                }
                root = new RootAccount(node);
                root.setName(this.rb.getString("Name.Root"));
                root.setDescription(this.rb.getString("Name.Root"));
                this.logInfo("Creating RootAccount");
                if (!this.getAccountDAO().addRootAccount(root)) {
                    this.logSevere("Was not able to add the root account");
                    throw new RuntimeException("Was not able to add the root account");
                }
                if (this.getDefaultCurrency() == null) {
                    this.setDefaultCurrency(node);
                }
            }
        }
        finally {
            accountWriteLock.unlock();
            commodityWriteLock.unlock();
        }
        this.logInfo("Engine initialization is complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCorrect() {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        ReentrantReadWriteLock.WriteLock configWriteLock = this.configLock.writeLock();
        commodityWriteLock.lock();
        accountWriteLock.lock();
        configWriteLock.lock();
        try {
            if (this.getConfig().getFileVersion() < 2.02f) {
                for (Account account : this.getAccountDAO().getAccountList()) {
                    if (account.getParent() != null || account.instanceOf(AccountType.ROOT)) continue;
                    account.setParent(this.getRootAccount());
                    this.getAccountDAO().updateAccount(account);
                    this.getAccountDAO().updateAccount(this.getRootAccount());
                    this.logInfo("Fixing a detached account: " + account.getName());
                }
            }
            if (this.getConfig().getFileVersion() < 2.01f) {
                this.logInfo("Checking for null account numbers");
                for (Account account : this.getAccountDAO().getAccountList()) {
                    if (account.getAccountNumber() != null) continue;
                    account.setAccountNumber("");
                    this.getAccountDAO().updateAccount(account);
                    this.logInfo("Fixed null account number");
                }
            }
            if (this.getConfig().getFileVersion() < 2.02f) {
                this.logInfo("Checking for a recursive account structure");
                for (Account account : this.getAccountDAO().getAccountList()) {
                    if (!account.equals(account.getParent())) continue;
                    this.logWarning("Correcting recursive account structure:" + account.getName());
                    account.setParent(this.getRootAccount());
                    this.getAccountDAO().updateAccount(account);
                    this.getAccountDAO().updateAccount(this.getRootAccount());
                }
            }
            if (this.getConfig().getFileVersion() < 2.03f) {
                this.clearObsoleteExchangeRates();
            }
            if (this.getConfig().getFileVersion() < 2.04f) {
                ArrayList<RootAccount> roots = new ArrayList<RootAccount>();
                for (StoredObject o : this.getStoredObjects()) {
                    if (!(o instanceof RootAccount)) continue;
                    roots.add((RootAccount)o);
                }
                if (roots.size() > 1) {
                    logger.warning("Removing extra root accounts");
                    RootAccount root = (RootAccount)roots.get(0);
                    for (int i = 1; i < roots.size(); ++i) {
                        RootAccount extraRoot = (RootAccount)roots.get(i);
                        for (Account child : extraRoot.getChildren()) {
                            this.moveAccount(child, root);
                        }
                        this.moveObjectToTrash(extraRoot);
                    }
                }
            }
            if (this.getConfig().getFileVersion() < 2.1f) {
                this.removeDuplicateCurrencies();
            }
            if (this.getConfig().getFileVersion() < 2.2f) {
                for (Account account : this.getAccountList()) {
                    if (account.memberOf(AccountGroup.INCOME) || account.memberOf(AccountGroup.EXPENSE)) continue;
                    account.setExcludedFromBudget(true);
                    this.getAccountDAO().updateAccount(account);
                }
            }
            if (this.getConfig().getFileVersion() != 2.21f) {
                this.getConfig().setFileVersion(2.21f);
                this.getConfigDAO().commit(this.getConfig());
            }
        }
        finally {
            configWriteLock.unlock();
            accountWriteLock.unlock();
            commodityWriteLock.unlock();
        }
    }

    private void removeDuplicateCurrencies() {
        HashMap<String, CurrencyNode> keepMap = new HashMap<String, CurrencyNode>();
        ArrayList<CurrencyNode> discard = new ArrayList<CurrencyNode>();
        CurrencyNode defaultCurrency = this.getDefaultCurrency();
        keepMap.put(defaultCurrency.getSymbol(), defaultCurrency);
        for (CurrencyNode node : this.getCurrencies()) {
            if (!keepMap.containsKey(node.getSymbol())) {
                keepMap.put(node.getSymbol(), node);
                continue;
            }
            if (node == defaultCurrency) continue;
            discard.add(node);
        }
        for (CurrencyNode node : discard) {
            for (Account account : this.getAccountList()) {
                if (account.getCurrencyNode() != node) continue;
                account.setCurrencyNode((CurrencyNode)keepMap.get(node.getSymbol()));
                this.getAccountDAO().updateAccount(account);
            }
            for (SecurityNode sNode : this.getSecurities()) {
                if (sNode.getReportedCurrencyNode() != node) continue;
                sNode.setReportedCurrencyNode((CurrencyNode)keepMap.get(node.getSymbol()));
                this.getCommodityDAO().updateCommodityNode(sNode);
            }
            this.removeCommodity(node);
        }
    }

    private void clearObsoleteExchangeRates() {
        for (ExchangeRate rate : this.getCommodityDAO().getExchangeRates()) {
            if (this.getBaseCurrencies(rate.getRateId()) != null) continue;
            this.removeExchangeRate(rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExchangeRate(ExchangeRate rate) {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            for (ExchangeRateHistoryNode node : rate.getHistory()) {
                this.removeExchangeRateHistory(rate, node);
            }
            this.moveObjectToTrash(rate);
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    void shutdown() {
        this.trashExecutor.shutdownNow();
        this.eDAO.shutdown();
    }

    public String getName() {
        return this.name;
    }

    private AccountDAO getAccountDAO() {
        return this.eDAO.getAccountDAO();
    }

    private BudgetDAO getBudgetDAO() {
        return this.eDAO.getBudgetDAO();
    }

    private CommodityDAO getCommodityDAO() {
        return this.eDAO.getCommodityDAO();
    }

    private ConfigDAO getConfigDAO() {
        return this.eDAO.getConfigDAO();
    }

    private RecurringDAO getReminderDAO() {
        return this.eDAO.getRecurringDAO();
    }

    private TransactionDAO getTransactionDAO() {
        return this.eDAO.getTransactionDAO();
    }

    private TrashDAO getTrashDAO() {
        return this.eDAO.getTrashDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveObjectToTrash(StoredObject object) {
        boolean result = false;
        ReentrantReadWriteLock.WriteLock engineWriteLock = this.engineLock.writeLock();
        engineWriteLock.lock();
        try {
            TrashObject trash = new TrashObject(object);
            this.getTrashDAO().add(trash);
            result = true;
        }
        finally {
            engineWriteLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyTrash() {
        ReentrantReadWriteLock.WriteLock engineWriteLock = this.engineLock.writeLock();
        engineWriteLock.lock();
        try {
            logger.info("Checking for trash");
            List<TrashObject> trash = this.getTrashDAO().getTrashObjects();
            if (trash.isEmpty()) {
                logger.info("No trash was found");
            }
            long now = new Date().getTime();
            for (TrashObject o : trash) {
                if (now - o.getDate().getTime() < 300000L) continue;
                this.getTrashDAO().remove(o);
            }
        }
        finally {
            engineWriteLock.unlock();
        }
    }

    public boolean addReminder(Reminder reminder) {
        assert (reminder.getUuid() != null);
        boolean result = this.getReminderDAO().addReminder(reminder);
        Message message = result ? new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_ADD, this) : new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_ADD_FAILED, this);
        message.setObject(MessageProperty.REMINDER, reminder);
        this.messageBus.fireEvent(message);
        return result;
    }

    public boolean removeReminder(Reminder reminder) {
        boolean result = false;
        if (this.moveObjectToTrash(reminder)) {
            Message message = new Message(MessageChannel.REMINDER, ChannelEvent.REMINDER_REMOVE, this);
            message.setObject(MessageProperty.REMINDER, reminder);
            this.messageBus.fireEvent(message);
            result = true;
        }
        return result;
    }

    public List<Reminder> getReminders() {
        return this.getReminderDAO().getReminderList();
    }

    public List<PendingReminder> getPendingReminders() {
        ArrayList<PendingReminder> pendingList = new ArrayList<PendingReminder>();
        List<Reminder> list = this.getReminders();
        Calendar c = Calendar.getInstance();
        Date now = new Date();
        for (Reminder r : list) {
            if (!r.isEnabled()) continue;
            RecurringIterator ri = r.getIterator();
            Date next = ri.next();
            while (next != null) {
                c.setTime(next);
                c.add(5, r.getDaysAdvance() * -1);
                if (DateUtils.before(c.getTime(), now)) {
                    pendingList.add(new PendingReminder(r, DateUtils.trimDate(next)));
                    next = ri.next();
                    continue;
                }
                next = null;
            }
        }
        return pendingList;
    }

    public StoredObject getStoredObjectByUuid(String id) {
        return this.eDAO.getObjectByUuid(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StoredObject> getStoredObjects() {
        ReentrantReadWriteLock.ReadLock engineReadLock = this.engineLock.readLock();
        engineReadLock.lock();
        try {
            List<StoredObject> objects = this.eDAO.getStoredObjects();
            Iterator<StoredObject> i = objects.iterator();
            while (i.hasNext()) {
                StoredObject o = i.next();
                if (!(o instanceof TrashObject) && !o.isMarkedForRemoval()) continue;
                i.remove();
            }
            Collections.sort(objects, new StoredObjectComparator());
            List<StoredObject> list = objects;
            return list;
        }
        finally {
            engineReadLock.unlock();
        }
    }

    private boolean isCommodityNodeValid(CommodityNode node) {
        boolean result = true;
        if (node.getUuid() == null) {
            result = false;
            this.logSevere("Commodity uuid was not valid");
        }
        if (node.getSymbol() == null || node.getSymbol().length() == 0) {
            result = false;
            this.logSevere("Commodity symbol was not valid");
        }
        if (node.getScale() < 0) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " had a scale less than zero");
        }
        if (node instanceof SecurityNode && ((SecurityNode)node).getReportedCurrencyNode() == null) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " was not assigned a currency");
        }
        if (this.eDAO.getObjectByUuid(node.getUuid()) != null) {
            result = false;
            this.logSevere("Commodity " + node.toString() + " was not unique");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCommodity(CommodityNode node) {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            boolean status = this.isCommodityNodeValid(node);
            if (status) {
                if (node instanceof CurrencyNode) {
                    ((CurrencyNode)node).setExchangeRateDAO(this.exchangeRateDAO);
                    if (this.getCurrency(node.getSymbol()) != null) {
                        logger.log(Level.INFO, "Prevented addition of a duplicate CurrencyNode: {0}", node.getSymbol());
                        status = false;
                    }
                } else if (this.getSecurity(node.getSymbol()) != null) {
                    logger.log(Level.INFO, "Prevented addition of a duplicate SecurityNode: {0}", node.getSymbol());
                    status = false;
                }
            }
            if (status) {
                status = this.getCommodityDAO().addCommodity(node);
                logger.log(Level.FINE, "Adding: {0}", node.toString());
            }
            Message message = status ? new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_ADD, this) : new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_ADD_FAILED, this);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = status;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            Message message;
            List<SecurityHistoryNode> list = node.getHistoryNodes();
            for (SecurityHistoryNode h : list) {
                if (!h.equals(hNode)) continue;
                this.removeSecurityHistory(node, h);
                break;
            }
            node.addHistoryNode(hNode);
            boolean status = this.getCommodityDAO().addSecurityHistory(node, hNode);
            if (status) {
                this.clearCachedAccountBalance(node);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_ADD, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_ADD_FAILED, this);
            }
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = status;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    public Set<Account> getInvestmentAccountList(SecurityNode node) {
        HashSet<Account> accounts = new HashSet<Account>();
        for (Account account : this.getInvestmentAccountList()) {
            if (!account.containsSecurity(node)) continue;
            accounts.add(account);
        }
        return accounts;
    }

    public static BigDecimal getMarketPrice(Collection<Transaction> transactions, SecurityNode node, CurrencyNode baseCurrency, Date date) {
        Date testDate = DateUtils.trimDate(date);
        SecurityHistoryNode hNode = node.getHistoryNode(testDate);
        BigDecimal rate = node.getReportedCurrencyNode().getExchangeRate(baseCurrency);
        if (hNode != null && testDate.equals(DateUtils.trimDate(hNode.getDate()))) {
            return hNode.getPrice().multiply(rate);
        }
        Date priceDate = null;
        BigDecimal price = BigDecimal.ZERO;
        block4: for (Transaction t : transactions) {
            if (!(t instanceof InvestmentTransaction)) continue;
            BigDecimal p = ((InvestmentTransaction)t).getPrice();
            if (((InvestmentTransaction)t).getSecurityNode() != node || p == null || p.compareTo(BigDecimal.ZERO) != 1) continue;
            switch (t.getDate().compareTo(testDate)) {
                case -1: {
                    price = p;
                    priceDate = t.getDate();
                    continue block4;
                }
                case 0: {
                    return p;
                }
            }
            break;
        }
        if (hNode == null && priceDate == null) {
            return BigDecimal.ZERO;
        }
        if (priceDate != null && hNode != null ? priceDate.compareTo(hNode.getDate()) >= 0 : hNode == null) {
            return price;
        }
        return hNode.getPrice().multiply(rate);
    }

    private void clearCachedAccountBalance(SecurityNode node) {
        for (Account account : this.getInvestmentAccountList(node)) {
            this.clearCachedAccountBalance(account);
        }
    }

    private void clearCachedAccountBalance(Account account) {
        account.clearCachedBalances();
        this.getAccountDAO().updateAccount(account);
        if (account.getParent() != null && account.getParent().getAccountType() != AccountType.ROOT) {
            this.clearCachedAccountBalance(account.getParent());
        }
    }

    static String buildExchangeRateId(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency) {
        String rateId = baseCurrency.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) > 0 ? baseCurrency.getSymbol() + exchangeCurrency.getSymbol() : exchangeCurrency.getSymbol() + baseCurrency.getSymbol();
        return rateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CurrencyNode[] getBaseCurrencies(String exchangeRateId) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            List<CurrencyNode> currencies = this.getCurrencies();
            Collections.sort(currencies);
            Collections.reverse(currencies);
            for (CurrencyNode node1 : currencies) {
                for (CurrencyNode node2 : currencies) {
                    if (node1 == node2 || !Engine.buildExchangeRateId(node1, node2).equals(exchangeRateId)) continue;
                    CurrencyNode[] currencyNodeArray = new CurrencyNode[]{node1, node2};
                    return currencyNodeArray;
                }
            }
            CurrencyNode[] currencyNodeArray = null;
            return currencyNodeArray;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CurrencyNode> getActiveCurrencies() {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            Set<CurrencyNode> set = this.getCommodityDAO().getActiveCurrencies();
            return set;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyNode getCurrency(String symbol) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            CurrencyNode rNode = null;
            for (CurrencyNode node : this.getCurrencies()) {
                if (!node.getSymbol().equals(symbol)) continue;
                rNode = node;
                break;
            }
            CurrencyNode currencyNode = rNode;
            return currencyNode;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CurrencyNode> getCurrencies() {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            List<CurrencyNode> list = this.getCommodityDAO().getCurrencies();
            return list;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecurityHistoryNode> getSecurityHistory(SecurityNode node) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            List<SecurityHistoryNode> list = node.getHistoryNodes();
            return list;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeRate getExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            ExchangeRate exchangeRate = this.exchangeRateDAO.getExchangeRateNode(baseCurrency, exchangeCurrency);
            return exchangeRate;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecurityNode> getSecurities() {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            List<SecurityNode> list = this.getCommodityDAO().getSecurities();
            return list;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityNode getSecurity(String symbol) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        commodityReadLock.lock();
        try {
            List<SecurityNode> list = this.getSecurities();
            SecurityNode sNode = null;
            for (SecurityNode node : list) {
                if (!node.getSymbol().equals(symbol)) continue;
                sNode = node;
                break;
            }
            SecurityNode securityNode = sNode;
            return securityNode;
        }
        finally {
            commodityReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCommodityNodeUsed(CommodityNode node) {
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        ReentrantReadWriteLock.ReadLock accountReadLock = this.accountLock.readLock();
        commodityReadLock.lock();
        accountReadLock.lock();
        try {
            List<Account> list = this.getAccountList();
            for (Account a : list) {
                if (a.getCurrencyNode().equals(node)) {
                    boolean bl = true;
                    return bl;
                }
                if (a.getAccountType() != AccountType.INVEST && a.getAccountType() != AccountType.MUTUAL) continue;
                for (SecurityNode j : a.getSecurities()) {
                    if (!j.equals(node) && !j.getReportedCurrencyNode().equals(node)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            List<SecurityNode> sList = this.getSecurities();
            for (SecurityNode sNode : sList) {
                if (!sNode.getReportedCurrencyNode().equals(node)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            accountReadLock.unlock();
            commodityReadLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCommodity(CommodityNode node) {
        boolean status = true;
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            if (this.isCommodityNodeUsed(node)) {
                status = false;
            } else {
                if (node instanceof SecurityNode) {
                    List<SecurityHistoryNode> hNodes = ((SecurityNode)node).getHistoryNodes();
                    for (SecurityHistoryNode hNode : hNodes) {
                        this.removeSecurityHistory((SecurityNode)node, hNode);
                    }
                } else {
                    this.clearObsoleteExchangeRates();
                }
                this.moveObjectToTrash(node);
            }
            Message message = status ? new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_REMOVE, this) : new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_REMOVE_FAILED, this);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = status;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            Message message;
            node.removeHistoryNode(hNode);
            boolean status = this.getCommodityDAO().removeSecurityHistory(node, hNode);
            if (status) {
                this.clearCachedAccountBalance(node);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_REMOVE, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.COMMODITY_HISTORY_REMOVE_FAILED, this);
            }
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = status;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCurrency(CurrencyNode defaultCurrency) {
        if (!this.isStored(defaultCurrency)) {
            this.addCommodity(defaultCurrency);
        }
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        ReentrantReadWriteLock.WriteLock configWriteLock = this.configLock.writeLock();
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        accountWriteLock.lock();
        configWriteLock.lock();
        commodityWriteLock.lock();
        try {
            Config c = this.getConfig();
            c.setDefaultCurrency(defaultCurrency);
            this.getConfigDAO().commit(c);
            this.logInfo("Setting default currency: " + defaultCurrency.toString());
            RootAccount root = this.getRootAccount();
            root.setCurrencyNode(defaultCurrency);
            this.getAccountDAO().updateAccount(root);
        }
        finally {
            commodityWriteLock.unlock();
            configWriteLock.unlock();
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config getConfig() {
        ReentrantReadWriteLock.ReadLock configReadLock = this.configLock.readLock();
        configReadLock.lock();
        try {
            if (this.config == null) {
                this.config = this.getConfigDAO().getDefaultConfig();
            }
            Config config = this.config;
            return config;
        }
        finally {
            configReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrencyNode getDefaultCurrency() {
        ReentrantReadWriteLock.ReadLock configReadLock = this.configLock.readLock();
        ReentrantReadWriteLock.ReadLock commodityReadLock = this.commodityLock.readLock();
        configReadLock.lock();
        commodityReadLock.lock();
        try {
            CurrencyNode node = this.getConfig().getDefaultCurrency();
            if (node == null) {
                logger.warning("No default currency assigned");
            }
            CurrencyNode currencyNode = node;
            return currencyNode;
        }
        finally {
            commodityReadLock.unlock();
            configReadLock.unlock();
        }
    }

    public void setExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency, BigDecimal rate) {
        this.setExchangeRate(baseCurrency, exchangeCurrency, rate, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExchangeRate(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency, BigDecimal rate, Date date) {
        assert (rate != null && rate.compareTo(BigDecimal.ZERO) > 0);
        if (baseCurrency.equals(exchangeCurrency)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            ExchangeRate exchangeRate = this.getExchangeRate(baseCurrency, exchangeCurrency);
            if (exchangeRate == null) {
                exchangeRate = new ExchangeRate(Engine.buildExchangeRateId(baseCurrency, exchangeCurrency));
            }
            ExchangeRateHistoryNode historyNode = baseCurrency.getSymbol().compareToIgnoreCase(exchangeCurrency.getSymbol()) > 0 ? new ExchangeRateHistoryNode(DateUtils.trimDate(date), rate) : new ExchangeRateHistoryNode(DateUtils.trimDate(date), BigDecimal.ONE.divide(rate, MathConstants.mathContext));
            List<ExchangeRateHistoryNode> history = exchangeRate.getHistory();
            for (ExchangeRateHistoryNode node : history) {
                if (!node.equals(historyNode)) continue;
                this.removeExchangeRateHistory(exchangeRate, node);
            }
            exchangeRate.addHistoryNode(historyNode);
            this.getCommodityDAO().addExchangeRateHistory(exchangeRate, historyNode);
            Message message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_ADD, this);
            message.setObject(MessageProperty.EXCHANGERATE, exchangeRate);
            this.messageBus.fireEvent(message);
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExchangeRateHistory(ExchangeRate exchangeRate, ExchangeRateHistoryNode history) {
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            Message message;
            if (exchangeRate.contains(history)) {
                exchangeRate.removeHistoryNode(history);
                this.getCommodityDAO().removeExchangeRateHistory(exchangeRate, history);
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_REMOVE, this);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.EXCHANGERATE_REMOVE_FAILED, this);
            }
            message.setObject(MessageProperty.EXCHANGERATE, exchangeRate);
            this.messageBus.fireEvent(message);
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCommodity(CommodityNode oldNode, CommodityNode templateNode) {
        assert (oldNode != null && templateNode != null);
        assert (oldNode != templateNode);
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        commodityWriteLock.lock();
        try {
            Message message;
            boolean status = true;
            if (oldNode.getClass().equals(templateNode.getClass())) {
                oldNode.setDescription(templateNode.getDescription());
                oldNode.setPrefix(templateNode.getPrefix());
                oldNode.setScale(templateNode.getScale());
                oldNode.setSuffix(templateNode.getSuffix());
                if (templateNode instanceof SecurityNode) {
                    oldNode.setSymbol(templateNode.getSymbol());
                    ((SecurityNode)oldNode).setReportedCurrencyNode(((SecurityNode)templateNode).getReportedCurrencyNode());
                    ((SecurityNode)oldNode).setQuoteSource(((SecurityNode)templateNode).getQuoteSource());
                    ((SecurityNode)oldNode).setISIN(((SecurityNode)templateNode).getISIN());
                }
                this.getCommodityDAO().updateCommodityNode(oldNode);
            } else {
                status = false;
                logger.warning("Template object class did not match old object class");
            }
            if (status) {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_MODIFY, this);
                message.setObject(MessageProperty.COMMODITY, oldNode);
            } else {
                message = new Message(MessageChannel.COMMODITY, ChannelEvent.CURRENCY_MODIFY_FAILED, this);
                message.setObject(MessageProperty.COMMODITY, templateNode);
            }
            this.messageBus.fireEvent(message);
            boolean bl = status;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
        }
    }

    public void updateReminder(Reminder reminder) {
        this.getReminderDAO().updateReminder(reminder);
    }

    private void logInfo(String message) {
        logger.log(Level.INFO, message);
    }

    private void logWarning(String message) {
        logger.warning(message);
    }

    private void logSevere(String message) {
        logger.severe(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountSeparator(String separator) {
        ReentrantReadWriteLock.WriteLock configWriteLock = this.configLock.writeLock();
        configWriteLock.lock();
        try {
            this.accountSeparator = separator;
            Config c = this.getConfig();
            c.setAccountSeparator(separator);
            this.getConfigDAO().commit(c);
        }
        finally {
            configWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccountSeparator() {
        ReentrantReadWriteLock.ReadLock configReadLock = this.configLock.readLock();
        configReadLock.lock();
        try {
            if (this.accountSeparator == null) {
                this.accountSeparator = this.getConfig().getAccountSeparator();
            }
            String string = this.accountSeparator;
            return string;
        }
        finally {
            configReadLock.unlock();
        }
    }

    public List<Account> getAccountList() {
        List<Account> accounts = this.getAccountDAO().getAccountList();
        accounts.remove(this.getRootAccount());
        return accounts;
    }

    public Account getAccountByUuid(String id) {
        return this.getAccountDAO().getAccountByUuid(id);
    }

    public Account getAccountByName(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Specified name may not be null");
        }
        List<Account> list = this.getAccountList();
        Collections.sort(list);
        for (Account account : list) {
            if (!accountName.equals(account.getName())) continue;
            return account;
        }
        return null;
    }

    public List<Account> getIncomeAccountList() {
        return this.getAccountDAO().getIncomeAccountList();
    }

    public List<Account> getExpenseAccountList() {
        return this.getAccountDAO().getExpenseAccountList();
    }

    public List<Account> getAccounts(AccountGroup group) {
        ArrayList<Account> accountList = new ArrayList<Account>();
        List<Account> list = this.getAccountList();
        for (Account account : list) {
            if (!account.memberOf(group)) continue;
            accountList.add(account);
        }
        return accountList;
    }

    public List<Account> getInvestmentAccountList() {
        return this.getAccountDAO().getInvestmentAccountList();
    }

    public void refreshAccount(Account account) {
        this.getAccountDAO().refreshAccount(account);
    }

    public void refreshBudget(Budget budget) {
        this.getBudgetDAO().refreshBudget(budget);
    }

    public void refreshCommodity(CommodityNode node) {
        this.getCommodityDAO().refreshCommodityNode(node);
    }

    public void refreshExchangeRate(ExchangeRate rate) {
        this.getCommodityDAO().refreshExchangeRate(rate);
    }

    public void refreshReminder(Reminder reminder) {
        this.getReminderDAO().refreshReminder(reminder);
    }

    public void refreshTransaction(Transaction transaction) {
        this.getTransactionDAO().refreshTransaction(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAccount(Account parent, Account child) {
        assert (child != null);
        assert (child.getUuid() != null);
        if (child.getAccountType() == AccountType.ROOT) {
            throw new RuntimeException("Invalid Account");
        }
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            boolean result = parent.addChild(child);
            if (result) {
                result = this.getAccountDAO().addAccount(parent, child);
            }
            if (result) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_ADD, this);
                message.setObject(MessageProperty.ACCOUNT, child);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountAdd"));
                result = true;
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_ADD_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, child);
                this.messageBus.fireEvent(message);
                result = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootAccount getRootAccount() {
        ReentrantReadWriteLock.ReadLock accountReadLock = this.accountLock.readLock();
        accountReadLock.lock();
        try {
            if (this.rootAccount == null) {
                this.rootAccount = this.getAccountDAO().getRootAccount();
            }
            RootAccount rootAccount = this.rootAccount;
            return rootAccount;
        }
        finally {
            accountReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveAccount(Account account, Account newParent) {
        assert (account != null && newParent != null);
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            Message message;
            if (account.contains(newParent)) {
                Message message2 = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY_FAILED, this);
                message2.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message2);
                this.logInfo(this.rb.getString("Message.AccountMoveFailed"));
                boolean bl = false;
                return bl;
            }
            Account oldParent = account.getParent();
            if (oldParent != null) {
                oldParent.removeChild(account);
                this.getAccountDAO().updateAccount(account);
                this.getAccountDAO().updateAccount(oldParent);
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
                message.setObject(MessageProperty.ACCOUNT, oldParent);
                this.messageBus.fireEvent(message);
            }
            newParent.addChild(account);
            this.getAccountDAO().updateAccount(account);
            this.getAccountDAO().updateAccount(newParent);
            message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
            message.setObject(MessageProperty.ACCOUNT, newParent);
            this.messageBus.fireEvent(message);
            this.logInfo(this.rb.getString("Message.AccountModify"));
            boolean bl = true;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyAccount(Account template, Account account) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            boolean result;
            account.setName(template.getName());
            account.setDescription(template.getDescription());
            account.setNotes(template.getNotes());
            account.setLocked(template.isLocked());
            account.setPlaceHolder(template.isPlaceHolder());
            account.setVisible(template.isVisible());
            account.setExcludedFromBudget(template.isExcludedFromBudget());
            account.setAccountNumber(template.getAccountNumber());
            account.setBankId(template.getBankId());
            if (account.getAccountType().isMutable()) {
                account.setAccountType(template.getAccountType());
            }
            if (account.getTransactionCount() == 0) {
                account.setCurrencyNode(template.getCurrencyNode());
            }
            if (result = this.getAccountDAO().updateAccount(account)) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountModify"));
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            if (account.parentAccount != template.parentAccount && template.parentAccount != null && result) {
                this.moveAccount(account, template.parentAccount);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountNumber(Account account, String number) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            account.setAccountNumber(number);
            this.getAccountDAO().updateAccount(account);
            Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_MODIFY, this);
            message.setObject(MessageProperty.ACCOUNT, account);
            this.messageBus.fireEvent(message);
            this.logInfo(this.rb.getString("Message.AccountModify"));
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(Account account) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            Message message;
            boolean result = false;
            if (account.getTransactionCount() > 0 || account.getChildCount() > 0) {
                result = false;
            } else {
                Account parent = account.getParent();
                if (parent != null && (result = parent.removeChild(account))) {
                    this.getAccountDAO().updateAccount(parent);
                    for (Budget budget : this.getBudgetList()) {
                        budget.removeBudgetGoal(account);
                        this.updateBudget(budget);
                    }
                }
                this.moveObjectToTrash(account);
            }
            if (result) {
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_REMOVE, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                this.logInfo(this.rb.getString("Message.AccountRemove"));
            } else {
                message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_REMOVE_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAmortizeObject(Account account, AmortizeObject amortizeObject) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            if (account != null && amortizeObject != null && account.getAccountType() == AccountType.LIABILITY) {
                AmortizeObject oldAmortizeObject = (AmortizeObject)account.getProperty(AccountProperty.AMORTIZEOBJECT);
                if (oldAmortizeObject != null && account.removeProperty(AccountProperty.AMORTIZEOBJECT) && !this.getAccountDAO().removeAccountProperty(account, oldAmortizeObject)) {
                    this.logSevere("Was not able to remove the old amortize object");
                }
                account.setProperty(AccountProperty.AMORTIZEOBJECT, amortizeObject);
                if (!this.getAccountDAO().setAccountProperty(account, amortizeObject)) {
                    this.logSevere("Was not able to save the amortize object");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAccountVisibility(Account account) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            boolean result = false;
            account.setVisible(!account.isVisible());
            if (this.getAccountDAO().toggleAccountVisibility(account)) {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_VISIBILITY_CHANGE, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
                result = true;
            } else {
                Message message = new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_VISIBILITY_CHANGE_FAILED, this);
                message.setObject(MessageProperty.ACCOUNT, account);
                this.messageBus.fireEvent(message);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAccountSecurity(Account account, SecurityNode node) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        accountWriteLock.lock();
        commodityWriteLock.lock();
        try {
            boolean result = account.addSecurity(node);
            if (result) {
                result = this.getAccountDAO().addAccountSecurity(account, node);
            }
            Message message = result ? new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_ADD, this) : new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_ADD_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, account);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = result;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAccountSecurity(Account account, SecurityNode node) {
        assert (node != null);
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
        accountWriteLock.lock();
        commodityWriteLock.lock();
        try {
            boolean result = account.removeSecurity(node);
            if (result) {
                this.getAccountDAO().updateAccount(account);
            }
            Message message = result ? new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_REMOVE, this) : new Message(MessageChannel.ACCOUNT, ChannelEvent.ACCOUNT_SECURITY_REMOVE_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, account);
            message.setObject(MessageProperty.COMMODITY, node);
            this.messageBus.fireEvent(message);
            boolean bl = result;
            return bl;
        }
        finally {
            commodityWriteLock.unlock();
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccountSecurities(Account acc, Collection<SecurityNode> list) {
        boolean result = false;
        if (acc.memberOf(AccountGroup.INVEST)) {
            ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
            ReentrantReadWriteLock.WriteLock commodityWriteLock = this.commodityLock.writeLock();
            accountWriteLock.lock();
            commodityWriteLock.lock();
            try {
                Set<SecurityNode> oldList = acc.getSecurities();
                for (SecurityNode node : oldList) {
                    if (list.contains(node)) continue;
                    this.removeAccountSecurity(acc, node);
                }
                for (SecurityNode node : list) {
                    if (oldList.contains(node)) continue;
                    this.addAccountSecurity(acc, node);
                }
                result = true;
            }
            finally {
                commodityWriteLock.unlock();
                accountWriteLock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBudget(Budget budget) {
        ReentrantReadWriteLock.WriteLock budgetWriteLock = this.budgetLock.writeLock();
        budgetWriteLock.lock();
        try {
            boolean result = this.getBudgetDAO().add(budget);
            Message message = result ? new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_ADD, this) : new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_ADD_FAILED, this);
            message.setObject(MessageProperty.BUDGET, budget);
            this.messageBus.fireEvent(message);
            boolean bl = result;
            return bl;
        }
        finally {
            budgetWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBudget(Budget budget) {
        boolean result = false;
        ReentrantReadWriteLock.WriteLock writeLock = this.budgetLock.writeLock();
        writeLock.lock();
        try {
            this.moveObjectToTrash(budget);
            Message message = new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_REMOVE, this);
            message.setObject(MessageProperty.BUDGET, budget);
            this.messageBus.fireEvent(message);
            result = true;
        }
        finally {
            writeLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBudgetGoals(Budget budget, Account account, BudgetGoal newGoals) {
        ReentrantReadWriteLock.WriteLock writeLock = this.budgetLock.writeLock();
        writeLock.lock();
        try {
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod();
            BudgetGoal oldGoals = budget.getBudgetGoal(account);
            List<BudgetPeriodDescriptor> descriptorList = BudgetPeriodDescriptorFactory.getDescriptors(DateUtils.getCurrentYear(), budgetPeriod);
            ArrayList<BudgetPeriodDescriptor> changedDescriptors = new ArrayList<BudgetPeriodDescriptor>();
            for (BudgetPeriodDescriptor descriptor : descriptorList) {
                BigDecimal newAmount;
                BigDecimal oldAmount = oldGoals.getGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod());
                if (oldAmount.compareTo(newAmount = newGoals.getGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod())) == 0) continue;
                changedDescriptors.add(descriptor);
            }
            budget.setBudgetGoal(account, newGoals);
            this.updateBudgetGoals(budget, account, changedDescriptors);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBudgetGoals(Budget budget, Account account, List<BudgetPeriodDescriptor> changedPeriods) {
        ReentrantReadWriteLock.WriteLock writeLock = this.budgetLock.writeLock();
        writeLock.lock();
        try {
            boolean result = this.getBudgetDAO().update(budget);
            Message baseMessage = result ? new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_GOAL_UPDATE, this) : new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_GOAL_UPDATE_FAILED, this);
            baseMessage.setObject(MessageProperty.BUDGET, budget);
            baseMessage.setObject(MessageProperty.ACCOUNT, account);
            for (BudgetPeriodDescriptor period : changedPeriods) {
                try {
                    Message message = baseMessage.clone();
                    message.setMessage(BudgetPeriodDescriptor.encodeToString(period));
                    this.messageBus.fireEvent(message);
                }
                catch (CloneNotSupportedException e) {
                    logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            logger.log(Level.FINE, "Budget goal updated for {0}", account.getPathName());
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBudget(Budget budget) {
        ReentrantReadWriteLock.WriteLock writeLock = this.budgetLock.writeLock();
        writeLock.lock();
        try {
            boolean result = this.getBudgetDAO().update(budget);
            Message message = result ? new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_UPDATE, this) : new Message(MessageChannel.BUDGET, ChannelEvent.BUDGET_UPDATE_FAILED, this);
            message.setObject(MessageProperty.BUDGET, budget);
            this.messageBus.fireEvent(message);
            logger.log(Level.FINE, "Budget updated");
            boolean bl = result;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Budget> getBudgetList() {
        ReentrantReadWriteLock.ReadLock readLock = this.budgetLock.readLock();
        readLock.lock();
        try {
            List<Budget> list = this.getBudgetDAO().getBudgets();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean isTransactionValid(Transaction transaction) {
        for (Account a : transaction.getAccounts()) {
            if (!a.isLocked()) continue;
            this.logWarning(this.rb.getString("Message.TransactionAccountLocked"));
            return false;
        }
        if (transaction.isMarkedForRemoval()) {
            logger.log(Level.WARNING, "Transaction already marked for removal");
            return false;
        }
        if (this.eDAO.getObjectByUuid(transaction.getUuid()) != null) {
            logger.log(Level.WARNING, "Transaction UUID was not unique");
            return false;
        }
        if (transaction.size() < 1) {
            logger.log(Level.WARNING, "Invalid Transaction");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e != null) continue;
            logger.log(Level.WARNING, "Null TransactionEntry");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e.getTransactionTag() != null) continue;
            logger.log(Level.WARNING, "Null TransactionTag");
            return false;
        }
        for (TransactionEntry e : transaction.getTransactionEntries()) {
            if (e.getCreditAccount() == null) {
                logger.log(Level.WARNING, "Null Credit Account");
                return false;
            }
            if (e.getDebitAccount() == null) {
                logger.log(Level.WARNING, "Null Debit Account");
                return false;
            }
            if (e.getCreditAmount() == null) {
                logger.log(Level.WARNING, "Null Credit Amount");
                return false;
            }
            if (e.getDebitAmount() != null) continue;
            logger.log(Level.WARNING, "Null Debit Amount");
            return false;
        }
        if (transaction.getTransactionType() == TransactionType.SPLITENTRY && transaction.getCommonAccount() == null) {
            logger.log(Level.WARNING, "Entries do not share a common account");
            return false;
        }
        return !(transaction instanceof InvestmentTransaction) || transaction.getTransactionType() != null;
    }

    public boolean isStored(StoredObject object) {
        return this.eDAO.getObjectByUuid(object.getUuid()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTransaction(Transaction transaction) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            boolean result = this.isTransactionValid(transaction);
            if (result) {
                for (Account account : transaction.getAccounts()) {
                    if (account.addTransaction(transaction)) continue;
                    this.logSevere("Failed to add the Transaction");
                }
                result = this.getTransactionDAO().addTransaction(transaction);
                this.logInfo(this.rb.getString("Message.TransactionAdd"));
            }
            this.postTransactionAdd(transaction, result);
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransaction(Transaction transaction) {
        ReentrantReadWriteLock.WriteLock accountWriteLock = this.accountLock.writeLock();
        accountWriteLock.lock();
        try {
            for (Account account : transaction.getAccounts()) {
                if (!account.isLocked()) continue;
                this.logWarning(this.rb.getString("Message.TransactionRemoveLocked"));
                boolean bl = false;
                return bl;
            }
            for (Account account : transaction.getAccounts()) {
                if (account.removeTransaction(transaction)) continue;
                this.logSevere("Failed to add the Transaction");
            }
            this.logInfo(this.rb.getString("Message.TransactionRemove"));
            boolean result = this.getTransactionDAO().removeTransaction(transaction);
            if (result) {
                this.moveObjectToTrash(transaction);
            }
            this.postTransactionRemove(transaction, result);
            boolean bl = result;
            return bl;
        }
        finally {
            accountWriteLock.unlock();
        }
    }

    public void setTransactionReconciled(Transaction transaction, Account account, ReconciledState state) {
        try {
            Transaction clone = (Transaction)transaction.clone();
            clone.setReconciled(account, state);
            if (this.removeTransaction(transaction)) {
                this.addTransaction(clone);
            }
        }
        catch (CloneNotSupportedException e) {
            this.logSevere("Failed to reconcile the Transaction");
        }
    }

    public List<String> getTransactionNumberList() {
        return this.getConfig().getTransactionNumberList();
    }

    public void setTransactionNumberList(List<String> list) {
        Config c = this.getConfig();
        c.setTransactionNumberList(list);
        this.getConfigDAO().commit(c);
    }

    public List<Transaction> getTransactions() {
        return this.getTransactionDAO().getTransactions();
    }

    private void postTransactionAdd(Transaction transaction, boolean result) {
        for (Account a : transaction.getAccounts()) {
            Message message = result ? new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_ADD, this) : new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_ADD_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, a);
            message.setObject(MessageProperty.TRANSACTION, transaction);
            this.messageBus.fireEvent(message);
        }
    }

    private void postTransactionRemove(Transaction transaction, boolean result) {
        for (Account a : transaction.getAccounts()) {
            Message message = result ? new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_REMOVE, this) : new Message(MessageChannel.TRANSACTION, ChannelEvent.TRANSACTION_REMOVE_FAILED, this);
            message.setObject(MessageProperty.ACCOUNT, a);
            message.setObject(MessageProperty.TRANSACTION, transaction);
            this.messageBus.fireEvent(message);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

