/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util.builder;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jgnash.ui.components.RollOverButton;
import jgnash.ui.util.builder.Action;
import jgnash.util.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ActionParser
extends DefaultHandler {
    private static final String ACTION_ELEMENT = "action";
    private static final String ACTION_NODE_ELEMENT = "action-node";
    private static final String EMPTY_ELEMENT = "empty";
    private static final String ACCEL_ATTRIBUTE = "accel";
    private static final String DESC_ATTRIBUTE = "desc";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ID_ATTRIBUTE = "id";
    public static final String IDREF_ATTRIBUTE = "idref";
    private static final String MNEMONIC_ATTRIBUTE = "mnemonic";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SMICON_ATTRIBUTE = "smicon";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String GROUP_ATTRIBUTE = "group";
    private static final int ACCEL_INDEX = 0;
    private static final int DESC_INDEX = 1;
    private static final int ICON_INDEX = 2;
    private static final int ID_INDEX = 3;
    private static final int MNEMONIC_INDEX = 4;
    private static final int NAME_INDEX = 5;
    private static final int SMICON_INDEX = 6;
    private static final int TYPE_INDEX = 7;
    private static final int METHOD_INDEX = 8;
    private final ArrayList<ActionAttributes> actionList = new ArrayList();
    private final HashMap<String, ActionNode> actionTrees = new HashMap();
    private final HashMap<String, javax.swing.Action> actionMap = new HashMap();
    private final HashMap<String, JMenuItem> menuItemMap = new HashMap();
    private ActionNode currentNode = null;
    private final HashMap<String, ButtonGroup> buttonGroups = new HashMap();
    private final Object target;
    private final Resource rb;
    private static final Logger log = Logger.getLogger(ActionParser.class.getName());

    public ActionParser(Object target, Resource rb) {
        this.target = target;
        this.rb = rb;
    }

    public void preLoadActions(String packageName) {
        try {
            ArrayList<Class<?>> classes = ActionParser.getClasses(packageName);
            for (Class<?> aClass : classes) {
                Action annotation = aClass.getAnnotation(Action.class);
                if (!(annotation instanceof Action)) continue;
                Action action = annotation;
                this.preLoadAction(action.value(), (javax.swing.Action)aClass.newInstance());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.toString(), e);
        }
    }

    void loadFile(InputStream stream) {
        SAXParserFactory parserfactory = SAXParserFactory.newInstance();
        parserfactory.setValidating(false);
        try {
            SAXParser parser = parserfactory.newSAXParser();
            parser.parse(stream, (DefaultHandler)this);
            this.createActions();
        }
        catch (IOException | ParserConfigurationException | SAXException se) {
            log.severe(se.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String fileName) {
        InputStream s = this.getClass().getResourceAsStream(fileName);
        try {
            if (s != null) {
                this.loadFile(s);
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException ioe) {
                log.severe(ioe.toString());
            }
        }
    }

    public void preLoadAction(String id, javax.swing.Action action) {
        action.putValue(ID_ATTRIBUTE, id);
        this.actionMap.put(id, action);
    }

    public javax.swing.Action getAction(String id) {
        return this.actionMap.get(id);
    }

    public JMenuItem getJMenuItem(String idref) {
        JMenuItem o = this.menuItemMap.get(idref);
        if (o != null) {
            return o;
        }
        return null;
    }

    public JMenuBar createMenuBar(String id) {
        JMenuBar menuBar = new JMenuBar();
        ActionNode o = this.actionTrees.get(id);
        if (o != null) {
            ActionNode node = o;
            for (int i = 0; i < node.size(); ++i) {
                JMenuItem item = this.createMenuItem(node.getChildAt(i));
                if (item instanceof JMenu) {
                    menuBar.add((JMenu)item);
                    continue;
                }
                log.log(Level.WARNING, "{0} invalid", item.toString());
            }
        } else {
            log.log(Level.WARNING, "{0} not found", id);
        }
        return menuBar;
    }

    public JToolBar createToolBar(String id) {
        JToolBar toolBar = new JToolBar();
        ActionNode node = this.actionTrees.get(id);
        for (int i = 0; i < node.size(); ++i) {
            if (node.id == null && node.idref == null) {
                toolBar.addSeparator();
                continue;
            }
            JButton button = this.createButton(node.getChildAt(i));
            if (button != null) {
                toolBar.add(button);
                continue;
            }
            log.log(Level.WARNING, "Was not able to create button: {0}", id);
        }
        return toolBar;
    }

    private JButton createButton(ActionNode node) {
        javax.swing.Action a = this.actionMap.get(node.idref);
        return new RollOverButton(a);
    }

    private JMenuItem createMenuItem(ActionNode node) {
        JMenuItem menu;
        javax.swing.Action a = this.actionMap.get(node.idref);
        if (node.size() > 0) {
            menu = new JMenu(a);
            for (int i = 0; i < node.size(); ++i) {
                ActionNode n = node.getChildAt(i);
                if (n.id == null && n.idref == null) {
                    ((JMenu)menu).addSeparator();
                    continue;
                }
                JMenuItem item = this.createMenuItem(n);
                menu.add(item);
            }
        } else if (node.type == null || node.type.isEmpty()) {
            menu = new JMenuItem(a);
        } else {
            switch (node.type) {
                case "single": {
                    menu = new JCheckBoxMenuItem(a);
                    break;
                }
                case "toggle": {
                    menu = new JRadioButtonMenuItem(a);
                    if (node.group != null) {
                        ButtonGroup bGroup;
                        if (this.buttonGroups.get(node.group) != null) {
                            bGroup = this.buttonGroups.get(node.group);
                        } else {
                            bGroup = new ButtonGroup();
                            this.buttonGroups.put(node.group, bGroup);
                        }
                        bGroup.add(menu);
                    }
                    break;
                }
                default: {
                    menu = new JMenuItem(a);
                }
            }
        }
        this.menuItemMap.put(node.idref, menu);
        menu.putClientProperty(IDREF_ATTRIBUTE, node.idref);
        return menu;
    }

    void createActions() {
        for (ActionAttributes aa : this.actionList) {
            javax.swing.Action action = this.actionMap.get(aa.getValue(3));
            if (action == null) {
                action = new ReflectiveAction(this.rb.getString(aa.getValue(5)), aa.getValue(8), this.target);
            } else if (aa.getValue(5) != null) {
                action.putValue("Name", this.rb.getString(aa.getValue(5)));
            }
            String accel = aa.getValue(0);
            if (accel != null && accel.trim().length() > 0) {
                KeyStroke stroke = this.rb.getKeyStroke(accel);
                if (stroke != null) {
                    action.putValue("AcceleratorKey", stroke);
                } else {
                    log.log(Level.WARNING, "Bad KeyStroke: {0}", accel);
                }
            }
            if (aa.getValue(2) != null) {
                try {
                    ImageIcon icon = Resource.getIcon(aa.getValue(2));
                    action.putValue("SmallIcon", icon);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, aa.getValue(2) + " not found", e);
                }
            }
            if (aa.getValue(1) != null) {
                action.putValue("ShortDescription", this.rb.getString(aa.getValue(1)));
            }
            if (aa.getValue(4) != null && this.rb.getString(aa.getValue(4)).trim().length() == 1) {
                action.putValue("MnemonicKey", this.rb.getMnemonic(aa.getValue(4)));
            }
            action.putValue(ID_ATTRIBUTE, aa.getValue(3));
            this.actionMap.put(aa.getValue(3), action);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (ACTION_NODE_ELEMENT.equals(qName) && this.currentNode != null) {
            if (this.currentNode.getParent() != null) {
                this.currentNode = this.currentNode.getParent();
            } else {
                assert (this.currentNode.id != null);
                this.actionTrees.put(this.currentNode.id, this.currentNode);
                this.currentNode = null;
            }
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (ACTION_ELEMENT.equals(qName)) {
            assert (this.currentNode == null);
            ActionAttributes aa = new ActionAttributes(atts);
            this.actionList.add(aa);
        } else if (ACTION_NODE_ELEMENT.equals(qName)) {
            if (this.currentNode != null) {
                ActionNode n = new ActionNode(atts);
                this.currentNode.addChild(n);
                this.currentNode = n;
            } else {
                this.currentNode = new ActionNode(atts);
            }
        } else if (EMPTY_ELEMENT.equals(qName) && this.currentNode != null) {
            this.currentNode.addChild(new ActionNode());
        }
    }

    private static ArrayList<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            dirs.add(new File(fileNameDecoded));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ActionParser.findActionClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findActionClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (directory.getPath().contains(".jar!")) {
            try {
                int index = directory.getPath().indexOf(".jar!");
                URL url = new URL("jar:" + directory.getPath().substring(0, index).replace('/', File.separatorChar) + ".jar!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                JarFile jar = conn.getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                String path = packageName.replace('.', '/');
                while (entries.hasMoreElements()) {
                    Class<?> clazz;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(path) || !name.endsWith(".class") || name.contains("$") || !javax.swing.Action.class.isAssignableFrom(clazz = Class.forName(name.substring(0, name.length() - 6).replace('/', '.')))) continue;
                    classes.add(Class.forName(name.substring(0, name.length() - 6).replace('/', '.')));
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else if (!directory.exists()) {
            log.info("Was not a directory");
        } else {
            File[] files;
            for (File file : files = directory.listFiles()) {
                Class<?> clazz;
                String fileName = file.getName();
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(ActionParser.findActionClasses(file, packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class") || fileName.contains("$") || !javax.swing.Action.class.isAssignableFrom(clazz = Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)))) continue;
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
        }
        return classes;
    }

    static class ReflectiveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private transient Method method;
        private transient Object clazz;

        public ReflectiveAction(String name, String methodName, Object clazz) {
            super(name);
            if (methodName != null) {
                this.clazz = clazz;
                try {
                    this.method = clazz.getClass().getMethod(methodName, null);
                }
                catch (NoSuchMethodException nsme) {
                    log.log(Level.WARNING, "No such method: {0}", nsme.getLocalizedMessage());
                    this.setEnabled(false);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.method != null) {
                try {
                    this.method.invoke(this.clazz, (Object[])null);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    static class ActionNode {
        String idref;
        String id;
        String group;
        String type;
        ArrayList<ActionNode> children = null;
        ActionNode parent = null;

        public ActionNode() {
        }

        public ActionNode(Attributes attrs) {
            this.idref = attrs.getValue(ActionParser.IDREF_ATTRIBUTE);
            this.id = attrs.getValue(ActionParser.ID_ATTRIBUTE);
            this.group = attrs.getValue(ActionParser.GROUP_ATTRIBUTE);
            this.type = attrs.getValue(ActionParser.TYPE_ATTRIBUTE);
        }

        public void addChild(ActionNode child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.parent = this;
            this.children.add(child);
        }

        public int size() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        public ActionNode getChildAt(int index) {
            return this.children.get(index);
        }

        public ActionNode getParent() {
            return this.parent;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.id).append(": ").append(this.idref);
            if (this.size() > 0) {
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    b.append('\n');
                    b.append(this.getChildAt(i).toString());
                }
            }
            return b.toString();
        }
    }

    static class ActionAttributes {
        private final String[] array = new String[9];

        public ActionAttributes(Attributes attrs) {
            this.array[0] = attrs.getValue(ActionParser.ACCEL_ATTRIBUTE);
            this.array[1] = attrs.getValue(ActionParser.DESC_ATTRIBUTE);
            this.array[2] = attrs.getValue(ActionParser.ICON_ATTRIBUTE);
            this.array[3] = attrs.getValue(ActionParser.ID_ATTRIBUTE);
            this.array[4] = attrs.getValue(ActionParser.MNEMONIC_ATTRIBUTE);
            this.array[5] = attrs.getValue(ActionParser.NAME_ATTRIBUTE);
            this.array[6] = attrs.getValue(ActionParser.SMICON_ATTRIBUTE);
            this.array[7] = attrs.getValue(ActionParser.TYPE_ATTRIBUTE);
            this.array[8] = attrs.getValue(ActionParser.METHOD_ATTRIBUTE);
        }

        public String getValue(int index) {
            return this.array[index];
        }
    }
}

