/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import jgnash.util.EncodeDecode;

public class DialogUtils {
    private static void addBoundsListener(final Window w, final String prefNode, final String key) {
        String bounds = Preferences.userRoot().node(prefNode).get(key, null);
        if (bounds != null) {
            if (w instanceof JDialog) {
                if (((JDialog)w).isResizable()) {
                    w.setBounds(EncodeDecode.decodeRectangle(bounds));
                } else {
                    w.setLocation(EncodeDecode.decodeRectangle(bounds).getLocation());
                }
            } else {
                w.setBounds(EncodeDecode.decodeRectangle(bounds));
            }
        }
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Preferences p = Preferences.userRoot().node(prefNode);
                p.put(key, EncodeDecode.encodeRectangle(w.getBounds()));
                w.removeWindowListener(this);
            }
        });
        if (w instanceof JDialog) {
            DialogUtils.addEscapeListener((JDialog)w);
        }
    }

    public static void addBoundsListener(Window w, String key) {
        DialogUtils.addBoundsListener(w, w.getClass().getName().replace('.', '/'), key);
    }

    public static void addBoundsListener(Window w) {
        DialogUtils.addBoundsListener(w, "bounds");
    }

    private static void addEscapeListener(final JDialog dialog) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        }, stroke, 2);
    }

    private DialogUtils() {
    }
}

