/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryDividendX;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionTag;
import jgnash.ui.components.AccountSecurityComboBox;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.AccountExchangePanel;
import jgnash.ui.register.invest.AbstractInvTransactionPanel;
import jgnash.ui.util.ValidationFactory;

public final class DividendPanel
extends AbstractInvTransactionPanel {
    private DatePanel datePanel = new DatePanel();
    private JTextField memoField = AutoCompleteFactory.getMemoField();
    private JFloatField dividendField;
    private AccountSecurityComboBox securityCombo;
    private AccountExchangePanel accountExchangePanel;
    private AccountExchangePanel incomeExchangePanel;
    private static final Logger logger = Logger.getLogger(DividendPanel.class.getName());

    DividendPanel(Account account) {
        super(account);
        this.dividendField = new JFloatField(account.getCurrencyNode());
        this.securityCombo = new AccountSecurityComboBox(account);
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.incomeExchangePanel = new AccountExchangePanel(this.getAccount().getCurrencyNode(), null, this.dividendField);
        this.accountExchangePanel = new AccountExchangePanel(this.getAccount().getCurrencyNode(), null, this.dividendField);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.reconciledButton.addKeyListener(this.keyListener);
        this.layoutPanel();
        this.clearForm();
    }

    private void layoutPanel() {
        this.removeAll();
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $nlgap, f:d, $nlgap, f:d, $nlgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)ValidationFactory.wrap(this.securityCombo), (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Memo", (Object)cc.xy(1, 3));
        this.add((Component)this.memoField, (Object)cc.xy(3, 3));
        this.add("Label.Dividend", (Object)cc.xy(5, 3));
        this.add((Component)ValidationFactory.wrap(this.dividendField), (Object)cc.xy(7, 3));
        this.add("Label.IncomeAccount", (Object)cc.xy(1, 5));
        this.add((Component)this.incomeExchangePanel, (Object)cc.xy(3, 5));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(5, 5, 3));
        this.add("Label.Account", (Object)cc.xy(1, 7));
        this.add((Component)this.accountExchangePanel, (Object)cc.xy(3, 7));
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        if (!(tran instanceof InvestmentTransaction)) {
            throw new IllegalArgumentException("bad tranType");
        }
        this.clearForm();
        this.datePanel.setDate(tran.getDate());
        List<TransactionEntry> entries = tran.getTransactionEntries();
        assert (entries.size() <= 2);
        for (TransactionEntry e : entries) {
            if (e instanceof TransactionEntryDividendX) {
                AbstractInvestmentTransactionEntry entry = (AbstractInvestmentTransactionEntry)e;
                this.memoField.setText(e.getMemo());
                this.securityCombo.setSelectedNode(entry.getSecurityNode());
                this.incomeExchangePanel.setSelectedAccount(entry.getDebitAccount());
                this.incomeExchangePanel.setExchangedAmount(entry.getDebitAmount().abs());
                this.dividendField.setDecimal(entry.getAmount(this.getAccount()));
                continue;
            }
            if (e.getTransactionTag() == TransactionTag.INVESTMENT_CASH_TRANSFER) {
                this.accountExchangePanel.setSelectedAccount(e.getCreditAccount());
                this.accountExchangePanel.setExchangedAmount(e.getCreditAmount());
                continue;
            }
            logger.warning("Invalid transaction");
        }
        this.modTrans = tran;
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
    }

    @Override
    public Transaction buildTransaction() {
        BigDecimal incomeExchangedAmount = this.dividendField.getDecimal().negate();
        BigDecimal accountExchangedAmount = this.dividendField.getDecimal();
        if (!this.incomeExchangePanel.getSelectedAccount().getCurrencyNode().equals(this.getAccount().getCurrencyNode())) {
            incomeExchangedAmount = this.incomeExchangePanel.getExchangedAmount().negate();
        }
        if (!this.accountExchangePanel.getSelectedAccount().getCurrencyNode().equals(this.getAccount().getCurrencyNode())) {
            accountExchangedAmount = this.accountExchangePanel.getExchangedAmount();
        }
        return TransactionFactory.generateDividendXTransaction(this.incomeExchangePanel.getSelectedAccount(), this.getAccount(), this.accountExchangePanel.getSelectedAccount(), (SecurityNode)this.securityCombo.getSelectedNode(), this.dividendField.getDecimal(), incomeExchangedAmount, accountExchangedAmount, this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected());
    }

    @Override
    public void clearForm() {
        this.modTrans = null;
        if (!DividendPanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.reconciledButton.setSelected(false);
        this.accountExchangePanel.setSelectedAccount(this.getAccount());
        this.incomeExchangePanel.setSelectedAccount(this.getAccount());
    }

    @Override
    public boolean validateForm() {
        if (this.securityCombo.getSelectedNode() == null) {
            logger.warning(this.rb.getString("Message.Error.SecuritySelection"));
            this.showValidationError(this.rb.getString("Message.Error.SecuritySelection"), this.securityCombo);
            return false;
        }
        if (this.dividendField.getText().equals("")) {
            logger.warning(this.rb.getString("Message.Error.DividendValue"));
            this.showValidationError(this.rb.getString("Message.Error.DividendValue"), this.dividendField);
            return false;
        }
        return true;
    }
}

