/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class ExceptionDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JButton closeButton;
    private Throwable throwable;
    private JTextArea textArea;
    private JButton copyButton;

    public ExceptionDialog(Frame parent, Throwable throwable) {
        super(parent);
        this.setTitle(this.rb.getString("Title.UncaughtException"));
        this.setModal(true);
        this.throwable = throwable;
        this.layoutMainPanel();
        this.closeButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.setDefaultCloseOperation(2);
        DialogUtils.addBoundsListener(this);
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("fill:max(80dlu;p):g", "f:max(120dlu;p):g, 6dlu, f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.copyButton = new JButton(this.rb.getString("Button.CopyToClip"));
        this.textArea = ExceptionDialog.getTextArea(this.throwable);
        builder.append((Component)new JScrollPane(this.textArea));
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildRightAlignedBar((JButton[])new JButton[]{this.copyButton, this.closeButton}));
        this.getContentPane().add(builder.getPanel());
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private static JTextArea getTextArea(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        t.printStackTrace(out);
        JTextArea textArea = new JTextArea(10, 30);
        textArea.append(sw.toString());
        return textArea;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.copyButton) {
            this.textArea.selectAll();
            this.textArea.copy();
        }
    }
}

