/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.autocomplete.AutoCompleteModel;

public class AutoCompleteTextField
extends JTextFieldEx {
    private static final long serialVersionUID = -7122559240136664049L;
    private volatile boolean setText = false;
    private AutoCompleteModel model;

    public AutoCompleteTextField(AutoCompleteModel model) {
        this.model = model;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = AutoCompleteTextField.this.getText();
                if (text != null && text.length() > 0) {
                    AutoCompleteTextField.this.setCaretPosition(text.length());
                }
            }
        });
    }

    public AutoCompleteModel getModel() {
        return this.model;
    }

    @Override
    protected Document createDefaultModel() {
        return new AutoCompleteDocument();
    }

    @Override
    public void setText(String t) {
        this.setText = true;
        super.setText(t);
        this.setText = false;
    }

    protected class AutoCompleteDocument
    extends PlainDocument {
        private static final long serialVersionUID = -1369307873189366733L;
        String currText = null;
        String newText = null;

        protected AutoCompleteDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (!AutoCompleteTextField.this.setText) {
                this.currText = this.getText(0, this.getLength());
                this.newText = AutoCompleteTextField.this.model.doLookAhead(this.currText);
                if (this.newText != null) {
                    this.remove(0, this.currText.length());
                    super.insertString(0, this.currText.substring(0, offs + 1) + this.newText.substring(offs + 1), a);
                    AutoCompleteTextField.this.setCaretPosition(this.newText.length());
                    AutoCompleteTextField.this.moveCaretPosition(offs + 1);
                }
            }
        }
    }
}

