/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParserUtil {
    static /* synthetic */ Class class$java$awt$Color;

    public static int parseInt(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static int parseInt(String text, int defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static float parseFloat(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static float parseFloat(String text, float defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static boolean parseBoolean(String text, boolean defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text.equalsIgnoreCase("true");
    }

    public static String parseString(String text, String defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text;
    }

    public static Stroke parseStroke(String weight) {
        try {
            if (weight != null) {
                Float w = new Float(weight);
                return new BasicStroke(w.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new BasicStroke(1.0f);
    }

    public static Color parseColor(String color) {
        return ParserUtil.parseColor(color, Color.black);
    }

    public static Color parseColor(String color, Color defaultValue) {
        if (color == null) {
            return defaultValue;
        }
        try {
            return Color.decode(color);
        }
        catch (NumberFormatException nfe) {
            try {
                Field f = (class$java$awt$Color == null ? (class$java$awt$Color = ParserUtil.class$("java.awt.Color")) : class$java$awt$Color).getField(color);
                return (Color)f.get(null);
            }
            catch (Exception ce) {
                return defaultValue;
            }
        }
    }

    public static float parseRelativeFloat(String value, String exceptionMessage) throws SAXException {
        if (value == null) {
            throw new SAXException(exceptionMessage);
        }
        String tvalue = value.trim();
        if (tvalue.endsWith("%")) {
            String number = tvalue.substring(0, tvalue.indexOf("%"));
            float f = ParserUtil.parseFloat(number, exceptionMessage) * -1.0f;
            return f;
        }
        return ParserUtil.parseFloat(tvalue, exceptionMessage);
    }

    public static Rectangle2D getElementPosition(Attributes atts) throws SAXException {
        float x = ParserUtil.parseRelativeFloat(atts.getValue("x"), "Element x not specified");
        float y = ParserUtil.parseRelativeFloat(atts.getValue("y"), "Element y not specified");
        float w = ParserUtil.parseRelativeFloat(atts.getValue("width"), "Element width not specified");
        float h = ParserUtil.parseRelativeFloat(atts.getValue("height"), "Element height not specified");
        Rectangle2D.Float retval = new Rectangle2D.Float(x, y, w, h);
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

