/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.Account;
import jgnash.imports.BayesImportClassifier;
import jgnash.imports.GenericImport;
import jgnash.imports.ImportBank;
import jgnash.imports.ImportTransaction;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.JTableUtils;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.imports.ImportDialog;
import jgnash.ui.wizards.imports.ImportTable;
import jgnash.util.Resource;

public class ImportTwo
extends JPanel
implements WizardPage,
ActionListener {
    private Resource rb = Resource.get();
    private JButton deleteButton;
    private JTextPane helpPane;
    private ImportTable table;

    public ImportTwo() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.table = new ImportTable();
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.helpPane = new JTextPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("ImportTwo.txt"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ImportTwo.this.refreshInfo();
            }
        });
        this.deleteButton.addActionListener(this);
        JTableUtils.packGenericTable(this.table);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, d:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.ModImportTrans"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"p"));
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:85dlu:g"));
        builder.append((Component)new JScrollPane(this.table), 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.deleteButton);
    }

    void refreshInfo() {
        this.table.fireTableDataChanged();
    }

    @Override
    public boolean isPageValid() {
        return this.table.getTransactions() != null;
    }

    @Override
    public String toString() {
        return "2. " + this.rb.getString("Title.ModImportTrans");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.table.deleteSelected();
        }
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        ImportBank bank = (ImportBank)map.get((Object)ImportDialog.Settings.BANK);
        if (bank != null) {
            List list = bank.getTransactions();
            Account account = (Account)map.get((Object)ImportDialog.Settings.ACCOUNT);
            for (ImportTransaction t : list) {
                t.account = account;
                t.setState(ImportTransaction.ImportState.NEW);
            }
            GenericImport.matchTransactions((List)list, (Account)account);
            BayesImportClassifier.classifyTransactions((List)list, (Account)account);
            this.table.setTransactions(list);
            this.refreshInfo();
        }
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        map.put(ImportDialog.Settings.TRANSACTIONS, this.table.getTransactions());
    }
}

