/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.file;

import java.awt.Frame;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jgnash.engine.Account;
import jgnash.engine.AccountTreeXMLFactory;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.DataStoreType;
import jgnash.engine.DefaultCurrencies;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.ui.UIApplication;
import jgnash.ui.components.wizard.WizardDialog;
import jgnash.ui.wizards.file.NewFileFour;
import jgnash.ui.wizards.file.NewFileOne;
import jgnash.ui.wizards.file.NewFileSummary;
import jgnash.ui.wizards.file.NewFileThree;
import jgnash.ui.wizards.file.NewFileTwo;
import jgnash.util.Resource;

public class NewFileDialog
extends WizardDialog {
    private NewFileDialog(Frame parent) {
        super(parent);
        this.setTitle(this.rb.getString("Title.NewFile"));
    }

    public static void showDialog(Frame parent) {
        class DisplayDialog
        extends SwingWorker<Set<CurrencyNode>, Object> {
            final /* synthetic */ Frame val$parent;

            DisplayDialog(Frame frame) {
                this.val$parent = frame;
            }

            @Override
            public Set<CurrencyNode> doInBackground() {
                return DefaultCurrencies.generateCurrencies();
            }

            @Override
            protected void done() {
                try {
                    NewFileDialog d = new NewFileDialog(this.val$parent);
                    d.setSetting(Settings.DEFAULT_CURRENCIES, this.get());
                    d.setSetting(Settings.DATABASE_NAME, EngineFactory.getDefaultDatabase());
                    d.addTaskPage(new NewFileOne());
                    d.addTaskPage(new NewFileTwo());
                    d.addTaskPage(new NewFileThree());
                    d.addTaskPage(new NewFileFour());
                    d.addTaskPage(new NewFileSummary());
                    d.setLocationRelativeTo(this.val$parent);
                    d.setVisible(true);
                    if (d.isWizardValid()) {
                        final class Setup
                        extends SwingWorker<Void, Void> {
                            NewFileDialog d;

                            public Setup(NewFileDialog dialog) {
                                this.d = dialog;
                            }

                            @Override
                            protected Void doInBackground() throws Exception {
                                List accountList;
                                Resource rb = Resource.get();
                                UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
                                String database = (String)this.d.getSetting(Settings.DATABASE_NAME);
                                Set nodes = (Set)this.d.getSetting(Settings.CURRENCIES);
                                CurrencyNode defaultCurrency = (CurrencyNode)this.d.getSetting(Settings.DEFAULT_CURRENCY);
                                DataStoreType type = (DataStoreType)((Object)this.d.getSetting(Settings.TYPE));
                                EngineFactory.closeEngine("default");
                                EngineFactory.deleteDatabase(database);
                                Files.createDirectories(new File(new File(database).getParent()).toPath(), new FileAttribute[0]);
                                Engine e = EngineFactory.bootLocalEngine(database, "default", type);
                                if (e.getDefaultCurrency().matches(defaultCurrency)) {
                                    defaultCurrency = e.getDefaultCurrency();
                                }
                                for (CurrencyNode node : nodes) {
                                    if (node.matches(defaultCurrency)) continue;
                                    e.addCommodity(node);
                                }
                                if (!defaultCurrency.equals(e.getDefaultCurrency())) {
                                    e.setDefaultCurrency(defaultCurrency);
                                }
                                if (!(accountList = (List)this.d.getSetting(Settings.ACCOUNT_SET)).isEmpty()) {
                                    for (RootAccount root : accountList) {
                                        AccountTreeXMLFactory.importAccountTree(e, root);
                                    }
                                } else {
                                    RootAccount root = e.getRootAccount();
                                    Account bank = new Account(AccountType.BANK, defaultCurrency);
                                    bank.setDescription(rb.getString("Name.BankAccounts"));
                                    bank.setName(rb.getString("Name.BankAccounts"));
                                    e.addAccount(root, bank);
                                    Account income = new Account(AccountType.INCOME, defaultCurrency);
                                    income.setDescription(rb.getString("Name.IncomeAccounts"));
                                    income.setName(rb.getString("Name.IncomeAccounts"));
                                    e.addAccount(root, income);
                                    Account expense = new Account(AccountType.EXPENSE, defaultCurrency);
                                    expense.setDescription(rb.getString("Name.ExpenseAccounts"));
                                    expense.setName(rb.getString("Name.ExpenseAccounts"));
                                    e.addAccount(root, expense);
                                }
                                EngineFactory.closeEngine("default");
                                EngineFactory.bootLocalEngine(database, "default", type);
                                return null;
                            }

                            @Override
                            protected void done() {
                                UIApplication.getFrame().stopWaitMessage();
                            }
                        }
                        new Setup(d).execute();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    Logger.getLogger(NewFileDialog.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        new DisplayDialog(parent).execute();
    }

    public static enum Settings {
        BACKEND,
        CURRENCIES,
        DEFAULT_CURRENCIES,
        DEFAULT_CURRENCY,
        DATABASE_NAME,
        ACCOUNT_SET,
        TYPE;

    }
}

