/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayer;
import jgnash.ui.AbstractLayerUI;
import jgnash.util.Resource;

public class ValidationFactory {
    private static final Icon errorIcon = Resource.getIcon("/jgnash/resource/validation-error.png");
    private static final String VALIDATION_PROPERTY = "validationProperty";

    private ValidationFactory() {
    }

    public static JComponent wrap(JComponent component) {
        JLayer<JComponent> layer = new JLayer<JComponent>(component);
        layer.setUI(new ValidationUI());
        return layer;
    }

    public static void showValidationError(String error, JComponent component) {
        Container parent = component.getParent();
        if (parent instanceof JLayer) {
            component.putClientProperty(VALIDATION_PROPERTY, error);
            component.repaint();
        }
    }

    private static class ValidationUI
    extends AbstractLayerUI<JComponent> {
        private ValidationUI() {
        }

        @Override
        protected void paintLayer(Graphics2D graphics, JLayer<? extends JComponent> layer) {
            super.paintLayer(graphics, layer);
            if (layer.getView().getClientProperty(ValidationFactory.VALIDATION_PROPERTY) != null) {
                JComponent view = layer.getView();
                String toolTip = (String)view.getClientProperty(ValidationFactory.VALIDATION_PROPERTY);
                view.setToolTipText(toolTip);
                errorIcon.paintIcon(view, graphics, 0, 0);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> layer) {
            if (e.getID() == 500) {
                layer.getView().putClientProperty(ValidationFactory.VALIDATION_PROPERTY, null);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent e, JLayer<? extends JComponent> layer) {
            layer.getView().putClientProperty(ValidationFactory.VALIDATION_PROPERTY, null);
        }
    }
}

