/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AccountSecurityComboBox;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.invest.AbstractInvTransactionPanel;

public abstract class AbstractPriceQtyInvTransactionPanel
extends AbstractInvTransactionPanel {
    protected DatePanel datePanel = new DatePanel();
    protected JTextField memoField = AutoCompleteFactory.getMemoField();
    protected JFloatField priceField;
    protected JFloatField quantityField;
    protected AccountSecurityComboBox securityCombo;
    protected JFloatField totalField;
    protected static final Logger logger = UIApplication.getLogger();

    AbstractPriceQtyInvTransactionPanel(Account account) {
        super(account);
        this.priceField = new JFloatField(0, 6, (int)account.getCurrencyNode().getScale());
        this.quantityField = new JFloatField(0, 6, 2);
        this.reconciledButton = new JCheckBox(this.rb.getString("Button.Reconciled"));
        this.securityCombo = new AccountSecurityComboBox(account);
        this.totalField = new JFloatField(account.getCurrencyNode());
        this.totalField.setEditable(false);
        this.totalField.setFocusable(false);
    }

    @Override
    public void clearForm() {
        this.modTrans = null;
        if (!AbstractPriceQtyInvTransactionPanel.getRememberLastDate()) {
            this.datePanel.setDate(new Date());
        }
        this.memoField.setText(null);
        this.priceField.setDecimal(null);
        this.quantityField.setDecimal(null);
        this.reconciledButton.setSelected(false);
        this.totalField.setDecimal(null);
    }

    @Override
    public boolean validateForm() {
        if (this.securityCombo.getSelectedNode() == null) {
            logger.warning(this.rb.getString("Message.Error.SecuritySelection"));
            AbstractPriceQtyInvTransactionPanel.showValidationError(this.rb.getString("Message.Error.SecuritySelection"), this.securityCombo);
            return false;
        }
        if (this.priceField.getText().equals("")) {
            logger.warning(this.rb.getString("Message.Error.SecurityPrice"));
            AbstractPriceQtyInvTransactionPanel.showValidationError(this.rb.getString("Message.Error.SecurityPrice"), this.priceField);
            return false;
        }
        if (this.quantityField.getText().equals("")) {
            logger.warning(this.rb.getString("Message.Error.SecurityQuantity"));
            AbstractPriceQtyInvTransactionPanel.showValidationError(this.rb.getString("Message.Error.SecurityQuantity"), this.quantityField);
            return false;
        }
        return true;
    }
}

