/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.account.AccountListFilterDialog;
import jgnash.ui.account.AccountListTreePane;
import jgnash.ui.actions.ReconcileAccountAction;
import jgnash.ui.components.RollOverButton;
import jgnash.ui.register.AbstractRegisterPanel;
import jgnash.ui.register.ColumnDialog;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.report.compiled.AccountRegisterReport;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;

public class MainRegisterPanel
extends JPanel
implements ActionListener,
MessageListener {
    private static final String DIVIDER = "DividerLocation";
    private static final String ACTIVE_ACCOUNT = "ActiveAccount";
    private Preferences prefs = Preferences.userNodeForPackage(MainRegisterPanel.class);
    private JSplitPane registerPane;
    private JButton reconcileButton;
    private JButton filterButton;
    private JButton columnsButton;
    private JButton zoomButton;
    private JButton resizeButton;
    private JButton printButton;
    private RegisterTree registerTree;

    public MainRegisterPanel() {
        CSH.setHelpIDString((Component)this, (String)"MainRegisterPanel");
        this.layoutMainPanel();
        this.showLast();
    }

    private void layoutMainPanel() {
        Resource rb = Resource.get();
        JPanel toolPanel = new JPanel();
        this.registerPane = new JSplitPane();
        this.registerPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        toolPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.reconcileButton = new RollOverButton(rb.getString("Button.Reconcile"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.reconcileButton.setToolTipText(rb.getString("ToolTip.Reconcile"));
        this.reconcileButton.addActionListener(this);
        toolBar.add(this.reconcileButton);
        this.filterButton = new RollOverButton(rb.getString("Button.Filter"), Resource.getIcon("/jgnash/resource/preferences-system.png"));
        this.filterButton.setToolTipText(rb.getString("ToolTip.FilterAccounts"));
        this.filterButton.addActionListener(this);
        toolBar.add(this.filterButton);
        this.columnsButton = new RollOverButton(rb.getString("Button.Columns"), Resource.getIcon("/jgnash/resource/stock_select-column.png"));
        this.columnsButton.setToolTipText(rb.getString("ToolTip.ColumnVis"));
        this.columnsButton.addActionListener(this);
        toolBar.add(this.columnsButton);
        this.resizeButton = new RollOverButton(rb.getString("Button.Resize"), Resource.getIcon("/jgnash/resource/stock_table-fit-width.png"));
        this.resizeButton.setToolTipText(rb.getString("ToolTip.ResizeColumns"));
        this.resizeButton.addActionListener(this);
        toolBar.add(this.resizeButton);
        this.zoomButton = new RollOverButton(rb.getString("Button.Zoom"), Resource.getIcon("/jgnash/resource/edit-find.png"));
        this.zoomButton.setToolTipText(rb.getString("ToolTip.ZoomRegister"));
        this.zoomButton.addActionListener(this);
        toolBar.add(this.zoomButton);
        this.printButton = new RollOverButton(rb.getString("Button.Print"), Resource.getIcon("/jgnash/resource/document-print.png"));
        this.printButton.setToolTipText(rb.getString("ToolTip.PrintRegRep"));
        this.printButton.addActionListener(this);
        toolBar.add(this.printButton);
        toolPanel.add((Component)toolBar, "North");
        toolPanel.add((Component)new JSeparator(), "Center");
        this.add((Component)toolPanel, "North");
        this.registerPane.setDividerLocation(50);
        this.registerPane.setContinuousLayout(true);
        this.registerTree = new RegisterTree();
        this.registerTree.setBorder(new EmptyBorder(new Insets(0, 0, 2, 0)));
        this.registerTree.expand();
        this.registerPane.setLeftComponent(this.registerTree);
        this.registerPane.setRightComponent(new JPanel(null));
        this.add((Component)this.registerPane, "Center");
        this.registerPane.setDividerLocation(this.prefs.getInt(DIVIDER, this.registerPane.getDividerLocation()));
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.SYSTEM);
    }

    private AbstractRegisterTableModel getActiveModel() {
        Component o = this.registerPane.getRightComponent();
        if (o instanceof AbstractRegisterPanel) {
            return ((AbstractRegisterPanel)o).getTableModel();
        }
        return null;
    }

    private JTable getActiveTable() {
        Component o = this.registerPane.getRightComponent();
        if (o instanceof AbstractRegisterPanel) {
            return ((AbstractRegisterPanel)o).getTable();
        }
        return null;
    }

    final void showLast() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String uuid = MainRegisterPanel.this.prefs.get(MainRegisterPanel.ACTIVE_ACCOUNT, null);
                if (uuid != null) {
                    MainRegisterPanel.this.setAccount(EngineFactory.getEngine("default").getAccountByUuid(uuid));
                }
            }
        });
    }

    public void setAccount(final Account account) {
        if (account != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainRegisterPanel.this.registerTree.setSelectedAccount(account);
                }
            });
        }
    }

    private void showAccount(final Account account) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainRegisterPanel.this.saveCurrentRegisterLayout();
                int pos = MainRegisterPanel.this.registerPane.getDividerLocation();
                AbstractRegisterPanel p = RegisterFactory.createRegisterPanel(account);
                boolean layout = p.restoreColumnLayout();
                MainRegisterPanel.this.registerPane.setRightComponent(p);
                MainRegisterPanel.this.registerPane.setDividerLocation(pos);
                if (!layout) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JTableUtils.packTable(MainRegisterPanel.this.getActiveTable());
                        }
                    });
                }
                MainRegisterPanel.this.prefs.putInt(MainRegisterPanel.DIVIDER, pos);
                MainRegisterPanel.this.prefs.put(MainRegisterPanel.ACTIVE_ACCOUNT, account.getUuid());
            }
        });
    }

    private void _removeAccount(Account account) {
        if (!this.prefs.get(Integer.toString(account.hashCode()), "empty").equals("empty")) {
            this.prefs.remove(Integer.toString(account.hashCode()));
        }
    }

    private void destroy() {
        MessageBus.getInstance().unregisterListener(this, MessageChannel.ACCOUNT, MessageChannel.SYSTEM);
        this.saveCurrentRegisterLayout();
        this.enableButtons(false);
        this.reconcileButton.removeActionListener(this);
        this.filterButton.removeActionListener(this);
        this.columnsButton.removeActionListener(this);
        this.zoomButton.removeActionListener(this);
        this.resizeButton.removeActionListener(this);
        this.printButton.removeActionListener(this);
        this.prefs.putInt(DIVIDER, this.registerPane.getDividerLocation());
        this.registerPane.removeAll();
        this.removeAll();
    }

    private void enableButtons(final boolean e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainRegisterPanel.this.columnsButton.setEnabled(e);
                MainRegisterPanel.this.filterButton.setEnabled(e);
                MainRegisterPanel.this.printButton.setEnabled(e);
                MainRegisterPanel.this.reconcileButton.setEnabled(e);
                MainRegisterPanel.this.resizeButton.setEnabled(e);
                MainRegisterPanel.this.zoomButton.setEnabled(e);
            }
        });
    }

    private void saveCurrentRegisterLayout() {
        Component o = this.registerPane.getRightComponent();
        if (o instanceof AbstractRegisterPanel) {
            ((AbstractRegisterPanel)o).saveColumnLayout();
        }
    }

    private void columnAction() {
        AbstractRegisterTableModel m = this.getActiveModel();
        if (m != null && ColumnDialog.showDialog(m)) {
            JTable t = this.getActiveTable();
            if (t != null) {
                JTableUtils.packTable(t);
            }
            this.saveCurrentRegisterLayout();
        }
    }

    private void zoomAction() {
        Account a = this.registerTree.getSelectedAccount();
        if (a != null) {
            RegisterFrame.showDialog(this.registerTree.getSelectedAccount());
        }
    }

    private void printAction() {
        int[] rows = this.getActiveTable().getSelectedRows();
        Account a = this.registerTree.getSelectedAccount();
        if (a != null && rows.length < 2) {
            new AccountRegisterReport(a).showReport();
        } else if (a != null) {
            new AccountRegisterReport(this.registerTree.getSelectedAccount(), rows[0], rows[rows.length - 1]).showReport();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.reconcileButton) {
            ReconcileAccountAction.reconcileAccount(this.registerTree.getSelectedAccount());
        } else if (e.getSource() == this.filterButton) {
            this.showAccountFilterDialog();
        } else if (e.getSource() == this.columnsButton) {
            this.columnAction();
        } else if (e.getSource() == this.zoomButton) {
            this.zoomAction();
        } else if (e.getSource() == this.resizeButton) {
            JTableUtils.packTable(this.getActiveTable());
            this.saveCurrentRegisterLayout();
        } else if (e.getSource() == this.printButton) {
            this.printAction();
        }
    }

    public void showAccountFilterDialog() {
        AccountListFilterDialog dlg = new AccountListFilterDialog(this.registerTree);
        dlg.setVisible(true);
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        MainRegisterPanel.this.destroy();
                        break;
                    }
                    case FILE_LOAD_SUCCESS: {
                        MainRegisterPanel.this.showLast();
                        MainRegisterPanel.this.enableButtons(true);
                        break;
                    }
                    case FILE_NEW_SUCCESS: {
                        MainRegisterPanel.this.enableButtons(true);
                        break;
                    }
                    case ACCOUNT_REMOVE: {
                        MainRegisterPanel.this._removeAccount((Account)event.getObject(MessageProperty.ACCOUNT));
                        break;
                    }
                }
            }
        });
    }

    private final class RegisterTree
    extends AccountListTreePane {
        public RegisterTree() {
            super("tree", false);
            this.disablePlaceHolders();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Account account;
            Object o = this.tree.getLastSelectedPathComponent();
            if (o != null && !(account = (Account)((DefaultMutableTreeNode)o).getUserObject()).isPlaceHolder()) {
                super.valueChanged(e);
                Account a = this.getSelectedAccount();
                MainRegisterPanel.this.showAccount(a);
                MainRegisterPanel.this.reconcileButton.setEnabled(a.getTransactionCount() > 0);
            }
        }
    }
}

