/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgnash.Main;
import jgnash.engine.AccountGroup;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.ui.budget.BudgetPanel;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

class BudgetOverviewPanel
extends JPanel
implements ChangeListener {
    private JSpinner yearSpinner;
    private SpinnerNumberModel model;
    private BudgetPanel budgetPanel;
    private JPanel sparklinePanel;
    private final ThreadPoolExecutor updateIconExecutor;
    private static final Logger logger = Logger.getLogger(BudgetPanel.class.getName());

    public BudgetOverviewPanel(BudgetPanel budgetPanel) {
        if (Main.enableVerboseLogging()) {
            logger.setLevel(Level.ALL);
        } else {
            logger.setLevel(Level.OFF);
        }
        this.budgetPanel = budgetPanel;
        this.layoutMainPanel();
        this.setupSpinnerModel();
        this.updateIconExecutor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2));
        this.updateIconExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    private void initComponents() {
        this.sparklinePanel = new JPanel();
        FormLayout layout = new FormLayout("d", "d");
        this.sparklinePanel.setLayout((LayoutManager)layout);
        this.model = new SpinnerNumberModel();
        this.model.setValue(DateUtils.getCurrentYear());
        this.model.setStepSize(1);
        this.yearSpinner = new JSpinner(this.model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.yearSpinner, "####");
        this.yearSpinner.setEditor(editor);
        this.yearSpinner.setEnabled(false);
    }

    private void layoutMainPanel() {
        Resource rb = Resource.get();
        this.initComponents();
        FormLayout layout = new FormLayout("2dlu, right:d, $lcgap, max(40dlu;d), $lcgap, d", "min");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.EMPTY_BORDER);
        builder.add((Component)new JLabel(rb.getString("Label.Year")), CC.xy((int)2, (int)1));
        builder.add((Component)this.yearSpinner, CC.xy((int)4, (int)1));
        builder.add((Component)this.sparklinePanel, CC.xy((int)6, (int)1));
    }

    private void setupSpinnerModel() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Engine engine = EngineFactory.getEngine("default");
                int minYear = DateUtils.getCurrentYear();
                int maxYear = DateUtils.getCurrentYear() + 1;
                for (Transaction transaction : engine.getTransactions()) {
                    int year = DateUtils.getYear(transaction.getDate());
                    minYear = Math.min(minYear, year);
                    maxYear = Math.max(maxYear, year);
                }
                final int _minYear = minYear;
                final int _maxYear = maxYear;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (BudgetOverviewPanel.this.model != null) {
                            BudgetOverviewPanel.this.model.setMinimum(Integer.valueOf(_minYear));
                            BudgetOverviewPanel.this.model.setMaximum(Integer.valueOf(_maxYear));
                        }
                        BudgetOverviewPanel.this.yearSpinner.setEnabled(true);
                        BudgetOverviewPanel.this.yearSpinner.addChangeListener(BudgetOverviewPanel.this);
                    }
                });
            }
        };
        this.budgetPanel.submit(r);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        logger.entering(BudgetOverviewPanel.class.getName(), "stateChanged");
        if (e.getSource() == this.yearSpinner) {
            int year = (Integer)this.model.getNumber();
            this.budgetPanel.setBudgetYear(year);
        }
        logger.exiting(BudgetOverviewPanel.class.getName(), "stateChanged");
    }

    void updateSparkLines() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final ArrayList<AccountGroup> groups = new ArrayList<AccountGroup>(BudgetOverviewPanel.this.budgetPanel.getAccountGroups());
                final ArrayList<Icon> icons = new ArrayList<Icon>();
                for (AccountGroup group : groups) {
                    icons.add(BudgetOverviewPanel.this.budgetPanel.getSparkLineIcon(group));
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int columnCount;
                        int i;
                        FormLayout layout = (FormLayout)BudgetOverviewPanel.this.sparklinePanel.getLayout();
                        BudgetOverviewPanel.this.sparklinePanel.removeAll();
                        for (i = columnCount = layout.getColumnCount(); i >= 1; --i) {
                            layout.removeColumn(i);
                        }
                        if (icons.size() > 0) {
                            layout.appendColumn(ColumnSpec.decode((String)"d"));
                            BudgetOverviewPanel.this.sparklinePanel.add((Component)BudgetOverviewPanel.getLabel((AccountGroup)((Object)groups.get(0)), (Icon)icons.get(0)), CC.xy((int)1, (int)1));
                            for (i = 1; i < icons.size(); ++i) {
                                layout.appendColumn(ColumnSpec.decode((String)"2dlu"));
                                layout.appendColumn(ColumnSpec.decode((String)"d"));
                                BudgetOverviewPanel.this.sparklinePanel.add((Component)BudgetOverviewPanel.getLabel((AccountGroup)((Object)groups.get(i)), (Icon)icons.get(i)), CC.xy((int)(i * 2 + 1), (int)1));
                            }
                        }
                        BudgetOverviewPanel.this.invalidate();
                        BudgetOverviewPanel.this.validate();
                    }
                });
            }
        };
        this.updateIconExecutor.execute(r);
    }

    private static JLabel getLabel(AccountGroup group, Icon icon) {
        JLabel label = new JLabel(group.toString(), icon, 2);
        label.setHorizontalTextPosition(2);
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() - 2.0f));
        return label;
    }
}

