/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jgnash.ui.UIApplication;
import jgnash.ui.util.builder.Action;
import jgnash.util.Resource;

@Action(value="locale-command")
public class DefaultLocaleAction
extends AbstractAction {
    private static final long serialVersionUID = 0L;

    @Override
    public void actionPerformed(ActionEvent e) {
        final Resource rb = Resource.get();
        SwingWorker<LocaleObject[], Void> worker = new SwingWorker<LocaleObject[], Void>(){
            private Object[] options;

            @Override
            public LocaleObject[] doInBackground() {
                this.options = new Object[]{rb.getString("Button.Ok"), rb.getString("Button.Cancel")};
                Locale[] tList = Locale.getAvailableLocales();
                Object[] list = new LocaleObject[tList.length];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = new LocaleObject(tList[i]);
                }
                Arrays.sort(list);
                return list;
            }

            @Override
            public void done() {
                try {
                    JComboBox<Object> combo = new JComboBox<Object>((Object[])this.get());
                    combo.setSelectedItem(new LocaleObject(Locale.getDefault()));
                    int result = JOptionPane.showOptionDialog(UIApplication.getFrame(), combo, rb.getString("Title.SelDefLocale"), 0, -1, null, this.options, this.options[1]);
                    if (result == 0) {
                        LocaleObject o = (LocaleObject)combo.getSelectedItem();
                        Resource.setLocale(o.locale);
                        JOptionPane.showMessageDialog(UIApplication.getFrame(), o.toString() + "\n" + rb.getString("Message.RestartLocale"));
                    }
                }
                catch (HeadlessException | InterruptedException | ExecutionException e) {
                    Logger.getLogger(DefaultLocaleAction.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        };
        worker.execute();
    }

    private static class LocaleObject
    implements Comparable<LocaleObject> {
        final Locale locale;
        private final String display;

        LocaleObject(Locale locale) {
            this.locale = locale;
            this.display = locale.getDisplayName() + " - " + locale.toString() + "  [" + locale.getDisplayName(locale) + "]";
        }

        public final String toString() {
            return this.display;
        }

        @Override
        public int compareTo(LocaleObject o) {
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            assert (obj instanceof LocaleObject);
            return this.equals((LocaleObject)obj);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.locale != null ? this.locale.hashCode() : 0);
            return 47 * hash + (this.display != null ? this.display.hashCode() : 0);
        }

        public boolean equals(LocaleObject obj) {
            return obj.locale.equals(this.locale);
        }
    }
}

