/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.account.AccountFilterModel;
import jgnash.ui.components.expandingtable.AbstractExpandingTableModel;
import jgnash.ui.components.expandingtable.ExpandingTableNode;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.util.Resource;

public final class ExpandingAccountTableModel
extends AbstractExpandingTableModel<Account>
implements AccountFilterModel {
    private boolean incomeVisible = true;
    private boolean expenseVisible = true;
    private boolean accountVisible = true;
    private boolean hiddenVisible = true;
    private transient String[] columnNames;
    private transient Class<?>[] columnTypes;
    private static final Logger logger = Logger.getLogger(ExpandingAccountTableModel.class.getName());
    private transient CommodityFormat formatter = CommodityFormat.getFullFormat();
    private transient Preferences p = Preferences.userNodeForPackage(ExpandingAccountTableModel.class);
    private static final String HIDDEN_VISIBLE = "HiddenVisible";
    private static final String EXPENSE_VISIBLE = "ExpenseVisible";
    private static final String INCOME_VISIBLE = "IncomeVisible";
    private static final String ACCOUNT_VISIBLE = "AccountVisible";
    private transient MessageBusListener messageListener = new MessageBusListener();

    public ExpandingAccountTableModel() {
        logger.setLevel(Level.ALL);
        Resource rb = Resource.get();
        this.columnNames = new String[]{rb.getString("Column.AccountName"), rb.getString("Column.Entries"), rb.getString("Column.Balance"), rb.getString("Column.ReconciledBalance"), rb.getString("Column.Currency"), rb.getString("Column.Type")};
        this.columnTypes = new Class[]{String.class, String.class, BigDecimal.class, BigDecimal.class, String.class, String.class};
        MessageBus.getInstance().registerListener(this.messageListener, MessageChannel.ACCOUNT, MessageChannel.COMMODITY, MessageChannel.SYSTEM);
        AccountBalanceDisplayManager.addAccountBalanceDisplayModeChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandingAccountTableModel.this.fireTableDataChanged();
            }
        });
        this.restorePreferences();
    }

    @Override
    public int getVisibleDepth(Account object) {
        return object.getDepth();
    }

    @Override
    public boolean isParent(Account object) {
        return object.isParent();
    }

    @Override
    public Collection<Account> getChildren(Account object) {
        return object.getChildren();
    }

    @Override
    public boolean isVisible(Account object) {
        AccountType type;
        return super.isVisible(object) && ((type = object.getAccountType()) == AccountType.INCOME && this.isIncomeVisible() ? !object.isVisible() && this.isHiddenVisible() || object.isVisible() : (type == AccountType.EXPENSE && this.isExpenseVisible() ? !object.isVisible() && this.isHiddenVisible() || object.isVisible() : type != AccountType.INCOME && type != AccountType.EXPENSE && this.isAccountVisible() && (!object.isVisible() && this.isHiddenVisible() || object.isVisible())));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        try {
            readLock.lock();
            ExpandingTableNode node = this.getExpandingTableNodeAt(rowIndex);
            if (node == null || node.getObject() == null) {
                logger.log(Level.WARNING, "Null data", new Exception());
                String string = "";
                return string;
            }
            Account account = (Account)node.getObject();
            switch (columnIndex) {
                case 0: {
                    String string = account.getName();
                    return string;
                }
                case 1: {
                    Integer n = account.getTransactionCount();
                    return n;
                }
                case 2: {
                    BigDecimal balance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getTreeBalance());
                    String string = this.formatter.format(balance, account.getCurrencyNode());
                    return string;
                }
                case 3: {
                    BigDecimal reconciledBalance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getReconciledTreeBalance());
                    String string = this.formatter.format(reconciledBalance, account.getCurrencyNode());
                    return string;
                }
                case 4: {
                    String string = account.getCurrencyNode().getSymbol();
                    return string;
                }
                case 5: {
                    String string = account.getAccountType().toString();
                    return string;
                }
            }
            String string = "Error";
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    protected Collection<Account> getModelObjects() {
        Engine engine = EngineFactory.getEngine("default");
        return engine.getAccountList();
    }

    @Override
    protected Account getRootObject() {
        Engine engine = EngineFactory.getEngine("default");
        return engine.getRootAccount();
    }

    @Override
    public String getSearchString(Account object) {
        return object.getName();
    }

    private void restorePreferences() {
        this.setAccountVisible(this.p.getBoolean(ACCOUNT_VISIBLE, true));
        this.setExpenseVisible(this.p.getBoolean(EXPENSE_VISIBLE, true));
        this.setHiddenVisible(this.p.getBoolean(HIDDEN_VISIBLE, true));
        this.setIncomeVisible(this.p.getBoolean(INCOME_VISIBLE, true));
    }

    @Override
    public synchronized void setAccountVisible(boolean visible) {
        if (this.accountVisible != visible) {
            this.p.putBoolean(ACCOUNT_VISIBLE, visible);
            this.accountVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setExpenseVisible(boolean visible) {
        if (this.expenseVisible != visible) {
            this.p.putBoolean(EXPENSE_VISIBLE, visible);
            this.expenseVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setHiddenVisible(boolean visible) {
        if (this.hiddenVisible != visible) {
            this.p.putBoolean(HIDDEN_VISIBLE, visible);
            this.hiddenVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized void setIncomeVisible(boolean visible) {
        if (this.incomeVisible != visible) {
            this.p.putBoolean(INCOME_VISIBLE, visible);
            this.incomeVisible = visible;
            this.fireNodeChanged();
        }
    }

    @Override
    public synchronized boolean isAccountVisible() {
        return this.accountVisible;
    }

    @Override
    public synchronized boolean isExpenseVisible() {
        return this.expenseVisible;
    }

    @Override
    public synchronized boolean isHiddenVisible() {
        return this.hiddenVisible;
    }

    @Override
    public synchronized boolean isIncomeVisible() {
        return this.incomeVisible;
    }

    private void unregister() {
        MessageBus.getInstance().unregisterListener(this.messageListener, MessageChannel.ACCOUNT, MessageChannel.COMMODITY, MessageChannel.SYSTEM);
    }

    @Override
    public Account getParent(Account object) {
        return object.getParent();
    }

    private class MessageBusListener
    implements MessageListener {
        private MessageBusListener() {
        }

        @Override
        public void messagePosted(final Message event) {
            if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
                ExpandingAccountTableModel.this.unregister();
                return;
            }
            if (EngineFactory.getEngine("default") == null) {
                return;
            }
            final Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case ACCOUNT_ADD: {
                            ExpandingAccountTableModel.this.addNode(a);
                            break;
                        }
                        case ACCOUNT_REMOVE: {
                            ExpandingAccountTableModel.this.removeNode(a);
                            break;
                        }
                        case ACCOUNT_MODIFY: 
                        case ACCOUNT_VISIBILITY_CHANGE: 
                        case COMMODITY_HISTORY_ADD: 
                        case COMMODITY_HISTORY_REMOVE: {
                            ExpandingAccountTableModel.this.fireNodeChanged();
                            break;
                        }
                        case FILE_LOAD_SUCCESS: 
                        case FILE_NEW_SUCCESS: {
                            logger.warning("Should not have received a load and new file notification");
                            break;
                        }
                    }
                }
            });
        }
    }
}

