/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.account.AbstractAccountEnabledTreeCellRenderer;
import jgnash.ui.account.AccountFilterModel;
import jgnash.ui.account.AccountTreeCellRenderer;
import jgnash.ui.account.AccountTreeModel;

public class AccountListTreePane
extends JScrollPane
implements TreeSelectionListener,
MessageListener,
AccountFilterModel {
    private static final String HIDDEN_VISIBLE = "HiddenVisible";
    private static final String EXPENSE_VISIBLE = "ExpenseVisible";
    private static final String INCOME_VISIBLE = "IncomeVisible";
    private static final String ACCOUNT_VISIBLE = "AccountVisible";
    protected JTree tree;
    private transient AccountTreeCellRenderer renderer;
    private AccountTreeModel model = new AccountTreeModel();
    private Account selectedAccount;
    private boolean rootVisible;
    private transient Preferences p;

    public AccountListTreePane(String identifier, boolean rootVisible) {
        this.rootVisible = rootVisible;
        this.p = Preferences.userRoot().node("/jgnash/ui/AccountListPane/" + identifier);
        this.buildUI();
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.COMMODITY, MessageChannel.SYSTEM);
        this.renderer = new AccountTreeCellRenderer(this.tree.getCellRenderer());
        this.setAccountTreeCellRenderer(this.renderer);
    }

    private static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    JComponent createModelAndView() {
        this.model = new AccountTreeModel();
        this.tree = new JTree(this.model);
        this.tree.setBorder(null);
        this.tree.setEditable(false);
        this.tree.setRootVisible(this.rootVisible);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        return this.tree;
    }

    public void disablePlaceHolders() {
        this.renderer.setPlaceHoldersEnabled(false);
    }

    void disableAccount(Account account) {
        this.renderer.addDisabledAccount(account);
    }

    private void setAccountTreeCellRenderer(AbstractAccountEnabledTreeCellRenderer renderer) {
        this.tree.setSelectionModel(renderer.getSelectionModel());
        this.tree.setCellRenderer(renderer);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o != null) {
            this.selectedAccount = (Account)((DefaultMutableTreeNode)o).getUserObject();
        }
    }

    void _expand() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void setSelectedAccount(Account account) {
        DefaultMutableTreeNode node;
        if (account != null && (node = this.model.findAccountNode(account)) != null) {
            TreePath path = new TreePath(this.model.getPathToRoot(node));
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    void scrollToTop() {
        RootAccount rootAccount = EngineFactory.getEngine("default").getRootAccount();
        if (rootAccount != null) {
            this.tree.scrollPathToVisible(new TreePath(rootAccount));
        }
    }

    private void buildUI() {
        this.setMinimumSize(new Dimension(100, 100));
        this.setViewportView(this.createModelAndView());
        this.model.setAccountVisible(this.p.getBoolean(ACCOUNT_VISIBLE, true));
        this.model.setExpenseVisible(this.p.getBoolean(EXPENSE_VISIBLE, true));
        this.model.setHiddenVisible(this.p.getBoolean(HIDDEN_VISIBLE, true));
        this.model.setIncomeVisible(this.p.getBoolean(INCOME_VISIBLE, true));
        this.refresh();
        this._expand();
    }

    @Override
    public boolean isAccountVisible() {
        return this.model.getAccountVisible();
    }

    @Override
    public void setAccountVisible(boolean visible) {
        this.p.putBoolean(ACCOUNT_VISIBLE, visible);
        this.model.setAccountVisible(visible);
        this.expand();
    }

    @Override
    public boolean isIncomeVisible() {
        return this.model.getIncomeVisible();
    }

    @Override
    public void setIncomeVisible(boolean visible) {
        this.p.putBoolean(INCOME_VISIBLE, visible);
        this.model.setIncomeVisible(visible);
        this.expand();
    }

    @Override
    public boolean isExpenseVisible() {
        return this.model.getExpenseVisible();
    }

    @Override
    public void setExpenseVisible(boolean visible) {
        this.p.putBoolean(EXPENSE_VISIBLE, visible);
        this.model.setExpenseVisible(visible);
        this.expand();
    }

    @Override
    public boolean isHiddenVisible() {
        return this.model.getHiddenVisible();
    }

    @Override
    public void setHiddenVisible(boolean visible) {
        this.p.putBoolean(HIDDEN_VISIBLE, visible);
        this.model.setHiddenVisible(visible);
        this.expand();
    }

    private synchronized void refresh() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AccountListTreePane.getEngine() != null) {
                    AccountListTreePane.this.model.reload();
                    AccountListTreePane.this.scrollToTop();
                }
            }
        });
    }

    public synchronized void expand() {
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountListTreePane.this._expand();
                }
            });
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AccountListTreePane.this._expand();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                System.err.println(e);
            }
        }
    }

    public Account getSelectedAccount() {
        return this.selectedAccount;
    }

    private void close() {
        this.selectedAccount = null;
        this.model.setRoot(null);
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountListTreePane.this.close();
                }
            });
            return;
        }
        if (EngineFactory.getEngine("default") == null) {
            return;
        }
        final Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case ACCOUNT_ADD: {
                        AccountListTreePane.this.model.reload();
                        AccountListTreePane.this.expand();
                        break;
                    }
                    case ACCOUNT_MODIFY: {
                        AccountListTreePane.this.model.reload();
                        AccountListTreePane.this.expand();
                        break;
                    }
                    case ACCOUNT_REMOVE: {
                        if (a != null && AccountListTreePane.this.selectedAccount != null) {
                            if (AccountListTreePane.this.selectedAccount.equals(a)) {
                                AccountListTreePane.this.selectedAccount = null;
                            }
                            AccountListTreePane.this.model.removeAccount(a);
                            break;
                        }
                        AccountListTreePane.this.model.reload();
                        AccountListTreePane.this.expand();
                        break;
                    }
                    case ACCOUNT_VISIBILITY_CHANGE: {
                        AccountListTreePane.this.model.reload();
                        AccountListTreePane.this.expand();
                        break;
                    }
                    case FILE_LOAD_SUCCESS: 
                    case FILE_NEW_SUCCESS: {
                        AccountListTreePane.this.refresh();
                        AccountListTreePane.this.expand();
                        break;
                    }
                }
            }
        });
    }
}

