/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.SecurityNode;
import jgnash.ui.UIApplication;
import jgnash.ui.account.AccountPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

class AccountDialog
extends JDialog
implements ActionListener {
    private transient Resource rb = Resource.get();
    private boolean returnStatus = false;
    private AccountPanel accountPanel = null;
    private JButton cancelButton;
    private JButton okButton;
    private JButton helpButton;

    public AccountDialog() {
        super((Frame)UIApplication.getFrame(), true);
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.accountPanel = new AccountPanel();
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.helpButton = new JButton(this.rb.getString("Button.Help"));
        UIApplication.enableHelpOnButton(this.helpButton, "NewAccount");
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendRow("f:p:g");
        builder.append((Component)this.accountPanel);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildHelpOKCancelBar((JButton)this.helpButton, (JButton)this.okButton, (JButton)this.cancelButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    boolean returnStatus() {
        return this.returnStatus;
    }

    public Account getParentAccount() {
        return this.accountPanel.getParentAccount();
    }

    public void setParentAccount(Account account) {
        this.accountPanel.setParentAccount(account);
    }

    public String getAccountName() {
        return this.accountPanel.getAccountName();
    }

    public void setAccountName(String name) {
        this.accountPanel.setAccountName(name);
    }

    public String getAccountDescription() {
        return this.accountPanel.getAccountDescription();
    }

    public void setAccountDescription(String desc) {
        this.accountPanel.setAccountDescription(desc);
    }

    public String getAccountNotes() {
        return this.accountPanel.getAccountNotes();
    }

    public void setAccountLocked(boolean b) {
        this.accountPanel.setAccountLocked(b);
    }

    public boolean isAccountLocked() {
        return this.accountPanel.isAccountLocked();
    }

    public void setAccountPlaceholder(boolean b) {
        this.accountPanel.setPlaceholder(b);
    }

    public boolean isAccountPlaceholder() {
        return this.accountPanel.isPlaceholder();
    }

    public void setPlaceholderEnabled(boolean enabled) {
        this.accountPanel.placeholderCheckBox.setEnabled(enabled);
    }

    public void setAccountNotes(String notes) {
        this.accountPanel.setAccountNotes(notes);
    }

    public CurrencyNode getCurrency() {
        return this.accountPanel.getAccountCurrency();
    }

    public void setCurrency(CurrencyNode currency) {
        this.accountPanel.setAccountCurrency(currency);
    }

    public AccountType getAccountType() {
        return this.accountPanel.getAccountType();
    }

    public void setAccountType(AccountType type) {
        this.accountPanel.setAccountType(type);
    }

    public void setAccountCode(String id) {
        this.accountPanel.setAccountCode(id);
    }

    public String getAccountCode() {
        return this.accountPanel.getAccountCode();
    }

    public void setBankId(String id) {
        this.accountPanel.setBankId(id);
    }

    public String getBankId() {
        return this.accountPanel.getBankId();
    }

    public boolean isAccountVisible() {
        return !this.accountPanel.isAccountHidden();
    }

    public void setAccountVisible(boolean visible) {
        this.accountPanel.setAccountHidden(!visible);
    }

    public boolean isExcludedFromBudget() {
        return this.accountPanel.isExcludedFromBudget();
    }

    public void setExcludedFromBudget(boolean excludedFromBudget) {
        this.accountPanel.setExcludedFromBudget(excludedFromBudget);
    }

    public Set<SecurityNode> getAccountSecurities() {
        return this.accountPanel.getAccountSecurities();
    }

    public void setAccountSecurities(Set<SecurityNode> list) {
        this.accountPanel.setAccountSecurities(list);
    }

    void disableAccountType(AccountType t) {
        this.accountPanel.disableAccountType(t);
    }

    void disableAccountCurrency() {
        this.accountPanel.disableAccountCurrency();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.returnStatus = true;
            this.close();
        } else if (e.getSource() == this.cancelButton) {
            this.returnStatus = false;
            this.close();
        }
    }
}

