/*
 * Decompiled with CFR 0.152.
 */
package jgnash.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.plugin.Plugin;

public final class PluginFactory {
    private String pluginDirectory = this.getPluginDirectory();
    private static final String PLUGIN_DIRECTORY_NAME = "plugins";
    private static final BigDecimal INTERFACE_VERSION = new BigDecimal("2.5");
    private static final Logger logger = Logger.getLogger(PluginFactory.class.getName());
    private static PluginFactory factory;
    private static List<Plugin> plugins;
    private static boolean pluginsStarted;
    private static boolean pluginsLoaded;

    private PluginFactory() {
    }

    public static PluginFactory get() {
        return factory;
    }

    public static List<Plugin> getPlugins() {
        return Collections.unmodifiableList(plugins);
    }

    private synchronized String getPluginDirectory() {
        if (this.pluginDirectory == null) {
            this.pluginDirectory = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                this.pluginDirectory = URLDecoder.decode(this.pluginDirectory, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            this.pluginDirectory = new File(this.pluginDirectory).getParent();
            this.pluginDirectory = this.pluginDirectory + File.separator + PLUGIN_DIRECTORY_NAME + File.separator;
            logger.log(Level.INFO, "Plugin path: {0}", this.pluginDirectory);
        }
        return this.pluginDirectory;
    }

    public static void startPlugins() {
        if (!pluginsStarted) {
            for (Plugin plugin : plugins) {
                plugin.start();
            }
            pluginsStarted = true;
        }
    }

    public static void stopPlugins() {
        if (pluginsStarted) {
            for (Plugin plugin : plugins) {
                plugin.stop();
            }
            pluginsStarted = false;
        }
    }

    public void loadPlugins() {
        if (!pluginsLoaded) {
            String[] paths = this.getPluginPaths();
            if (paths != null) {
                for (String plugin : paths) {
                    try {
                        Plugin p = this.loadPlugin(plugin);
                        if (p == null) continue;
                        plugins.add(p);
                    }
                    catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                logger.info("Did not find any plugins");
            }
            pluginsLoaded = true;
        }
    }

    private String[] getPluginPaths() {
        File dir = new File(this.getPluginDirectory());
        return dir.list(new PluginFilenameFilter());
    }

    private Plugin loadPlugin(String jarFileName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        JarURLClassLoader classLoader = new JarURLClassLoader(new URL("file:///" + this.getPluginDirectory() + jarFileName));
        Plugin plugin = null;
        String pluginActivator = classLoader.getActivator();
        if (pluginActivator != null) {
            Object object = classLoader.loadClass(pluginActivator).newInstance();
            if (object instanceof Plugin) {
                plugin = (Plugin)object;
            }
        } else {
            logger.log(Level.SEVERE, "''{0}'' Plugin Interface was not implemented", jarFileName);
        }
        return plugin;
    }

    static {
        pluginsStarted = false;
        pluginsLoaded = false;
        factory = new PluginFactory();
        plugins = new ArrayList<Plugin>();
    }

    private static class PluginFilenameFilter
    implements FilenameFilter {
        private PluginFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }

    private static class JarURLClassLoader
    extends URLClassLoader {
        private static final String PLUGIN_ACTIVATOR = "Plugin-Activator";
        private static final String PLUGIN_VERSION = "Plugin-Version";

        public JarURLClassLoader(URL url) {
            super(new URL[]{url});
        }

        public String getActivator() throws IOException {
            String activator = null;
            URL u = new URL("jar", "", this.getURLs()[0] + "!/");
            JarURLConnection uc = (JarURLConnection)u.openConnection();
            Attributes attr = uc.getMainAttributes();
            if (attr != null) {
                BigDecimal version = null;
                try {
                    String value = attr.getValue(PLUGIN_VERSION);
                    if (value != null) {
                        version = new BigDecimal(attr.getValue(PLUGIN_VERSION));
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                if (version != null && INTERFACE_VERSION.compareTo(version) >= 0) {
                    activator = attr.getValue(PLUGIN_ACTIVATOR);
                }
            }
            return activator;
        }
    }
}

