/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net.currency;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.SwingWorker;
import jgnash.engine.CurrencyNode;
import jgnash.engine.EngineFactory;
import jgnash.net.currency.YahooParser;
import jgnash.ui.UIApplication;

public class CurrencyUpdateFactory {
    private static final String UPDATE_ON_STARTUP = "updateOnStartup";

    private CurrencyUpdateFactory() {
    }

    public static void setUpdateOnStartup(boolean update) {
        Preferences pref = Preferences.userNodeForPackage(CurrencyUpdateFactory.class);
        pref.putBoolean(UPDATE_ON_STARTUP, update);
    }

    public static boolean getUpdateOnStartup() {
        Preferences pref = Preferences.userNodeForPackage(CurrencyUpdateFactory.class);
        return pref.getBoolean(UPDATE_ON_STARTUP, false);
    }

    public static ExchangeRateUpdateWorker getUpdateWorker() {
        return new ExchangeRateUpdateWorker();
    }

    public static class ExchangeRateUpdateWorker
    extends SwingWorker<Void, Void> {
        @Override
        protected Void doInBackground() throws Exception {
            if (UIApplication.getFrame() != null) {
                UIApplication.getFrame().setNetworkBusy(true);
            }
            ArrayList<CurrencyNode> list = new ArrayList<CurrencyNode>(EngineFactory.getEngine("default").getCurrencies());
            int lengthOfTask = (list.size() * list.size() - list.size()) / 2;
            int count = 0;
            for (CurrencyNode i : list) {
                String source = i.getSymbol();
                for (CurrencyNode j : list) {
                    BigDecimal conv;
                    String target = j.getSymbol();
                    if (source.equals(target) || source.compareToIgnoreCase(target) <= 0 || this.isCancelled()) continue;
                    YahooParser parser = new YahooParser();
                    if (parser.parse(source, target) && (conv = parser.getConversion()) != null && conv.compareTo(BigDecimal.ZERO) != 0) {
                        EngineFactory.getEngine("default").setExchangeRate(i, j, conv);
                    }
                    this.setProgress((int)((float)(++count) / (float)lengthOfTask * 100.0f));
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (UIApplication.getFrame() != null) {
                UIApplication.getFrame().setNetworkBusy(false);
            }
        }
    }
}

