/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FileMagic {
    private static final Pattern COLON_DELIMITER_PATTERN = Pattern.compile(":");
    public static final String UTF_8 = "UTF-8";
    public static final byte[] BINARY_XSTREAM_HEADER = new byte[]{10, -127, 0, 13, 111, 98, 106, 101, 99, 116, 45, 115, 116, 114, 101, 97, 109, 11, -127, 10};

    public static FileType magic(File file) {
        if (FileMagic.isdb4o(file)) {
            return FileType.db4o;
        }
        if (FileMagic.isValidjGnash1File(file)) {
            return FileType.jGnash1XML;
        }
        if (FileMagic.isValidjGnash2File(file)) {
            return FileType.jGnash2XML;
        }
        if (FileMagic.isOfxV1(file)) {
            return FileType.OfxV1;
        }
        if (FileMagic.isOfxV2(file)) {
            return FileType.OfxV2;
        }
        if (FileMagic.isBinaryXStreamFile(file)) {
            return FileType.BinaryXStream;
        }
        return FileType.unknown;
    }

    public static String getOfxV1Encoding(File file) {
        String encoding = null;
        String charset = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        String[] splits;
                        if (line.startsWith("ENCODING:")) {
                            splits = COLON_DELIMITER_PATTERN.split(line);
                            if (splits.length == 2) {
                                encoding = splits[1];
                            }
                        } else if (line.startsWith("CHARSET:") && (splits = COLON_DELIMITER_PATTERN.split(line)).length == 2) {
                            charset = splits[1];
                        }
                        if (encoding != null && charset != null) {
                            break;
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
        if (encoding != null && charset != null) {
            if (encoding.equals(UTF_8) && charset.equals("CSUNICODE")) {
                return "ISO-8859-1";
            }
            if (encoding.equals(UTF_8)) {
                return UTF_8;
            }
            if (encoding.equals("USASCII") && charset.equals("1252")) {
                return "windows-1252";
            }
            if (encoding.equals("USASCII") && charset.contains("8859-1")) {
                return "ISO-8859-1";
            }
            if (encoding.equals("USASCII") && charset.equals("NONE")) {
                return "windows-1252";
            }
        }
        return "windows-1252";
    }

    public static boolean isOfxV1(File file) {
        boolean result = false;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        if (line.startsWith("OFXHEADER:")) {
                            result = true;
                        }
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOfxV2(File file) {
        boolean result = false;
        if (!file.exists()) return result;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.startsWith("<?")) {
                    if (line.startsWith("<?OFX") && line.contains("OFXHEADER=\"200\"")) {
                        result = true;
                        return result;
                    }
                } else if (line.length() > 0) {
                    if (!line.startsWith("<OFX>")) return result;
                    result = true;
                    return result;
                }
                line = reader.readLine();
            }
            return result;
        }
        catch (IOException e) {
            Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, e.toString(), e);
        }
        return result;
    }

    public static boolean isBinaryXStreamFile(File file) {
        boolean result = false;
        if (file.exists()) {
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                if (raf.length() > 0L) {
                    byte[] header = new byte[20];
                    raf.readFully(header);
                    result = Arrays.equals(header, BINARY_XSTREAM_HEADER);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    static boolean isdb4o(File file) {
        boolean result = false;
        if (file.exists()) {
            try (RandomAccessFile di = new RandomAccessFile(file, "r");){
                byte[] header = new byte[4];
                if (di.length() > 0L) {
                    di.readFully(header);
                    if (new String(header).equals("db4o")) {
                        result = true;
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static boolean isValidjGnash1File(File file) {
        return FileMagic.isValidjGnashX(file, "1");
    }

    private static boolean isValidjGnash2File(File file) {
        return FileMagic.isValidjGnashX(file, "2");
    }

    private static boolean isValidjGnashX(File file, String majorVersion) {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return false;
        }
        return FileMagic.getjGnashXMLVersion(file).startsWith(majorVersion);
    }

    public static String getjGnashXMLVersion(File file) {
        String version = "";
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader reader = inputFactory.createXMLStreamReader(input, UTF_8);
            block15: while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 3: {
                        String name = reader.getPITarget();
                        String data = reader.getPIData();
                        if (name.equals("fileVersion")) {
                            version = data;
                            break block15;
                        }
                    }
                    default: {
                        continue block15;
                    }
                }
            }
            reader.close();
        }
        catch (IOException e) {
            Logger.getLogger(FileMagic.class.getName()).log(Level.SEVERE, e.toString(), e);
        }
        catch (XMLStreamException e) {
            Logger.getLogger(FileMagic.class.getName()).log(Level.INFO, "{0} was not a valid jGnash XML file", file.getAbsolutePath());
        }
        return version;
    }

    private FileMagic() {
    }

    public static enum FileType {
        db4o,
        BinaryXStream,
        OfxV1,
        OfxV2,
        jGnash1XML,
        jGnash2XML,
        unknown;

    }
}

