/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.awt.Rectangle;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class EncodeDecode {
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile(",");
    private static final Pattern LOCALE_DELIMITER_PATTERN = Pattern.compile("\\x2E");

    private EncodeDecode() {
    }

    public static String encodeRectangle(Rectangle bounds) {
        StringBuilder buf = new StringBuilder();
        buf.append(bounds.x);
        buf.append(',');
        buf.append(bounds.y);
        buf.append(',');
        buf.append(bounds.width);
        buf.append(',');
        buf.append(bounds.height);
        return buf.toString();
    }

    public static Rectangle decodeRectangle(String bounds) {
        if (bounds == null) {
            return null;
        }
        Rectangle rectangle = null;
        String[] array = COMMA_DELIMITER_PATTERN.split(bounds);
        if (array.length == 4) {
            try {
                rectangle = new Rectangle();
                rectangle.x = Integer.parseInt(array[0]);
                rectangle.y = Integer.parseInt(array[1]);
                rectangle.width = Integer.parseInt(array[2]);
                rectangle.height = Integer.parseInt(array[3]);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(EncodeDecode.class.getName()).log(Level.SEVERE, null, nfe);
                rectangle = null;
            }
        }
        return rectangle;
    }

    public static String encodeLocale(Locale locale) {
        StringBuilder buf = new StringBuilder();
        buf.append(locale.getLanguage());
        if (!locale.getCountry().equals("")) {
            buf.append('.');
            buf.append(locale.getCountry());
            if (!locale.getVariant().equals("")) {
                buf.append('.');
                buf.append(locale.getVariant());
            }
        }
        return buf.toString();
    }

    public static Locale decodeLocale(String locale) {
        if (locale == null || locale.equals("") || locale.equals("null")) {
            return Locale.getDefault();
        }
        if (locale.indexOf(46) == -1) {
            return new Locale(locale);
        }
        String[] array = LOCALE_DELIMITER_PATTERN.split(locale);
        if (array.length == 3) {
            return new Locale(array[0], array[1], array[2]);
        }
        if (array.length == 2) {
            return new Locale(array[0], array[1]);
        }
        return Locale.getDefault();
    }

    public static String encodeBooleanArray(boolean[] array) {
        StringBuilder buf = new StringBuilder();
        if (array != null) {
            for (boolean anArray : array) {
                if (anArray) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            return buf.toString();
        }
        return null;
    }

    public static boolean[] decodeBooleanArray(String array) {
        int len;
        if (array != null && (len = array.length()) > 0) {
            boolean[] b = new boolean[len];
            for (int i = 0; i < len; ++i) {
                if (array.charAt(i) != '1') continue;
                b[i] = true;
            }
            return b;
        }
        return new boolean[0];
    }
}

