/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.KXml2Driver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.ExchangeRate;
import jgnash.engine.RootAccount;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.budget.Budget;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.xstream.AbstractXStreamContainer;
import jgnash.engine.xstream.StoredObjectReflectionProvider;
import jgnash.util.FileMagic;
import jgnash.util.FileUtils;

public class XMLContainer
extends AbstractXStreamContainer {
    protected XMLContainer(File file) {
        super(file);
    }

    @Override
    void commit() {
        this.writeXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeXML() {
        this.readWriteLock.readLock().lock();
        try {
            this.releaseFileLock();
            XMLContainer.writeXML(this.objects, this.file);
        }
        finally {
            this.acquireFileLock();
            this.readWriteLock.readLock().unlock();
        }
    }

    public static synchronized void writeXML(Collection<StoredObject> objects, File file) {
        Logger logger = Logger.getLogger(XMLContainer.class.getName());
        if (file.exists()) {
            File backup = new File(file.getAbsolutePath() + ".backup");
            if (backup.exists() && !backup.delete()) {
                logger.log(Level.WARNING, "Was not able to delete the old backup file: {0}", backup.getAbsolutePath());
            }
            FileUtils.copyFile(file, backup);
        }
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        list.addAll(XMLContainer.query(objects, Budget.class));
        list.addAll(XMLContainer.query(objects, Config.class));
        list.addAll(XMLContainer.query(objects, CommodityNode.class));
        list.addAll(XMLContainer.query(objects, ExchangeRate.class));
        list.addAll(XMLContainer.query(objects, RootAccount.class));
        list.addAll(XMLContainer.query(objects, Reminder.class));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StoredObject o = (StoredObject)i.next();
            if (!o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(list, new StoredObjectComparator());
        logger.info("Writing XML file");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<?fileVersion 2.21?>\n");
            XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new KXml2Driver()));
            try (ObjectOutputStream out = xstream.createObjectOutputStream((HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));){
                out.writeObject(list);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        logger.info("Writing XML file complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readXML() {
        String encoding = System.getProperty("file.encoding");
        String version = FileMagic.getjGnashXMLVersion(this.file);
        if (Float.parseFloat(version) >= 2.01f) {
            encoding = "UTF-8";
        }
        try (FileInputStream fis = new FileInputStream(this.file);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));){
            this.readWriteLock.writeLock().lock();
            XStream xstream = XMLContainer.configureXStream(new XStream((ReflectionProvider)new StoredObjectReflectionProvider(this.objects), (HierarchicalStreamDriver)new KXml2Driver()));
            try (ObjectInputStream in = xstream.createObjectInputStream((Reader)reader);
                 FileLock readLock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);){
                if (readLock != null) {
                    in.readObject();
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.acquireFileLock();
            this.readWriteLock.writeLock().unlock();
        }
    }
}

