/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.binary.BinaryStreamDriver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.ExchangeRate;
import jgnash.engine.RootAccount;
import jgnash.engine.StoredObject;
import jgnash.engine.StoredObjectComparator;
import jgnash.engine.budget.Budget;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.xstream.AbstractXStreamContainer;
import jgnash.engine.xstream.StoredObjectReflectionProvider;
import jgnash.util.FileUtils;

public class BinaryContainer
extends AbstractXStreamContainer {
    protected BinaryContainer(File file) {
        super(file);
    }

    @Override
    void commit() {
        this.writeBinary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeBinary() {
        this.readWriteLock.readLock().lock();
        try {
            this.releaseFileLock();
            BinaryContainer.writeBinary(this.objects, this.file);
        }
        finally {
            this.acquireFileLock();
            this.readWriteLock.readLock().unlock();
        }
    }

    public static synchronized void writeBinary(Collection<StoredObject> objects, File file) {
        Logger logger = Logger.getLogger(BinaryContainer.class.getName());
        if (file.exists()) {
            File backup = new File(file.getAbsolutePath() + ".backup");
            if (backup.exists() && !backup.delete()) {
                logger.log(Level.WARNING, "Was not able to delete the old backup file: {0}", backup.getAbsolutePath());
            }
            FileUtils.copyFile(file, backup);
        }
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        list.addAll(BinaryContainer.query(objects, Budget.class));
        list.addAll(BinaryContainer.query(objects, Config.class));
        list.addAll(BinaryContainer.query(objects, CommodityNode.class));
        list.addAll(BinaryContainer.query(objects, ExchangeRate.class));
        list.addAll(BinaryContainer.query(objects, RootAccount.class));
        list.addAll(BinaryContainer.query(objects, Reminder.class));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StoredObject o = (StoredObject)i.next();
            if (!o.isMarkedForRemoval()) continue;
            i.remove();
        }
        Collections.sort(list, new StoredObjectComparator());
        logger.info("Writing Binary file");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            XStream xstream = BinaryContainer.configureXStream(new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new BinaryStreamDriver()));
            try (ObjectOutputStream out = xstream.createObjectOutputStream((OutputStream)os);){
                out.writeObject(list);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        logger.info("Writing Binary file complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBinary() {
        try (FileInputStream fis = new FileInputStream(this.file);
             BufferedInputStream inputStream = new BufferedInputStream(fis);){
            this.readWriteLock.writeLock().lock();
            XStream xstream = BinaryContainer.configureXStream(new XStream((ReflectionProvider)new StoredObjectReflectionProvider(this.objects), (HierarchicalStreamDriver)new BinaryStreamDriver()));
            try (ObjectInputStream in = xstream.createObjectInputStream((InputStream)inputStream);
                 FileLock readLock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);){
                if (readLock != null) {
                    in.readObject();
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.getLogger(BinaryContainer.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.acquireFileLock();
            this.readWriteLock.writeLock().unlock();
        }
    }
}

