/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.MathConstants;
import jgnash.engine.SecurityNode;
import jgnash.engine.TransactionType;

public class TransactionEntrySellX
extends AbstractInvestmentTransactionEntry {
    private static final long serialVersionUID = 1L;

    @Deprecated
    public TransactionEntrySellX() {
    }

    protected TransactionEntrySellX(Account account, Account investmentAccount, SecurityNode securityNode, BigDecimal price, BigDecimal quantity, BigDecimal exchangeRate) {
        assert (investmentAccount.memberOf(AccountGroup.INVEST));
        assert (exchangeRate != null && exchangeRate.signum() == 1);
        this.setSecurityNode(securityNode);
        this.setPrice(price);
        this.setQuantity(quantity);
        this.setCreditAccount(investmentAccount);
        this.setDebitAccount(account);
        if (investmentAccount.equals(account)) {
            BigDecimal amount = price.multiply(quantity).setScale((int)investmentAccount.getCurrencyNode().getScale(), MathConstants.roundingMode);
            this.setCreditAmount(amount);
            this.setDebitAmount(amount);
        } else {
            this.setCreditAmount(BigDecimal.ZERO);
            byte scale = this.getCreditAccount().getCurrencyNode().getScale();
            if (account.getCurrencyNode().equals(investmentAccount.getCurrencyNode())) {
                this.setDebitAmount(price.multiply(quantity).setScale((int)scale, MathConstants.roundingMode));
            } else {
                this.setDebitAmount(price.multiply(quantity).multiply(exchangeRate).setScale((int)scale, MathConstants.roundingMode));
            }
        }
    }

    @Override
    public BigDecimal getSignedQuantity() {
        return this.getQuantity().negate();
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.SELLSHARE;
    }
}

