/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.DataStore;
import jgnash.engine.db4o.Db4oDataStore;
import jgnash.engine.xstream.BinaryXStreamDataStore;
import jgnash.engine.xstream.XMLDataStore;
import jgnash.util.Resource;

public enum DataStoreType {
    DB4O(Resource.get().getString("DataStoreType.Db4o"), true, Db4oDataStore.class),
    BINARY_XSTREAM(Resource.get().getString("DataStoreType.Bxds"), true, BinaryXStreamDataStore.class),
    XML(Resource.get().getString("DataStoreType.XML"), false, XMLDataStore.class);

    final transient boolean supportsRemote;
    private final transient String description;
    private final transient Class<? extends DataStore> dataStore;

    private DataStoreType(String description, boolean supportsRemote, Class<? extends DataStore> dataStore) {
        this.description = description;
        this.supportsRemote = supportsRemote;
        this.dataStore = dataStore;
    }

    public DataStore getDataStore() {
        try {
            Constructor<? extends DataStore> storeConst = this.dataStore.getDeclaredConstructor(new Class[0]);
            return storeConst.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(DataStoreType.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String toString() {
        return this.description;
    }
}

