/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import jgnash.engine.Account;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.util.DateUtils;

public class AccountProxy {
    final Account account;

    AccountProxy(Account account) {
        this.account = account;
    }

    public BigDecimal getBalance() {
        int count = this.account.getTransactionCount();
        if (count > 0) {
            return this.getBalanceAt(count - 1);
        }
        return BigDecimal.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalanceAt(int index) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal balance = BigDecimal.ZERO;
            for (int i = 0; i <= index; ++i) {
                balance = balance.add(this.account.transactions.get(i).getAmount(this.account));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date start, Date end) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal balance = BigDecimal.ZERO;
            int count = this.account.transactions.size();
            for (int i = 0; i < count; ++i) {
                Transaction t = this.account.transactions.get(i);
                Date d = t.getDate();
                if (!DateUtils.after(d, start) || !DateUtils.before(d, end)) continue;
                balance = balance.add(t.getAmount(this.account));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date date) {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal balance = BigDecimal.ZERO;
            if (!this.account.transactions.isEmpty()) {
                balance = this.getBalance(this.account.transactions.get(0).getDate(), date);
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    public BigDecimal getCashBalance() {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getCashBalance(Date end) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getCashBalance(Date start, Date end) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getMarketPrice(SecurityNode node, Date date) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getMarketValue() {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getMarketValue(Date date) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getMarketValue(Date start, Date end) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getReconciledBalance() {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            BigDecimal balance = BigDecimal.ZERO;
            for (Transaction t : this.account.transactions) {
                if (t.getReconciled(this.account) != ReconciledState.RECONCILED) continue;
                balance = balance.add(t.getAmount(this.account));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getOpeningBalanceForReconcile() {
        Lock l = this.account.getTransactionLock().readLock();
        l.lock();
        try {
            Date date = this.account.getFirstUnreconciledTransactionDate();
            BigDecimal balance = BigDecimal.ZERO;
            for (int i = 0; i < this.account.transactions.size(); ++i) {
                if (!this.account.transactions.get(i).getDate().equals(date)) continue;
                if (i <= 0) break;
                balance = this.getBalanceAt(i - 1);
                break;
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }
}

