/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.Db4oIOException;
import com.db4o.ObjectSet;
import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.TransactionAware;
import com.db4o.config.ConfigScope;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.Comparable4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.EventDispatcher;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.FirstClassHandler;
import com.db4o.internal.IllegalComparisonException;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.TranslatedFieldMetadata;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.UnicodeStringIO;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import java.io.IOException;

public class ClassMetadata
extends PersistentBase
implements IndexableTypeHandler,
FirstClassHandler,
StoredClass {
    public ClassMetadata i_ancestor;
    private Config4Class i_config;
    public int _metaClassID;
    public FieldMetadata[] i_fields;
    private final ClassIndexStrategy _index;
    protected String i_name;
    private final ObjectContainerBase _container;
    byte[] i_nameBytes;
    private Buffer i_reader;
    private boolean _classIndexed;
    private ReflectClass _reflector;
    private boolean _isEnum;
    private EventDispatcher _eventDispatcher;
    private boolean _internal;
    private boolean _unversioned;
    private int i_lastID;
    private TernaryBool _canUpdateFast = TernaryBool.UNSPECIFIED;
    private ReflectClass i_compareTo;

    public final ObjectContainerBase stream() {
        return this._container;
    }

    public final boolean canUpdateFast() {
        return this._canUpdateFast.booleanValue(this.checkCanUpdateFast());
    }

    private final boolean checkCanUpdateFast() {
        if (this.i_ancestor != null && !this.i_ancestor.canUpdateFast()) {
            return false;
        }
        if (this.i_config != null && this.i_config.cascadeOnDelete() == TernaryBool.YES) {
            return false;
        }
        for (int i = 0; i < this.i_fields.length; ++i) {
            if (!this.i_fields[i].hasIndex()) continue;
            return false;
        }
        return true;
    }

    boolean isInternal() {
        return this._internal;
    }

    private ClassIndexStrategy createIndexStrategy() {
        return new BTreeClassIndexStrategy(this);
    }

    ClassMetadata(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        this._container = objectContainerBase;
        this._reflector = reflectClass;
        this._index = this.createIndexStrategy();
        this._classIndexed = true;
    }

    void activateFields(Transaction transaction, Object object, int n) {
        if (this.objectCanActivate(transaction, object)) {
            this.activateFieldsLoop(transaction, object, n);
        }
    }

    private final void activateFieldsLoop(Transaction transaction, Object object, int n) {
        for (int i = 0; i < this.i_fields.length; ++i) {
            this.i_fields[i].cascadeActivation(transaction, object, n, true);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.activateFieldsLoop(transaction, object, n);
        }
    }

    public final void addFieldIndices(StatefulBuffer statefulBuffer, Slot slot) {
        if (this.hasClassIndex() || this.hasVirtualAttributes()) {
            ObjectHeader objectHeader = new ObjectHeader(this._container, this, statefulBuffer);
            objectHeader._marshallerFamily._object.addFieldIndices(this, objectHeader._headerAttributes, statefulBuffer, slot);
        }
    }

    void addMembers(ObjectContainerBase objectContainerBase) {
        this.bitTrue(6);
        if (this.installTranslator(objectContainerBase)) {
            return;
        }
        if (objectContainerBase.detectSchemaChanges()) {
            DiagnosticProcessor diagnosticProcessor;
            boolean bl = this.isDirty();
            Collection4 collection4 = new Collection4();
            if (null != this.i_fields) {
                collection4.addAll(this.i_fields);
                if (this.i_fields.length == 1 && this.i_fields[0] instanceof TranslatedFieldMetadata) {
                    this.setStateOK();
                    return;
                }
            }
            if (this.generateVersionNumbers() && !this.hasVersionField()) {
                collection4.add(objectContainerBase.versionIndex());
                bl = true;
            }
            if (this.generateUUIDs() && !this.hasUUIDField()) {
                collection4.add(objectContainerBase.uUIDIndex());
                bl = true;
            }
            if (bl = this.collectReflectFields(objectContainerBase, collection4) | bl) {
                this._container.setDirtyInSystemTransaction(this);
                this.i_fields = new FieldMetadata[collection4.size()];
                collection4.toArray(this.i_fields);
                for (int i = 0; i < this.i_fields.length; ++i) {
                    this.i_fields[i].setArrayPosition(i);
                }
            } else if (collection4.size() == 0) {
                this.i_fields = new FieldMetadata[0];
            }
            if ((diagnosticProcessor = this._container._handlers._diagnosticProcessor).enabled()) {
                diagnosticProcessor.checkClassHasFields(this);
            }
        } else if (this.i_fields == null) {
            this.i_fields = new FieldMetadata[0];
        }
        this._container.callbacks().classOnRegistered(this);
        this.setStateOK();
    }

    private boolean collectReflectFields(ObjectContainerBase objectContainerBase, Collection4 collection4) {
        boolean bl = false;
        ReflectField[] reflectFieldArray = this.reflectFields();
        for (int i = 0; i < reflectFieldArray.length; ++i) {
            ClassMetadata classMetadata;
            if (!this.storeField(reflectFieldArray[i]) || (classMetadata = objectContainerBase._handlers.classMetadataForClass(objectContainerBase, reflectFieldArray[i].getFieldType())) == null) continue;
            TypeHandler4 typeHandler4 = classMetadata.typeHandler();
            FieldMetadata fieldMetadata = new FieldMetadata(this, reflectFieldArray[i], typeHandler4, classMetadata.getID());
            boolean bl2 = false;
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                if (!((FieldMetadata)iterator4.current()).equals(fieldMetadata)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
            collection4.add(fieldMetadata);
        }
        return bl;
    }

    private boolean installTranslator(ObjectContainerBase objectContainerBase) {
        ObjectTranslator objectTranslator = this.getTranslator();
        if (objectTranslator == null) {
            return false;
        }
        if (this.isNewTranslator(objectTranslator)) {
            this._container.setDirtyInSystemTransaction(this);
        }
        this.installCustomFieldMetadata(objectContainerBase, new TranslatedFieldMetadata(this, objectTranslator));
        return true;
    }

    private void installCustomFieldMetadata(ObjectContainerBase objectContainerBase, FieldMetadata fieldMetadata) {
        boolean bl;
        int n = 1;
        boolean bl2 = this.generateVersionNumbers() && !this.ancestorHasVersionField();
        boolean bl3 = bl = this.generateUUIDs() && !this.ancestorHasUUIDField();
        if (bl2) {
            n = 2;
        }
        if (bl) {
            n = 3;
        }
        this.i_fields = new FieldMetadata[n];
        this.i_fields[0] = fieldMetadata;
        if (bl2 || bl) {
            this.i_fields[1] = objectContainerBase.versionIndex();
        }
        if (bl) {
            this.i_fields[2] = objectContainerBase.uUIDIndex();
        }
        this.setStateOK();
    }

    private ObjectTranslator getTranslator() {
        return this.i_config == null ? null : this.i_config.getTranslator();
    }

    private boolean isNewTranslator(ObjectTranslator objectTranslator) {
        return !this.hasFields() || !objectTranslator.getClass().getName().equals(this.i_fields[0].getName());
    }

    private boolean hasFields() {
        return this.i_fields != null && this.i_fields.length > 0;
    }

    void addToIndex(LocalObjectContainer localObjectContainer, Transaction transaction, int n) {
        if (localObjectContainer.maintainsIndices()) {
            this.addToIndex1(localObjectContainer, transaction, n);
        }
    }

    void addToIndex1(LocalObjectContainer localObjectContainer, Transaction transaction, int n) {
        if (this.i_ancestor != null) {
            this.i_ancestor.addToIndex1(localObjectContainer, transaction, n);
        }
        if (this.hasClassIndex()) {
            this._index.add(transaction, n);
        }
    }

    boolean allowsQueries() {
        return this.hasClassIndex();
    }

    public void cascadeActivation(Transaction transaction, Object object, int n, boolean bl) {
        Config4Class config4Class = this.configOrAncestorConfig();
        if (config4Class != null && bl) {
            n = config4Class.adjustActivationDepth(n);
        }
        if (n > 0) {
            ObjectContainerBase objectContainerBase = transaction.container();
            if (bl) {
                if (this.isValueType()) {
                    this.activateFields(transaction, object, n - 1);
                } else {
                    objectContainerBase.stillToActivate(transaction, object, n - 1);
                }
            } else {
                objectContainerBase.stillToDeactivate(transaction, object, n - 1, false);
            }
        }
    }

    void checkChanges() {
        if (this.stateOK() && !this.bitIsTrue(6)) {
            this.bitTrue(6);
            if (this.i_ancestor != null) {
                this.i_ancestor.checkChanges();
            }
            if (this._reflector != null) {
                this.addMembers(this._container);
                if (!this._container.isClient()) {
                    this.write(this._container.systemTransaction());
                }
            }
        }
    }

    public void checkType() {
        ReflectClass reflectClass = this.classReflector();
        if (reflectClass == null) {
            return;
        }
        if (this._container._handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass)) {
            this._internal = true;
        }
        if (this._container._handlers.ICLASS_UNVERSIONED.isAssignableFrom(reflectClass)) {
            this._unversioned = true;
        }
        if (this._container._handlers.ICLASS_DB4OTYPEIMPL.isAssignableFrom(reflectClass)) {
            Db4oTypeImpl db4oTypeImpl = (Db4oTypeImpl)reflectClass.newInstance();
            this._classIndexed = db4oTypeImpl == null || db4oTypeImpl.hasClassIndex();
        } else if (this.i_config != null) {
            this._classIndexed = this.i_config.indexed();
        }
    }

    public final int adjustUpdateDepth(Transaction transaction, int n) {
        boolean bl;
        Config4Class config4Class = this.configOrAncestorConfig();
        if (n == -2147483548) {
            n = this.checkUpdateDepthUnspecified(transaction.container().configImpl());
            if (this.classReflector().isCollection()) {
                n = this.adjustDepthToBorders(n);
            }
        }
        if (config4Class == null) {
            return n - 1;
        }
        boolean bl2 = config4Class.cascadeOnDelete() == TernaryBool.YES;
        boolean bl3 = bl = config4Class.cascadeOnUpdate() == TernaryBool.YES;
        if (bl2 || bl) {
            n = this.adjustDepthToBorders(n);
        }
        return n - 1;
    }

    private int adjustDepthToBorders(int n) {
        int n2 = this.reflector().collectionUpdateDepth(this.classReflector());
        if (n > Integer.MIN_VALUE && n < n2) {
            n = n2;
        }
        return n;
    }

    private final int checkUpdateDepthUnspecified(Config4Impl config4Impl) {
        int n;
        int n2 = config4Impl.updateDepth() + 1;
        if (this.i_config != null && this.i_config.updateDepth() != 0) {
            n2 = this.i_config.updateDepth() + 1;
        }
        if (this.i_ancestor != null && (n = this.i_ancestor.checkUpdateDepthUnspecified(config4Impl)) > n2) {
            return n;
        }
        return n2;
    }

    public void collectConstraints(Transaction transaction, QConObject qConObject, Object object, Visitor4 visitor4) {
        if (this.i_fields != null) {
            for (int i = 0; i < this.i_fields.length; ++i) {
                this.i_fields[i].collectConstraints(transaction, qConObject, object, visitor4);
            }
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.collectConstraints(transaction, qConObject, object, visitor4);
        }
    }

    public final TreeInt collectFieldIDs(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, TreeInt treeInt, StatefulBuffer statefulBuffer, String string) {
        return marshallerFamily._object.collectFieldIDs(treeInt, this, objectHeaderAttributes, statefulBuffer, string);
    }

    public boolean customizedNewInstance() {
        return this.configInstantiates();
    }

    public Config4Class config() {
        return this.i_config;
    }

    public Config4Class configOrAncestorConfig() {
        if (this.i_config != null) {
            return this.i_config;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.configOrAncestorConfig();
        }
        return null;
    }

    private boolean createConstructor(ObjectContainerBase objectContainerBase, String string) {
        ReflectClass reflectClass = objectContainerBase.reflector().forName(string);
        return this.createConstructor(objectContainerBase, reflectClass, string, true);
    }

    public boolean createConstructor(ObjectContainerBase objectContainerBase, ReflectClass reflectClass, String string, boolean bl) {
        this._reflector = reflectClass;
        this._eventDispatcher = EventDispatcher.forClass(objectContainerBase, reflectClass);
        if (reflectClass != null) {
            this._isEnum = Platform4.jdk().isEnum(this.reflector(), reflectClass);
        }
        if (this.customizedNewInstance()) {
            return true;
        }
        if (reflectClass != null && (objectContainerBase._handlers.ICLASS_TRANSIENTCLASS.isAssignableFrom(reflectClass) || Platform4.isTransient(reflectClass))) {
            reflectClass = null;
        }
        if (reflectClass == null) {
            if ((string == null || !Platform4.isDb4oClass(string)) && bl) {
                objectContainerBase.logMsg(23, string);
            }
            this.setStateDead();
            return false;
        }
        if (objectContainerBase._handlers.createConstructor(reflectClass, !this.callConstructor())) {
            return true;
        }
        this.setStateDead();
        if (bl) {
            objectContainerBase.logMsg(7, string);
        }
        if (objectContainerBase.configImpl().exceptionsOnNotStorable()) {
            throw new ObjectNotStorableException(reflectClass);
        }
        return false;
    }

    public void deactivate(Transaction transaction, Object object, int n) {
        if (this.objectCanDeactivate(transaction, object)) {
            this.deactivate1(transaction, object, n);
            this.objectOnDeactivate(transaction, object);
        }
    }

    private void objectOnDeactivate(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.callbacks().objectOnDeactivate(transaction, object);
        this.dispatchEvent(transaction, object, 3);
    }

    private boolean objectCanDeactivate(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        return objectContainerBase.callbacks().objectCanDeactivate(transaction, object) && this.dispatchEvent(transaction, object, 7);
    }

    void deactivate1(Transaction transaction, Object object, int n) {
        for (int i = 0; i < this.i_fields.length; ++i) {
            this.i_fields[i].deactivate(transaction, object, n);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.deactivate1(transaction, object, n);
        }
    }

    final void delete(StatefulBuffer statefulBuffer, Object object) {
        ObjectHeader objectHeader = new ObjectHeader(this._container, this, statefulBuffer);
        this.delete1(objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, object);
    }

    private final void delete1(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer, Object object) {
        this.removeFromIndex(statefulBuffer.getTransaction(), statefulBuffer.getID());
        this.deleteMembers(marshallerFamily, objectHeaderAttributes, statefulBuffer, statefulBuffer.getTransaction().container()._handlers.arrayType(object), false);
    }

    public void deleteEmbedded(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws Db4oIOException {
        if (statefulBuffer.cascadeDeletes() > 0) {
            int n = statefulBuffer.readInt();
            if (n > 0) {
                this.deleteEmbedded1(marshallerFamily, statefulBuffer, n);
            }
        } else {
            statefulBuffer.incrementOffset(this.linkLength());
        }
    }

    public void deleteEmbedded1(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, int n) throws Db4oIOException {
        if (statefulBuffer.cascadeDeletes() > 0) {
            ObjectReference objectReference;
            ObjectContainerBase objectContainerBase = statefulBuffer.getStream();
            Transaction transaction = statefulBuffer.getTransaction();
            Object object = objectContainerBase.getByID2(transaction, n);
            int n2 = statefulBuffer.cascadeDeletes() - 1;
            if (object != null && this.isCollection(object)) {
                n2 += this.reflector().collectionUpdateDepth(this.reflector().forObject(object)) - 1;
            }
            if ((objectReference = transaction.referenceForId(n)) != null) {
                statefulBuffer.getStream().delete2(transaction, objectReference, object, n2, false);
            }
        }
    }

    void deleteMembers(MarshallerFamily marshallerFamily, ObjectHeaderAttributes objectHeaderAttributes, StatefulBuffer statefulBuffer, int n, boolean bl) {
        try {
            if (this.cascadeOnDelete()) {
                int n2 = statefulBuffer.cascadeDeletes();
                if (this.classReflector().isCollection()) {
                    int n3 = n2 + this.reflector().collectionUpdateDepth(this.classReflector()) - 3;
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    statefulBuffer.setCascadeDeletes(n3);
                } else {
                    statefulBuffer.setCascadeDeletes(1);
                }
                marshallerFamily._object.deleteMembers(this, objectHeaderAttributes, statefulBuffer, n, bl);
                statefulBuffer.setCascadeDeletes(n2);
            } else {
                marshallerFamily._object.deleteMembers(this, objectHeaderAttributes, statefulBuffer, n, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TernaryBool cascadeOnDeleteTernary() {
        Config4Class config4Class = this.config();
        TernaryBool ternaryBool = TernaryBool.UNSPECIFIED;
        if (config4Class != null && (ternaryBool = config4Class.cascadeOnDelete()) != TernaryBool.UNSPECIFIED) {
            return ternaryBool;
        }
        if (this.i_ancestor == null) {
            return ternaryBool;
        }
        return this.i_ancestor.cascadeOnDeleteTernary();
    }

    public boolean cascadeOnDelete() {
        return this.cascadeOnDeleteTernary() == TernaryBool.YES;
    }

    public final boolean dispatchEvent(Transaction transaction, Object object, int n) {
        if (!this.dispatchingEvents(transaction)) {
            return true;
        }
        return this._eventDispatcher.dispatch(transaction, object, n);
    }

    private boolean dispatchingEvents(Transaction transaction) {
        return this._eventDispatcher != null && transaction.container().dispatchsEvents();
    }

    public final boolean hasEventRegistered(Transaction transaction, int n) {
        if (!this.dispatchingEvents(transaction)) {
            return true;
        }
        return this._eventDispatcher.hasEventRegistered(n);
    }

    public final int fieldCount() {
        int n = this.i_fields.length;
        if (this.i_ancestor != null) {
            n += this.i_ancestor.fieldCount();
        }
        return n;
    }

    public Iterator4 fields() {
        return new FieldMetadataIterator(this);
    }

    public final HandlerVersion findOffset(Buffer buffer, FieldMetadata fieldMetadata) {
        if (buffer == null) {
            return HandlerVersion.INVALID;
        }
        buffer._offset = 0;
        ObjectHeader objectHeader = new ObjectHeader(this._container, this, buffer);
        boolean bl = objectHeader.objectMarshaller().findOffset(this, objectHeader._headerAttributes, buffer, fieldMetadata);
        if (!bl) {
            return HandlerVersion.INVALID;
        }
        return new HandlerVersion(objectHeader.handlerVersion());
    }

    void forEachFieldMetadata(Visitor4 visitor4) {
        if (this.i_fields != null) {
            for (int i = 0; i < this.i_fields.length; ++i) {
                visitor4.visit(this.i_fields[i]);
            }
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.forEachFieldMetadata(visitor4);
        }
    }

    public static ClassMetadata forObject(Transaction transaction, Object object, boolean bl) {
        ReflectClass reflectClass = transaction.reflector().forObject(object);
        if (reflectClass != null && reflectClass.getSuperclass() == null && object != null) {
            throw new ObjectNotStorableException(object.toString());
        }
        if (bl) {
            return transaction.container().produceClassMetadata(reflectClass);
        }
        return transaction.container().classMetadataForReflectClass(reflectClass);
    }

    public boolean generateUUIDs() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean bl = this.i_config == null ? false : this.i_config.generateUUIDs();
        return this.generate1(this._container.config().generateUUIDs(), bl);
    }

    private boolean generateVersionNumbers() {
        if (!this.generateVirtual()) {
            return false;
        }
        boolean bl = this.i_config == null ? false : this.i_config.generateVersionNumbers();
        return this.generate1(this._container.config().generateVersionNumbers(), bl);
    }

    private boolean generateVirtual() {
        if (this._unversioned) {
            return false;
        }
        return !this._internal;
    }

    private boolean generate1(ConfigScope configScope, boolean bl) {
        return configScope.applyConfig(bl);
    }

    ClassMetadata getAncestor() {
        return this.i_ancestor;
    }

    public Object getComparableObject(Object object) {
        if (this.i_config != null && this.i_config.queryAttributeProvider() != null) {
            return this.i_config.queryAttributeProvider().attribute(object);
        }
        return object;
    }

    public ClassMetadata getHigherHierarchy(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = this.getHigherHierarchy1(classMetadata);
        if (classMetadata2 != null) {
            return classMetadata2;
        }
        return classMetadata.getHigherHierarchy1(this);
    }

    private ClassMetadata getHigherHierarchy1(ClassMetadata classMetadata) {
        if (classMetadata == this) {
            return this;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.getHigherHierarchy1(classMetadata);
        }
        return null;
    }

    public ClassMetadata getHigherOrCommonHierarchy(ClassMetadata classMetadata) {
        ClassMetadata classMetadata2 = this.getHigherHierarchy1(classMetadata);
        if (classMetadata2 != null) {
            return classMetadata2;
        }
        if (this.i_ancestor != null && (classMetadata2 = this.i_ancestor.getHigherOrCommonHierarchy(classMetadata)) != null) {
            return classMetadata2;
        }
        return classMetadata.getHigherHierarchy1(this);
    }

    public byte getIdentifier() {
        return 67;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            return this.getIDs(this._container.transaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs(Transaction transaction) {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            if (!this.hasClassIndex()) {
                return new long[0];
            }
            return transaction.container().getIDsForClass(transaction, this);
        }
    }

    public boolean hasClassIndex() {
        return this._classIndexed;
    }

    private boolean ancestorHasUUIDField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasUUIDField();
    }

    private boolean hasUUIDField() {
        if (this.ancestorHasUUIDField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this.i_fields, UUIDFieldMetadata.class);
    }

    private boolean ancestorHasVersionField() {
        if (this.i_ancestor == null) {
            return false;
        }
        return this.i_ancestor.hasVersionField();
    }

    private boolean hasVersionField() {
        if (this.ancestorHasVersionField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this.i_fields, VersionFieldMetadata.class);
    }

    public ClassIndexStrategy index() {
        return this._index;
    }

    public int indexEntryCount(Transaction transaction) {
        if (!this.stateOK()) {
            return 0;
        }
        return this._index.entryCount(transaction);
    }

    public Object indexEntryToObject(Transaction transaction, Object object) {
        if (object == null) {
            return null;
        }
        int n = (Integer)object;
        return this.container().getByID2(transaction, n);
    }

    public ReflectClass classReflector() {
        return this._reflector;
    }

    public String getName() {
        if (this.i_name == null && this._reflector != null) {
            this.i_name = this._reflector.getName();
        }
        return this.i_name;
    }

    public StoredClass getParentStoredClass() {
        return this.getAncestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField[] getStoredFields() {
        Object object = this.lock();
        synchronized (object) {
            if (this.i_fields == null) {
                return new StoredField[0];
            }
            StoredField[] storedFieldArray = new StoredField[this.i_fields.length];
            System.arraycopy(this.i_fields, 0, storedFieldArray, 0, this.i_fields.length);
            return storedFieldArray;
        }
    }

    final ObjectContainerBase container() {
        return this._container;
    }

    public FieldMetadata fieldMetadataForName(final String string) {
        final FieldMetadata[] fieldMetadataArray = new FieldMetadata[1];
        this.forEachFieldMetadata(new Visitor4(){

            public void visit(Object object) {
                if (string.equals(((FieldMetadata)object).getName())) {
                    fieldMetadataArray[0] = (FieldMetadata)object;
                }
            }
        });
        return fieldMetadataArray[0];
    }

    public boolean hasField(ObjectContainerBase objectContainerBase, String string) {
        if (this.classReflector().isCollection()) {
            return true;
        }
        return this.fieldMetadataForName(string) != null;
    }

    boolean hasVirtualAttributes() {
        if (this._internal) {
            return false;
        }
        return this.hasVersionField() || this.hasUUIDField();
    }

    public boolean holdsAnyClass() {
        return this.classReflector().isCollection();
    }

    void incrementFieldsOffset1(Buffer buffer) {
        int n = this.readFieldCount(buffer);
        for (int i = 0; i < n; ++i) {
            this.i_fields[i].incrementOffset(buffer);
        }
    }

    final boolean init(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, ReflectClass reflectClass) {
        this.setAncestor(classMetadata);
        Config4Impl config4Impl = objectContainerBase.configImpl();
        String string = reflectClass.getName();
        this.setConfig(config4Impl.configClass(string));
        if (!this.createConstructor(objectContainerBase, reflectClass, string, false)) {
            return false;
        }
        this.checkType();
        if (this.allowsQueries()) {
            this._index.initialize(objectContainerBase);
        }
        this.i_name = string;
        this.i_ancestor = classMetadata;
        this.bitTrue(6);
        return true;
    }

    final void initConfigOnUp(Transaction transaction) {
        Config4Class config4Class = Platform4.extendConfiguration(this._reflector, this._container.configure(), this.i_config);
        if (config4Class != null) {
            this.i_config = config4Class;
        }
        if (this.i_config == null) {
            return;
        }
        if (!this.stateOK()) {
            return;
        }
        if (this.i_fields == null) {
            return;
        }
        for (int i = 0; i < this.i_fields.length; ++i) {
            FieldMetadata fieldMetadata = this.i_fields[i];
            String string = fieldMetadata.getName();
            if (!fieldMetadata.hasConfig() && config4Class != null && config4Class.configField(string) != null) {
                fieldMetadata.initIndex(this, string);
            }
            fieldMetadata.initConfigOnUp(transaction);
        }
    }

    void initOnUp(Transaction transaction) {
        if (!this.stateOK()) {
            return;
        }
        this.initConfigOnUp(transaction);
        this.storeStaticFieldValues(transaction, false);
    }

    public Object instantiate(UnmarshallingContext unmarshallingContext) {
        boolean bl;
        unmarshallingContext.adjustInstantiationDepth();
        Object object = unmarshallingContext.persistentObject();
        boolean bl2 = bl = object == null;
        if (bl) {
            object = this.instantiateObject(unmarshallingContext);
            if (object == null) {
                return null;
            }
            this.shareTransaction(object, unmarshallingContext.transaction());
            this.shareObjectReference(object, unmarshallingContext.reference());
            unmarshallingContext.setObjectWeak(object);
            unmarshallingContext.transaction().referenceSystem().addExistingReferenceToObjectTree(unmarshallingContext.reference());
            this.objectOnInstantiate(unmarshallingContext.transaction(), object);
        }
        unmarshallingContext.addToIDTree();
        if (bl) {
            if (unmarshallingContext.activationDepth() == 0) {
                unmarshallingContext.reference().setStateDeactivated();
            } else {
                this.activate(unmarshallingContext);
            }
        } else if (this.activatingActiveObject(unmarshallingContext.container(), unmarshallingContext.reference())) {
            if (unmarshallingContext.activationDepth() > 1) {
                this.activateFields(unmarshallingContext.transaction(), object, unmarshallingContext.activationDepth() - 1);
            }
        } else {
            this.activate(unmarshallingContext);
        }
        return object;
    }

    public Object instantiateTransient(UnmarshallingContext unmarshallingContext) {
        Object object = this.instantiateObject(unmarshallingContext);
        if (object == null) {
            return null;
        }
        unmarshallingContext.container().peeked(unmarshallingContext.objectID(), object);
        this.instantiateFields(unmarshallingContext);
        return object;
    }

    private boolean activatingActiveObject(ObjectContainerBase objectContainerBase, ObjectReference objectReference) {
        return !objectContainerBase._refreshInsteadOfActivate && objectReference.isActive();
    }

    private void activate(UnmarshallingContext unmarshallingContext) {
        if (!this.objectCanActivate(unmarshallingContext.transaction(), unmarshallingContext.persistentObject())) {
            unmarshallingContext.reference().setStateDeactivated();
            return;
        }
        unmarshallingContext.reference().setStateClean();
        if (unmarshallingContext.activationDepth() > 0 || this.cascadeOnActivate()) {
            this.instantiateFields(unmarshallingContext);
        }
        this.objectOnActivate(unmarshallingContext.transaction(), unmarshallingContext.persistentObject());
    }

    private boolean configInstantiates() {
        return this.config() != null && this.config().instantiates();
    }

    private Object instantiateObject(UnmarshallingContext unmarshallingContext) {
        Object object = this.configInstantiates() ? this.instantiateFromConfig(unmarshallingContext) : this.instantiateFromReflector(unmarshallingContext.container());
        unmarshallingContext.persistentObject(object);
        return object;
    }

    private void objectOnInstantiate(Transaction transaction, Object object) {
        transaction.container().callbacks().objectOnInstantiate(transaction, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object instantiateFromReflector(ObjectContainerBase objectContainerBase) {
        if (this._reflector == null) {
            return null;
        }
        objectContainerBase.instantiating(true);
        try {
            Object object = this._reflector.newInstance();
            return object;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            objectContainerBase.logMsg(7, this.classReflector().getName());
            Object var3_5 = null;
            return var3_5;
        }
        catch (Exception exception) {
            Object var3_6 = null;
            return var3_6;
        }
        finally {
            objectContainerBase.instantiating(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateFromConfig(UnmarshallingContext unmarshallingContext) {
        int n = unmarshallingContext.offset();
        unmarshallingContext.seek(n + 4);
        try {
            Object object = this.i_config.instantiate(unmarshallingContext.container(), this.i_fields[0].read(unmarshallingContext));
            return object;
        }
        finally {
            unmarshallingContext.seek(n);
        }
    }

    private boolean cascadeOnActivate() {
        return this.i_config != null && this.i_config.cascadeOnActivate() == TernaryBool.YES;
    }

    private void shareObjectReference(Object object, ObjectReference objectReference) {
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).setObjectReference(objectReference);
        }
    }

    private void shareTransaction(Object object, Transaction transaction) {
        if (object instanceof TransactionAware) {
            ((TransactionAware)object).setTrans(transaction);
        }
    }

    private void objectOnActivate(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.callbacks().objectOnActivate(transaction, object);
        this.dispatchEvent(transaction, object, 2);
    }

    private boolean objectCanActivate(Transaction transaction, Object object) {
        ObjectContainerBase objectContainerBase = transaction.container();
        return objectContainerBase.callbacks().objectCanActivate(transaction, object) && this.dispatchEvent(transaction, object, 6);
    }

    void instantiateFields(UnmarshallingContext unmarshallingContext) {
        MarshallerFamily.version((int)unmarshallingContext.handlerVersion())._object.instantiateFields(unmarshallingContext);
    }

    public boolean isArray() {
        return this.classReflector().isCollection();
    }

    boolean isCollection(Object object) {
        return this.reflector().forObject(object).isCollection();
    }

    public boolean isDirty() {
        if (!this.stateOK()) {
            return false;
        }
        return super.isDirty();
    }

    boolean isEnum() {
        return this._isEnum;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isStrongTyped() {
        return true;
    }

    public boolean isValueType() {
        return Platform4.isValueType(this.classReflector());
    }

    private final Object lock() {
        return this._container.lock();
    }

    public String nameToWrite() {
        if (this.i_config != null && this.i_config.writeAs() != null) {
            return this.i_config.writeAs();
        }
        if (this.i_name == null) {
            return "";
        }
        return this._container.configImpl().resolveAliasRuntimeName(this.i_name);
    }

    public final boolean callConstructor() {
        TernaryBool ternaryBool = this.callConstructorSpecialized();
        if (!ternaryBool.unspecified()) {
            return ternaryBool.definiteYes();
        }
        return this._container.configImpl().callConstructors().definiteYes();
    }

    private final TernaryBool callConstructorSpecialized() {
        TernaryBool ternaryBool;
        if (this.i_config != null && !(ternaryBool = this.i_config.callConstructor()).unspecified()) {
            return ternaryBool;
        }
        if (this._isEnum) {
            return TernaryBool.NO;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.callConstructorSpecialized();
        }
        return TernaryBool.UNSPECIFIED;
    }

    public int ownLength() {
        return MarshallerFamily.current()._class.marshalledLength(this._container, this);
    }

    void purge() {
        this._index.purge();
    }

    public Object readValueType(Transaction transaction, int n, int n2) {
        int n3 = Math.max(1, n2);
        ObjectReference objectReference = transaction.referenceForId(n);
        if (objectReference != null) {
            Object object = objectReference.getObject();
            if (object == null) {
                transaction.removeReference(objectReference);
            } else {
                objectReference.activate(transaction, object, n3, false);
                return objectReference.getObject();
            }
        }
        return new ObjectReference(n).read(transaction, n3, 1, false);
    }

    public TypeHandler4 readArrayHandler(Transaction transaction, MarshallerFamily marshallerFamily, Buffer[] bufferArray) {
        if (this.isArray()) {
            return this;
        }
        return null;
    }

    public TypeHandler4 readArrayHandler1(Buffer[] bufferArray) {
        if (this.isArray()) {
            if (Platform4.isCollectionTranslator(this.i_config)) {
                bufferArray[0].incrementOffset(4);
                return new ArrayHandler(this._container, null, false);
            }
            this.incrementFieldsOffset1(bufferArray[0]);
            if (this.i_ancestor != null) {
                return this.i_ancestor.readArrayHandler1(bufferArray);
            }
        }
        return null;
    }

    public ObjectID readObjectID(InternalReadContext internalReadContext) {
        int n = internalReadContext.readInt();
        return n == 0 ? ObjectID.IS_NULL : new ObjectID(n);
    }

    public void readCandidates(int n, Buffer buffer, final QCandidates qCandidates) {
        LocalTransaction localTransaction;
        Object object;
        int n2 = 0;
        int n3 = buffer._offset;
        try {
            n2 = buffer.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer._offset = n3;
        if (n2 != 0 && (object = (localTransaction = qCandidates.i_trans).container().getByID(localTransaction, n2)) != null) {
            qCandidates.i_trans.container().activate(localTransaction, object, 2);
            Platform4.forEachCollectionElement(object, new Visitor4(){

                public void visit(Object object) {
                    qCandidates.addByIdentity(new QCandidate(qCandidates, object, localTransaction.container().getID(localTransaction, object), true));
                }
            });
        }
    }

    public final int readFieldCount(Buffer buffer) {
        int n = buffer.readInt();
        if (n > this.i_fields.length) {
            return this.i_fields.length;
        }
        return n;
    }

    public Object readIndexEntry(Buffer buffer) {
        return new Integer(buffer.readInt());
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException {
        return this.readIndexEntry(statefulBuffer);
    }

    byte[] readName(Transaction transaction) {
        this.i_reader = transaction.container().readReaderByID(transaction, this.getID());
        return this.readName1(transaction, this.i_reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] readName1(Transaction transaction, Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        this.i_reader = buffer;
        boolean bl = false;
        try {
            ClassMarshaller classMarshaller = MarshallerFamily.current()._class;
            this.i_nameBytes = classMarshaller.readName(transaction, buffer);
            this._metaClassID = classMarshaller.readMetaClassID(buffer);
            this.setStateUnread();
            this.bitFalse(6);
            this.bitFalse(5);
            bl = true;
            byte[] byArray = this.i_nameBytes;
            return byArray;
        }
        finally {
            if (!bl) {
                this.setStateDead();
            }
        }
    }

    void readVirtualAttributes(Transaction transaction, ObjectReference objectReference) {
        int n = objectReference.getID();
        ObjectContainerBase objectContainerBase = transaction.container();
        Buffer buffer = objectContainerBase.readReaderByID(transaction, n);
        ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, this, buffer);
        objectHeader.objectMarshaller().readVirtualAttributes(transaction, this, objectReference, objectHeader._headerAttributes, buffer);
    }

    GenericReflector reflector() {
        return this._container.reflector();
    }

    public void rename(String string) {
        if (!this._container.isClient()) {
            int n = this._state;
            this.setStateOK();
            this.i_name = string;
            this.i_nameBytes = this.asBytes(this.i_name);
            this.setStateDirty();
            this.write(this._container.systemTransaction());
            ReflectClass reflectClass = this._reflector;
            this._reflector = this.container().reflector().forName(string);
            this.container().classCollection().refreshClassCache(this, reflectClass);
            this.refresh();
            this._state = n;
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    private byte[] asBytes(String string) {
        return this.container().stringIO().write(string);
    }

    final void createConfigAndConstructor(Hashtable4 hashtable4, ReflectClass reflectClass, String string) {
        this.i_name = string;
        this.setConfig(this._container.configImpl().configClass(this.i_name));
        if (reflectClass == null) {
            this.createConstructor(this._container, this.i_name);
        } else {
            this.createConstructor(this._container, reflectClass, this.i_name, true);
        }
        if (this.i_nameBytes != null) {
            hashtable4.remove(this.i_nameBytes);
            this.i_nameBytes = null;
        }
    }

    String resolveName(ReflectClass reflectClass) {
        if (reflectClass != null) {
            return reflectClass.getName();
        }
        if (this.i_nameBytes != null) {
            String string = this._container.stringIO().read(this.i_nameBytes);
            return this._container.configImpl().resolveAliasStoredName(string);
        }
        throw new IllegalStateException();
    }

    boolean readThis() {
        if (this.stateUnread()) {
            this.setStateOK();
            this.setStateClean();
            this.forceRead();
            return true;
        }
        return false;
    }

    final void forceRead() {
        if (this.i_reader == null || this.bitIsTrue(8)) {
            return;
        }
        this.bitTrue(8);
        MarshallerFamily.forConverterVersion((int)this._container.converterVersion())._class.read(this._container, this, this.i_reader);
        this.i_nameBytes = null;
        this.i_reader = null;
        this.bitFalse(8);
    }

    public void readThis(Transaction transaction, Buffer buffer) {
        throw Exceptions4.virtualException();
    }

    public void refresh() {
        if (!this.stateUnread()) {
            this.createConstructor(this._container, this.i_name);
            this.bitFalse(6);
            this.checkChanges();
            if (this.i_fields != null) {
                for (int i = 0; i < this.i_fields.length; ++i) {
                    this.i_fields[i].refresh();
                }
            }
        }
    }

    void removeFromIndex(Transaction transaction, int n) {
        if (this.hasClassIndex()) {
            this._index.remove(transaction, n);
        }
        if (this.i_ancestor != null) {
            this.i_ancestor.removeFromIndex(transaction, n);
        }
    }

    boolean renameField(String string, String string2) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.i_fields.length; ++n) {
            if (!this.i_fields[n].getName().equals(string2)) continue;
            this._container.logMsg(9, "class:" + this.getName() + " field:" + string2);
            return false;
        }
        for (n = 0; n < this.i_fields.length; ++n) {
            if (!this.i_fields[n].getName().equals(string)) continue;
            this.i_fields[n].setName(string2);
            bl = true;
        }
        return bl;
    }

    void setConfig(Config4Class config4Class) {
        if (config4Class == null) {
            return;
        }
        if (this.i_config == null) {
            this.i_config = config4Class;
        }
    }

    void setName(String string) {
        this.i_name = string;
    }

    final void setStateDead() {
        this.bitTrue(7);
        this.bitFalse(4);
    }

    private final void setStateUnread() {
        this.bitFalse(7);
        this.bitTrue(4);
    }

    private final void setStateOK() {
        this.bitFalse(7);
        this.bitFalse(4);
    }

    boolean stateDead() {
        return this.bitIsTrue(7);
    }

    private final boolean stateOK() {
        return this.bitIsFalse(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    final boolean stateOKAndAncestors() {
        if (!this.stateOK() || this.i_fields == null) {
            return false;
        }
        if (this.i_ancestor != null) {
            return this.i_ancestor.stateOKAndAncestors();
        }
        return true;
    }

    boolean stateUnread() {
        return this.bitIsTrue(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    boolean storeField(ReflectField reflectField) {
        if (reflectField.isStatic()) {
            return false;
        }
        if (reflectField.isTransient()) {
            Config4Class config4Class = this.configOrAncestorConfig();
            if (config4Class == null) {
                return false;
            }
            if (!config4Class.storeTransientFields()) {
                return false;
            }
        }
        return Platform4.canSetAccessible() || reflectField.isPublic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredField storedField(String string, Object object) {
        Object object2 = this.lock();
        synchronized (object2) {
            ClassMetadata classMetadata = this._container.classMetadataForReflectClass(ReflectorUtils.reflectClassFor(this.reflector(), object));
            if (this.i_fields != null) {
                for (int i = 0; i < this.i_fields.length; ++i) {
                    if (!this.i_fields[i].getName().equals(string) || classMetadata != null && classMetadata != this.i_fields[i].handlerClassMetadata(this._container)) continue;
                    return this.i_fields[i];
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStaticFieldValues(Transaction transaction, boolean bl) {
        if (this.bitIsTrue(5) && !bl) {
            return;
        }
        this.bitTrue(5);
        if (!this.shouldStoreStaticFields(transaction)) {
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.showInternalClasses(true);
        try {
            StaticClass staticClass = this.queryStaticClass(transaction);
            if (staticClass == null) {
                this.createStaticClass(transaction);
            } else {
                this.updateStaticClass(transaction, staticClass);
            }
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    private boolean shouldStoreStaticFields(Transaction transaction) {
        return !transaction.container().config().isReadOnly() && (this.staticFieldValuesArePersisted() || Platform4.storeStaticFieldValues(transaction.reflector(), this.classReflector()));
    }

    private void updateStaticClass(final Transaction transaction, StaticClass staticClass) {
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.activate(transaction, staticClass, 4);
        final StaticField[] staticFieldArray = staticClass.fields;
        Iterator4 iterator4 = Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object object) {
                ReflectField reflectField = (ReflectField)object;
                StaticField staticField = ClassMetadata.this.fieldByName(staticFieldArray, reflectField.getName());
                if (staticField != null) {
                    ClassMetadata.this.updateExistingStaticField(transaction, staticField, reflectField);
                    return staticField;
                }
                return ClassMetadata.this.toStaticField(reflectField);
            }
        });
        staticClass.fields = this.toStaticFieldArray(iterator4);
        if (!objectContainerBase.isClient()) {
            this.setStaticClass(transaction, staticClass);
        }
    }

    private void createStaticClass(Transaction transaction) {
        if (transaction.container().isClient()) {
            return;
        }
        StaticClass staticClass = new StaticClass(this.i_name, this.toStaticFieldArray(this.staticReflectFieldsToStaticFields()));
        this.setStaticClass(transaction, staticClass);
    }

    private Iterator4 staticReflectFieldsToStaticFields() {
        return Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object object) {
                return ClassMetadata.this.toStaticField((ReflectField)object);
            }
        });
    }

    protected StaticField toStaticField(ReflectField reflectField) {
        return new StaticField(reflectField.getName(), this.staticReflectFieldValue(reflectField));
    }

    private Object staticReflectFieldValue(ReflectField reflectField) {
        reflectField.setAccessible();
        return reflectField.get(null);
    }

    private void setStaticClass(Transaction transaction, StaticClass staticClass) {
        transaction.container().setInternal(transaction, staticClass, true);
    }

    private StaticField[] toStaticFieldArray(Iterator4 iterator4) {
        return this.toStaticFieldArray(new Collection4(iterator4));
    }

    private StaticField[] toStaticFieldArray(Collection4 collection4) {
        return (StaticField[])collection4.toArray(new StaticField[collection4.size()]);
    }

    private Iterator4 staticReflectFields() {
        return Iterators.filter(this.reflectFields(), new Predicate4(){

            public boolean match(Object object) {
                return ((ReflectField)object).isStatic();
            }
        });
    }

    private ReflectField[] reflectFields() {
        return this.classReflector().getDeclaredFields();
    }

    protected void updateExistingStaticField(Transaction transaction, StaticField staticField, ReflectField reflectField) {
        int n;
        ObjectContainerBase objectContainerBase = transaction.container();
        Object object = this.staticReflectFieldValue(reflectField);
        if (staticField.value != null && object != null && staticField.value.getClass() == object.getClass() && (n = objectContainerBase.getID(transaction, staticField.value)) > 0) {
            if (staticField.value != object) {
                objectContainerBase.bind(transaction, object, n);
                objectContainerBase.refresh(transaction, object, Integer.MAX_VALUE);
                staticField.value = object;
            }
            return;
        }
        if (object == null) {
            try {
                reflectField.set(null, staticField.value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        staticField.value = object;
    }

    private boolean staticFieldValuesArePersisted() {
        return this.i_config != null && this.i_config.staticFieldValuesArePersisted();
    }

    protected StaticField fieldByName(StaticField[] staticFieldArray, String string) {
        for (int i = 0; i < staticFieldArray.length; ++i) {
            StaticField staticField = staticFieldArray[i];
            if (!string.equals(staticField.name)) continue;
            return staticField;
        }
        return null;
    }

    private StaticClass queryStaticClass(Transaction transaction) {
        Query query = transaction.container().query(transaction);
        query.constrain(Const4.CLASS_STATICCLASS);
        query.descend("name").constrain(this.i_name);
        ObjectSet objectSet = query.execute();
        return objectSet.size() > 0 ? (StaticClass)objectSet.next() : null;
    }

    public String toString() {
        if (this.i_name != null) {
            return this.i_name;
        }
        if (this.i_nameBytes == null) {
            return "*CLASS NAME UNKNOWN*";
        }
        UnicodeStringIO unicodeStringIO = this._container == null ? Const4.stringIO : this._container.stringIO();
        return ((LatinStringIO)unicodeStringIO).read(this.i_nameBytes);
    }

    public boolean writeObjectBegin() {
        if (!this.stateOK()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeIndexEntry(Buffer buffer, Object object) {
        if (object == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt((Integer)object);
    }

    public final void writeThis(Transaction transaction, Buffer buffer) {
        MarshallerFamily.current()._class.write(transaction, this, buffer);
    }

    public Comparable4 prepareComparison(Object object) {
        if (object == null) {
            this.i_lastID = 0;
            this.i_compareTo = null;
            return this;
        }
        if (object instanceof Integer) {
            this.i_lastID = (Integer)object;
        } else if (object instanceof TransactionContext) {
            TransactionContext transactionContext = (TransactionContext)object;
            object = transactionContext._object;
            this.i_lastID = this._container.getID(transactionContext._transaction, object);
        } else {
            throw new IllegalComparisonException();
        }
        this.i_compareTo = this.reflector().forObject(object);
        return this;
    }

    public int compareTo(Object object) {
        if (object instanceof TransactionContext) {
            object = ((TransactionContext)object)._object;
        }
        if (object instanceof Integer) {
            return (Integer)object - this.i_lastID;
        }
        if (object == null) {
            if (this.i_compareTo == null) {
                return 0;
            }
            return -1;
        }
        if (this.i_compareTo != null && this.i_compareTo.isAssignableFrom(this.reflector().forObject(object))) {
            return 0;
        }
        throw new IllegalComparisonException();
    }

    public static void defragObject(BufferPair bufferPair) {
        ObjectHeader objectHeader = ObjectHeader.defrag(bufferPair);
        objectHeader._marshallerFamily._object.defragFields(objectHeader.classMetadata(), objectHeader, bufferPair);
    }

    public void defrag(MarshallerFamily marshallerFamily, BufferPair bufferPair, boolean bl) {
        if (this.hasClassIndex()) {
            bufferPair.copyID();
        } else {
            bufferPair.copyUnindexedID();
        }
        int n = this.linkLength() - 4;
        bufferPair.incrementOffset(n);
    }

    public void defragClass(BufferPair bufferPair, int n) throws CorruptionException, IOException {
        MarshallerFamily marshallerFamily = MarshallerFamily.current();
        marshallerFamily._class.defrag(this, this._container.stringIO(), bufferPair, n);
    }

    public static ClassMetadata readClass(ObjectContainerBase objectContainerBase, Buffer buffer) {
        ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, buffer);
        return objectHeader.classMetadata();
    }

    public boolean isAssignableFrom(ClassMetadata classMetadata) {
        return this.classReflector().isAssignableFrom(classMetadata.classReflector());
    }

    public final void defragIndexEntry(BufferPair bufferPair) {
        bufferPair.copyID();
    }

    public void setAncestor(ClassMetadata classMetadata) {
        if (classMetadata == this) {
            throw new IllegalStateException();
        }
        this.i_ancestor = classMetadata;
    }

    public Object wrapWithTransactionContext(Transaction transaction, Object object) {
        if (object instanceof Integer) {
            return object;
        }
        return new TransactionContext(transaction, object);
    }

    public Object read(ReadContext readContext) {
        if (this.isValueType()) {
            return this.readValueType(readContext.transaction(), readContext.readInt(), ((UnmarshallingContext)readContext).activationDepth() - 1);
        }
        return readContext.readObject();
    }

    public void write(WriteContext writeContext, Object object) {
        writeContext.writeObject(object);
    }

    public TypeHandler4 typeHandler() {
        return this;
    }

    private static class FieldMetadataIterator
    implements Iterator4 {
        private final ClassMetadata _initialClazz;
        private ClassMetadata _curClazz;
        private int _curIdx;

        public FieldMetadataIterator(ClassMetadata classMetadata) {
            this._initialClazz = classMetadata;
            this.reset();
        }

        public Object current() {
            return this._curClazz.i_fields[this._curIdx];
        }

        public boolean moveNext() {
            if (this._curClazz == null) {
                this._curClazz = this._initialClazz;
                this._curIdx = 0;
            } else {
                ++this._curIdx;
            }
            while (this._curClazz != null && !this.indexInRange()) {
                this._curClazz = this._curClazz.i_ancestor;
                this._curIdx = 0;
            }
            return this._curClazz != null && this.indexInRange();
        }

        public void reset() {
            this._curClazz = null;
            this._curIdx = -1;
        }

        private boolean indexInRange() {
            return this._curIdx < this._curClazz.i_fields.length;
        }
    }
}

