/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.terracotta.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.terracotta.servlet.TerracottaSessionManager;

public class TerracottaSessionHandler
extends SessionHandler {
    public TerracottaSessionHandler() {
    }

    public TerracottaSessionHandler(SessionManager manager) {
        super(manager);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        this.setRequestedId(request, dispatch);
        Request currentRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        SessionManager requestSessionManager = currentRequest.getSessionManager();
        HttpSession requestSession = currentRequest.getSession(false);
        TerracottaSessionManager sessionManager = (TerracottaSessionManager)this.getSessionManager();
        Log.debug((String)"SessionManager = {}", (Object)sessionManager);
        if (sessionManager != requestSessionManager) {
            currentRequest.setSessionManager((SessionManager)sessionManager);
            currentRequest.setSession(null);
        }
        if (sessionManager != null) {
            sessionManager.enter(currentRequest);
        }
        try {
            HttpSession currentSession = null;
            if (sessionManager != null && (currentSession = currentRequest.getSession(false)) != null) {
                if (currentSession != requestSession) {
                    Cookie cookie = sessionManager.access(currentSession, request.isSecure());
                    if (cookie != null) {
                        response.addCookie(cookie);
                    }
                } else {
                    currentSession = currentRequest.recoverNewSession((Object)sessionManager);
                    if (currentSession != null) {
                        currentRequest.setSession(currentSession);
                    }
                }
            }
            Log.debug((String)"Session = {}", currentSession);
            this.getHandler().handle(target, request, response, dispatch);
        }
        catch (RetryRequest x) {
            HttpSession currentSession = currentRequest.getSession(false);
            if (currentSession != null && currentSession.isNew()) {
                currentRequest.saveNewSession((Object)sessionManager, currentSession);
            }
            throw x;
        }
        finally {
            if (sessionManager != null) {
                HttpSession currentSession = currentRequest.getSession(false);
                if (currentSession != null) {
                    sessionManager.complete(currentSession);
                }
                sessionManager.exit(currentRequest);
            }
            if (sessionManager != requestSessionManager) {
                currentRequest.setSessionManager(requestSessionManager);
                currentRequest.setSession(requestSession);
            }
        }
    }
}

