/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class OperatingSystem {
    private static OperatingSystem os;

    public abstract String getInstallDirectory(String var1, String var2);

    public OSTask[] getOSTasks(Install install) {
        return new OSTask[0];
    }

    public void mkdirs(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static OperatingSystem getOperatingSystem() {
        String string;
        if (os != null) {
            return os;
        }
        os = System.getProperty("mrj.version") != null ? new MacOS() : ((string = System.getProperty("os.name")).indexOf("Windows") != -1 ? new Windows() : (string.indexOf("OS/2") != -1 ? new HalfAnOS() : (string.indexOf("VMS") != -1 ? new VMS() : new Unix())));
        return os;
    }

    public static class VMS
    extends OperatingSystem {
        public String getInstallDirectory(String string, String string2) {
            return "./" + string.toLowerCase() + "/" + string2;
        }
    }

    public static class HalfAnOS
    extends OperatingSystem {
        public String getInstallDirectory(String string, String string2) {
            return "C:\\" + string + " " + string2;
        }
    }

    public static class Windows
    extends OperatingSystem {
        public String getInstallDirectory(String string, String string2) {
            String string3 = System.getenv("ProgramFiles");
            if (string3 == null) {
                string3 = "%ProgramFiles%";
            }
            return string3 + "\\" + string + " " + string2;
        }

        public OSTask[] getOSTasks(Install install) {
            return new OSTask[0];
        }

        public class JEditLauncherOSTask
        extends OSTask {
            public JEditLauncherOSTask(Install install) {
                super(install, "jedit-launcher");
            }

            public String getDefaultDirectory(Install install) {
                return null;
            }

            public void perform(String string, Vector vector) {
                if (!this.enabled || !vector.contains("jedit-windows")) {
                    return;
                }
                File file = new File(string, "jedit.exe");
                if (!file.exists()) {
                    return;
                }
                String[] stringArray = new String[]{file.getPath(), "/i", System.getProperty("java.home") + File.separator + "bin"};
                try {
                    Runtime.getRuntime().exec(stringArray).waitFor();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class MacOS
    extends Unix {
        public String getInstallDirectory(String string, String string2) {
            return "/Applications/" + string + " " + string2;
        }

        public String getExtraClassPath() {
            return "/System/Library/Java/:";
        }
    }

    public static class Unix
    extends OperatingSystem {
        public String getInstallDirectory(String string, String string2) {
            String string3 = "/usr/local/share/";
            if (!new File(string3).canWrite()) {
                string3 = System.getProperty("user.home");
            }
            return new File(string3, string.toLowerCase() + "/" + string2).getPath();
        }

        public String getExtraClassPath() {
            return "";
        }

        public OSTask[] getOSTasks(Install install) {
            return new OSTask[]{new ScriptOSTask(install), new ManPageOSTask(install)};
        }

        public void mkdirs(String string) throws IOException {
            File file = new File(string);
            if (!file.exists()) {
                String[] stringArray = new String[]{"mkdir", "-m", "755", "-p", string};
                this.exec(stringArray);
            }
        }

        public void exec(String[] stringArray) throws IOException {
            Process process = Runtime.getRuntime().exec(stringArray);
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public class ManPageOSTask
        extends OSTask {
            public ManPageOSTask(Install install) {
                super(install, "unix-man");
            }

            public String getDefaultDirectory(Install install) {
                String string = "/usr/local/";
                if (!new File(string).canWrite()) {
                    string = System.getProperty("user.home");
                }
                return new File(string, "man/man1").getPath();
            }

            public void perform(String string, Vector vector) throws IOException {
                if (!this.enabled) {
                    return;
                }
                Unix.this.mkdirs(this.directory);
                String string2 = this.installer.getProperty("app.name");
                String string3 = this.installer.getProperty("ostask.unix-man.manpage");
                InputStream inputStream = this.getClass().getResourceAsStream("/" + string3);
                this.installer.copy(inputStream, new File(this.directory, string3).getPath(), null);
            }
        }

        public class ScriptOSTask
        extends OSTask {
            public ScriptOSTask(Install install) {
                super(install, "unix-script");
            }

            public String getDefaultDirectory(Install install) {
                String string = "/usr/local/";
                if (!new File(string).canWrite()) {
                    string = System.getProperty("user.home");
                }
                return new File(string, "bin").getPath();
            }

            public void perform(String string, Vector vector) throws IOException {
                if (!this.enabled) {
                    return;
                }
                Unix.this.mkdirs(this.directory);
                String string2 = this.installer.getProperty("app.name");
                String string3 = this.directory + File.separatorChar + string2.toLowerCase();
                new File(string3).delete();
                FileWriter fileWriter = new FileWriter(string3);
                fileWriter.write("#!/bin/sh\n");
                fileWriter.write("#\n");
                fileWriter.write("# Runs jEdit - Programmer's Text Editor.\n");
                fileWriter.write("#\n");
                fileWriter.write("\n");
                fileWriter.write("# Set jvm heap initial and maximum sizes (in megabytes).\n");
                fileWriter.write("JAVA_HEAP_MAX_SIZE=192\n");
                fileWriter.write("\n");
                fileWriter.write("DEFAULT_JAVA_HOME=\"" + System.getProperty("java.home") + "\"\n");
                fileWriter.write("if [ -z \"$JAVA_HOME\" ]; then\n");
                fileWriter.write("\tJAVA_HOME=\"$DEFAULT_JAVA_HOME\"\n");
                fileWriter.write("fi\n");
                fileWriter.write("\n");
                fileWriter.write("# Launch application.\n");
                fileWriter.write("\n");
                fileWriter.write("while [ $# -gt 9 ]; do\n");
                String string4 = string + File.separator + string2.toLowerCase() + ".jar";
                fileWriter.write("\texec \"$JAVA_HOME/bin/java\" -Xmx${JAVA_HEAP_MAX_SIZE}M -jar " + string4 + " -reuseview \"$1\" \"$2\"" + " \"$3\" \"$4\" \"$5\" \"$6\"" + " \"$7\" \"$8\" \"$9\"\n");
                fileWriter.write("\tshift 9\n");
                fileWriter.write("done\n");
                fileWriter.write("exec \"$JAVA_HOME/bin/java\" -Xmx${JAVA_HEAP_MAX_SIZE}M -jar " + string4 + " -reuseview \"$1\" \"$2\"" + " \"$3\" \"$4\" \"$5\" \"$6\"" + " \"$7\" \"$8\" \"$9\"\n");
                fileWriter.close();
                String[] stringArray = new String[]{"chmod", "755", string3};
                Unix.this.exec(stringArray);
            }
        }
    }

    public static abstract class OSTask {
        protected Install installer;
        protected String name;
        protected String label;
        protected String directory;
        protected boolean enabled;

        public OSTask(Install install, String string) {
            this.installer = install;
            this.name = string;
            this.label = install.getProperty("ostask." + string + ".label");
            this.directory = this.getDefaultDirectory(install);
            this.enabled = true;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDefaultDirectory(Install install) {
            return null;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setDirectory(String string) {
            this.directory = string;
        }

        public abstract void perform(String var1, Vector var2) throws IOException;
    }
}

