/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.InvalidHeaderException;
import installer.TarBuffer;
import installer.TarEntry;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TarOutputStream
extends FilterOutputStream {
    protected boolean debug;
    protected int currSize;
    protected int currBytes;
    protected byte[] oneBuf;
    protected byte[] recordBuf;
    protected int assemLen;
    protected byte[] assemBuf;
    protected TarBuffer buffer;

    public TarOutputStream(OutputStream outputStream) {
        this(outputStream, 10240, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n, int n2) {
        super(outputStream);
        this.buffer = new TarBuffer(outputStream, n, n2);
        this.debug = false;
        this.assemLen = 0;
        this.assemBuf = new byte[n2];
        this.recordBuf = new byte[n2];
        this.oneBuf = new byte[1];
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setBufferDebug(boolean bl) {
        this.buffer.setDebug(bl);
    }

    public void finish() throws IOException {
        this.writeEOFRecord();
    }

    public void close() throws IOException {
        this.finish();
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        if (tarEntry.getHeader().name.length() > 100) {
            throw new InvalidHeaderException("file name '" + tarEntry.getHeader().name + "' is too long ( > " + 100 + " bytes )");
        }
        tarEntry.writeEntryHeader(this.recordBuf);
        this.buffer.writeRecord(this.recordBuf);
        this.currBytes = 0;
        this.currSize = tarEntry.isDirectory() ? 0 : (int)tarEntry.getSize();
    }

    public void closeEntry() throws IOException {
        if (this.assemLen > 0) {
            for (int i = this.assemLen; i < this.assemBuf.length; ++i) {
                this.assemBuf[i] = 0;
            }
            this.buffer.writeRecord(this.assemBuf);
            this.currBytes += this.assemLen;
            this.assemLen = 0;
        }
        if (this.currBytes < this.currSize) {
            throw new IOException("entry closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
    }

    public void write(int n) throws IOException {
        this.oneBuf[0] = (byte)n;
        this.write(this.oneBuf, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currBytes + n2 > this.currSize) {
            throw new IOException("request to write '" + n2 + "' bytes exceeds size in header of '" + this.currSize + "' bytes");
        }
        if (this.assemLen > 0) {
            if (this.assemLen + n2 >= this.recordBuf.length) {
                n3 = this.recordBuf.length - this.assemLen;
                System.arraycopy(this.assemBuf, 0, this.recordBuf, 0, this.assemLen);
                System.arraycopy(byArray, n, this.recordBuf, this.assemLen, n3);
                this.buffer.writeRecord(this.recordBuf);
                this.currBytes += this.recordBuf.length;
                n += n3;
                n2 -= n3;
                this.assemLen = 0;
            } else {
                System.arraycopy(byArray, n, this.assemBuf, this.assemLen, n2);
                n += n2;
                this.assemLen += n2;
                n2 -= n2;
            }
        }
        while (n2 > 0) {
            if (n2 < this.recordBuf.length) {
                System.arraycopy(byArray, n, this.assemBuf, this.assemLen, n2);
                this.assemLen += n2;
                break;
            }
            this.buffer.writeRecord(byArray, n);
            n3 = this.recordBuf.length;
            this.currBytes += n3;
            n2 -= n3;
            n += n3;
        }
    }

    private void writeEOFRecord() throws IOException {
        for (int i = 0; i < this.recordBuf.length; ++i) {
            this.recordBuf[i] = 0;
        }
        this.buffer.writeRecord(this.recordBuf);
    }
}

