/*
 * 01/09/2002 - 20:43:57
 *
 * NewsAgent.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import info.jdictionary.pluginstuff.PluginDownloader;
import info.jdictionary.gui.NetworkErrorCenteredPanel;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JEditorPane;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.HyperlinkEvent;
import java.awt.Container;
import javax.swing.text.Document;
import java.awt.Cursor;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import java.net.URL;



import java.io.DataInputStream;


public class NewsAgent extends JPanel implements Runnable, HyperlinkListener {

    JDictionary jDictionary;
    boolean success = false;
    JPanel jPanel = new JPanel();
    JLabel header = new JLabel();
    JScrollPane jScrollPane = new JScrollPane();
    JEditorPane newsPane;
    BorderLayout borderLayout = new BorderLayout();
    BoxLayout boxLayout;


    public NewsAgent(JDictionary jDictionary) {

        this.jDictionary = jDictionary;
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void jbInit() throws Exception {

        boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
        setLayout(boxLayout);
        setBackground(Color.white);
        setAlignmentY((float) 0.0);
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));

        jPanel.setBackground(Color.white);
        jPanel.setAlignmentX((float) 0.0);
        jPanel.setMinimumSize(new Dimension(300, 100));
        jPanel.setLayout(borderLayout);
        jPanel.add(new JLabel(JDictionary.getString("DowndloadingNews"), IconBank.hourGlass, 0));

        header.setIcon(ImageBank.getImageByName("NewsAndInfoHeader.png"));

        add(header, null);
        add(jPanel, null);
    }


    void showMessage(String message, ImageIcon icon) {
        final JLabel label = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                jPanel.removeAll();
                jPanel.add(label);
                jPanel.validate();
                jPanel.repaint();
            }
        });
    }


    void showMessage(String message) {
        showMessage(message,null);
    }


    void showComponent(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable() {
           public void run() {
               jPanel.removeAll();
               jPanel.add(component);
               jPanel.validate();
               jPanel.repaint();
           }
        });

    }


    public void run() {
        URL url = getNewsURL();
        //URL url = null; //for testing
        if(url == null) {
            success = false;
            showComponent(new NetworkErrorCenteredPanel(jDictionary));
            return;
        }

        newsPane = new JEditorPane();
        newsPane.setContentType("text/html");
        newsPane.setEditable(false);
        newsPane.addHyperlinkListener(this);
        jScrollPane.getViewport().add(newsPane);
        try {
            //first attempt
            newsPane.setPage(url);
        }
        catch(java.lang.Exception e) {
            try {
            //second attempt. Sourceforge tends to timeout at the first attempt
            newsPane.setPage(url);
            }
            catch(java.lang.Exception ex) {
                ex.printStackTrace();
                success = false;
                showComponent(new NetworkErrorCenteredPanel(jDictionary));
                return;
            }
        }

        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                jPanel.removeAll();
                jPanel.add(jScrollPane);
                jPanel.validate();
                jPanel.repaint();
            }
        });
        success = true;
        jDictionary.getPrefs().lastCheckedNewsVersion = jDictionary.getNewsChecker().getLatest();
        }


    URL getNewsURL() {
        URL url;
        try {
            url = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("NewsPage") + "_" + JDictionary.getLanguage() + ".html");
            if(url.openConnection().getContentLength() > 3800)
                return url;

            url = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("NewsPage")+ ".html");
            if(url.openConnection().getContentLength() > 3800)
                return url;

            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("NewsPage") + "_" + JDictionary.getLanguage()+ ".html");
            if(url.openConnection().getContentLength() > 3800)
                return url;

            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("NewsPage")+ ".html");
            if(url.openConnection().getContentLength() > 3800)
                return url;
        }
        catch(java.net.MalformedURLException e) {}
        catch(java.io.IOException e) {}
        return null;
    }


    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getURL().toString();
            if(url.indexOf("PluginDownloader") != -1)
                if(url.indexOf("download") != -1) {
                    int begining = url.indexOf("(");
                    int end = url.lastIndexOf(")");
                    String fileName = url.substring(begining + 1, end);
                    PluginDownloader pluginDownloader = jDictionary.getPluginDownloader();
                    jDictionary.getAssembler().getOutput().show(pluginDownloader);
                    if(fileName != null) {
                        System.out.println(fileName);
                        pluginDownloader.download(fileName);
                    }
                    return;
            }
            if(url.indexOf("UpgradeAgent") != -1) {
                jDictionary.getAssembler().getOutput().show(jDictionary.getUpgradeAgent());
                return;
            }

            linkActivated(e.getURL());
        }
    }


    protected void linkActivated(URL u) {
        Cursor c = newsPane.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
        newsPane.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }


    public boolean isSuccess() {
        return success;
    }


    class PageLoader implements Runnable {
         PageLoader(URL u, Cursor c) {
            url = u;
            cursor = c;
        }


        public void run() {
            if (url == null) {
                newsPane.setCursor(cursor);
                Container parent = newsPane.getParent();
                parent.repaint();
            }
            else {
                Document doc = newsPane.getDocument();
                try {
                    newsPane.setPage(url);
                } catch (java.io.IOException ioe) {
                    newsPane.setDocument(doc);
                    getToolkit().beep();
                }
                finally { url = null;
                          SwingUtilities.invokeLater(this);
                        } }
        }
        URL url;
        Cursor cursor;
    }
}