package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;

public class KunststoffScrollButton extends MetalScrollButton {
  private Color col1 = new Color(255, 255, 255, 64);
  private Color col2 = new Color(255, 255, 255, 0);
  private Color col3 = new Color(0, 0, 0, 0);
  private Color col4 = new Color(0, 0, 0, 64);

  public KunststoffScrollButton( int direction, int width, boolean freeStanding) {
    super(direction, width, freeStanding);
  }


  /**
   * Calls the super classes paint(Graphics g) method and then paints two gradients.
   * The direction of the gradients depends on the direction of the scrollbar.
   */
  public void paint(Graphics g) {
    super.paint(g);
    int width = getWidth();
    int height = getHeight();
    Graphics2D g2D = (Graphics2D) g;
    Rectangle rec1;
    Rectangle rec2;
    Point grad1Start;
    Point grad1End;
    Point grad2Start;
    Point grad2End;
    if (getDirection() == EAST || getDirection() == WEST) {
      grad1Start = new Point(1, 1);
      grad1End = new Point(1, height/2);
      grad2Start = grad1End;
      grad2End = new Point(1, height);
      rec1 = new Rectangle(grad1Start, new Dimension(width, height/2));
      rec2 = new Rectangle(grad2Start, new Dimension(width, height/2+1));
    } else {
      grad1Start = new Point(1, 1);
      grad1End = new Point(width/2, 1);
      grad2Start = grad1End;
      grad2End = new Point(width, 1);
      rec1 = new Rectangle(grad1Start, new Dimension(width/2, height));
      rec2 = new Rectangle(grad2Start, new Dimension(width/2+1, height));
    }
    GradientPaint gradient1 = new GradientPaint(grad1Start, col1, grad1End, col2);
    GradientPaint gradient2 = new GradientPaint(grad2Start, col3, grad2End, col4);
    g2D.setPaint(gradient1);
    g2D.fill(rec1);
    g2D.setPaint(gradient2);
    g2D.fill(rec2);
  }


}